/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.searchBuses;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.model.BusFare;
import com.gridnine.xtrip.common.bus.model.BusTraveller;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.bus.ibus.BusHelper;
import com.gridnine.xtrip.server.bus.ibus.IBusBusContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AddCommissionsToBusesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List buses = (List)ctx.getMandatoryObject((Enum)IBusBusContextKeys.BUSES);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List busTravellers = (List)ctx.getMandatoryObject((Enum)IBusBusContextKeys.BUS_TRAVELLERS);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        if (Objects.isNull(gdsTracingSettings) || !gdsTracingSettings.isActive() || !gdsTracingSettings.isSaveRulesTraces()) {
            builder = null;
        }
        this.addCommissions(buses, busTravellers, (BookingFile)bookingCtr.getEntity(), (GdsTracingItemBuilder<Bus>)builder);
    }

    private void addCommissions(List<Bus> buses, List<BusTraveller> busTravellers, BookingFile booking, GdsTracingItemBuilder<Bus> builder) {
        Map travellersByPassengerType = busTravellers.stream().collect(Collectors.toMap(BusTraveller::getPassengerType, Function.identity()));
        for (Bus bus : buses) {
            Reservation reservation = (Reservation)CollectionUtil.find((Iterable)booking.getReservations(), (String)bus.getUid());
            if (reservation == null) {
                throw Xeption.forDeveloper((String)"can't find reservation for bus {0}", (Object[])new Object[]{bus.getGdsId()});
            }
            for (BusFare busFare : bus.getFares()) {
                BusTraveller busTraveller = (BusTraveller)travellersByPassengerType.get(busFare.getPassengerType());
                BusProduct product = (BusProduct)BookingHelper.findProduct((BookingFile)booking, (String)BusHelper.buildTravellerBusFareKey(busFare, busTraveller));
                GeneralProductContractRelationData contractRelation = GeneralProductHelper.getContractRelation((BaseProduct)product, (ContractType)ContractType.CLIENT);
                BigDecimal fare = contractRelation.getServiceData().getTotalPrice();
                BigDecimal fee = GeneralProductHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.CLIENT);
                busFare.setEquivalentFare(fare);
                busFare.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, fee}));
                if (!Objects.nonNull(builder)) continue;
                List productRules = RulesHelper.getProductRules((BookingFile)booking, (String)product.getUid());
                builder.traceFlightLogic((BaseEntity)bus, MessageType.MESSAGE, this.buildTraceInfo(busFare, contractRelation, productRules));
            }
        }
    }

    private String buildTraceInfo(BusFare busFare, GeneralProductContractRelationData contractRelation, List<AppliedRule> productRules) {
        BigDecimal fare = busFare.getEquivalentFare();
        BigDecimal total = busFare.getEquivalentAmount();
        BigDecimal fee = total.subtract(fare);
        StringBuilder sb = new StringBuilder();
        sb.append("\n \u0422\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430: ").append(busFare.getPassengerType()).append(" (").append(busFare.getFareCode()).append(")");
        for (AppliedRule ar : productRules) {
            sb.append("\n\u0414\u043e\u0433\u043e\u0432\u043e\u0440 ").append(ar.getContract());
            sb.append(", \u043f\u0440\u0430\u0432\u0438\u043b\u043e ").append(ar.getRuleName());
            sb.append(", \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: ").append(ar.getRuleDescription());
        }
        sb.append("\n");
        sb.append("\n\u0422\u0430\u0440\u0438\u0444 = ").append(fare);
        sb.append("\n\u0421\u0431\u043e\u0440\u044b = ").append(fee);
        sb.append("\n\u0418\u0442\u043e\u0433\u043e = ").append(total);
        try {
            sb.append("\n\ncontractRelation\n");
            sb.append(XSUtil.toString((XSSerializable)contractRelation));
        }
        catch (Exception e) {
            this.log.error("buildTraceInfo failed", (Throwable)e);
        }
        return sb.toString();
    }
}

