/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.searchBuses;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.ReservationStatusHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BuildBookingFileAndApplyRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List reservations = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean trace = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        BookingFile booking = this.buildBooking(reservations, salesContext, travellers);
        EntityContainer bookingCtr = EntityContainer.create((BaseEntity)booking);
        BookingHelper.updateTicketTypes((BookingFile)booking, (TicketType)TicketType.OWN);
        DebugInfo debugInfo = new DebugInfo();
        ArrayList messages = new ArrayList();
        RulesHelper.applyRules((EntityContainer)bookingCtr, (boolean)true, (boolean)true, messages, null, (DebugInfo)debugInfo);
        if (trace) {
            StringBuilder sb = new StringBuilder();
            ObjectTrace.trace((Appendable)sb, (Object)salesContext);
            String msg = String.format("calculating commissions for sales context\r\n%s", sb);
            builder.traceGlobalLogic(MessageType.MESSAGE, msg);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bookingCtr);
    }

    private BookingFile buildBooking(List<Reservation> reservations, SalesContext salesContext, Collection<Traveller> travellers) {
        BookingFile result = new BookingFile();
        result.getTravellers().addAll(travellers);
        result.setAgency(salesContext.getAgency());
        result.setCreateDate(new Date());
        result.setCustomerProfile(salesContext.getClient());
        ReservationStatusHandler statusHandler = (ReservationStatusHandler)Environment.getPublished(ReservationStatusHandler.class);
        for (Reservation reservation : reservations) {
            reservation.setBookingFile(result);
            statusHandler.setNew(reservation);
        }
        result.getReservations().addAll(reservations);
        return result;
    }
}

