/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.searchBuses;

import com.gridnine.xtrip.common.bus.helpers.CommonBusHelper;
import com.gridnine.xtrip.common.bus.model.BaseBusAccount;
import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.model.BusFare;
import com.gridnine.xtrip.common.bus.rules.BusParametersExPropertiesProvider;
import com.gridnine.xtrip.common.bus.rules.BusRulesHelper;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BusProperties
implements BusParametersExPropertiesProvider {
    private static final long serialVersionUID = 4557197226344135595L;
    private final Date issueDate;
    private String salesPoint;
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private final Date departureDate;
    private final Date arrivalDate;
    private final Set<String> fopTypes = new HashSet<String>();
    private final String gdsName;
    private final EntityReference<? extends BaseBusAccount> gdsAccount;
    private final DictionaryReference<PassengerType> passengerType;
    private BigDecimal totalEquivalentFare;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final EntityReference<Person> agent;
    private final EntityReference<Organization> client;
    private final int travelDuration;
    private final List<String> busNumbers = new ArrayList<String>();
    private final List<String> busBrands = new ArrayList<String>();
    private String agencyCode;

    public BusProperties(Bus bus, DictionaryReference<PassengerType> passengerType, SalesContext salesContext) throws Exception {
        DictionaryReference arriveStation;
        BusSegment firstSegment = (BusSegment)bus.getSegments().get(0);
        BusSegment lastSegment = (BusSegment)CollectionUtil.getLastElement((List)bus.getSegments());
        this.agencyCode = CommonHelper.getAgencyCode((SalesContext)salesContext);
        this.issueDate = new Date();
        this.passengerType = passengerType;
        EntityReference salesPointRef = salesContext.getSalesPoint();
        if (salesPointRef != null) {
            this.salesPoint = salesPointRef.getUid();
        }
        this.departureLocations.clear();
        this.arriveLocations.clear();
        this.visitedCities.clear();
        this.gdsName = this.getEnumName(bus.getGds());
        this.gdsAccount = bus.getGdsAccount();
        HashSet<String> geoCodes = new HashSet<String>();
        DictionaryReference departureStation = firstSegment.getDeparture();
        if (departureStation != null) {
            geoCodes.clear();
            geoCodes.add(departureStation.getCode());
            geoCodes.addAll(BusRulesHelper.collectBusCodes(geoCodes, (boolean)true));
            this.departureLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[geoCodes.size()]));
        }
        if ((arriveStation = lastSegment.getArrival()) != null) {
            geoCodes.clear();
            geoCodes.add(arriveStation.getCode());
            geoCodes.addAll(BusRulesHelper.collectBusCodes(geoCodes, (boolean)true));
            this.arriveLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[geoCodes.size()]));
        }
        this.departureDate = firstSegment.getDepartureDate();
        this.arrivalDate = lastSegment.getArrivalDate();
        this.fopTypes.clear();
        this.fopTypes.add(this.getEnumName(PaymentType.INVOICE));
        BusFare busFare = CommonBusHelper.findBusFare((List)bus.getFares(), passengerType);
        this.totalEquivalentFare = busFare.getEquivalentAmount();
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)salesContext.getSubagency());
        this.agent = salesContext.getAgent();
        this.client = salesContext.getClient();
        Date departureDate = firstSegment.getDepartureDate();
        Date arrivalDate = lastSegment.getArrivalDate();
        this.travelDuration = departureDate != null && arrivalDate != null ? (int)MiscUtil.getDuration((Date)departureDate, (Date)arrivalDate, (int)12) : 0;
        this.busNumbers.clear();
        this.busNumbers.add(this.getString(firstSegment.getNumber()));
        this.busBrands.clear();
        this.busBrands.add(this.getString(firstSegment.getBrand()));
    }

    private <E extends Enum<?>> String getEnumName(E value) {
        if (value == null) {
            return null;
        }
        return value.name();
    }

    public BusProduct getProduct() {
        return null;
    }

    public String getPassengerType() {
        return RulesHelper.getDictCode(this.passengerType);
    }

    public Set<String> getPassengerTypeCategories() {
        List passengerTypeCategoryCodes = RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)DictHelper.getAdultPassengerType());
        return new HashSet<String>(passengerTypeCategoryCodes);
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getSalesPoint() {
        return this.salesPoint;
    }

    public String getPnr() {
        return null;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public Set<String> getFopTypes() {
        return this.fopTypes;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public EntityReference<? extends BaseBusAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public BigDecimal getTotalEquivalentFare() {
        return this.totalEquivalentFare;
    }

    public void setTotalEquivalentFare(BigDecimal totalEquivalentFare) {
        this.totalEquivalentFare = totalEquivalentFare;
    }

    private String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return Collections.emptySet();
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public int getTravelDuration() {
        return this.travelDuration;
    }

    public List<String> getBusNumbers() {
        return this.busNumbers;
    }

    public List<String> getBusBrands() {
        return this.busBrands;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }
}

