/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.searchBuses;

import com.gridnine.xtrip.common.bus.model.BusSearchParameters;
import com.gridnine.xtrip.common.bus.model.BusValidationMessages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.server.bus.ibus.BusValidationHelper;
import com.gridnine.xtrip.server.bus.ibus.IBusBusContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class BusSearchParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BusSearchParameters params = (BusSearchParameters)ctx.getMandatoryObject((Enum)IBusBusContextKeys.BUS_SEARCH_PARAMETERS);
        this.validate(params);
    }

    private void validate(BusSearchParameters params) {
        BusSearchParameters.BusSearchParametersValidationContext vc = params.getValidationContext();
        BusValidationHelper.validateDepartuteAndArrival((DictionaryReference<BusStation>)params.getDeparture(), (DictionaryReference<BusStation>)params.getArrival(), vc.getDepartureValidationMessages(), vc.getArrivalValidationMessages());
        Date date = params.getDate();
        Date backDate = params.getBackDate();
        BusValidationHelper.validateDate(date, vc.getDateValidationMessages());
        if (backDate != null) {
            if (date != null && backDate.before(date)) {
                vc.getBackDateValidationMessages().add(BusValidationMessages.getBackDateBeforeStartDate());
            }
            BusValidationHelper.validateDate(backDate, vc.getBackDateValidationMessages());
        }
        BusValidationHelper.validateSeats(params.getSeats(), vc.getSeatsValidationMessages());
        BusValidationHelper.validateChildrenAges(params.getSeats(), params.getChildrenAges(), params.getValidationContext().getChildrenAgesValidationMessages(), params.getValidationContext().getChildrenAgesListValidationMessages());
    }
}

