/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.searchBuses;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.rules.BusParametersActions;
import com.gridnine.xtrip.common.bus.rules.BusParametersExPropertiesProvider;
import com.gridnine.xtrip.common.bus.rules.BusTargets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.bus.ibus.IBusBusContextKeys;
import com.gridnine.xtrip.server.bus.ibus.searchBuses.BusProperties;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class GetRulesProxyForBusProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        Bus bus = (Bus)ctx.getObject((Enum)IBusBusContextKeys.BUS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        if (proxyTracerEnabled == null) {
            proxyTracerEnabled = Boolean.FALSE;
        }
        RuleProxy<BusParametersExPropertiesProvider, BusParametersActions> proxy = this.applyRules(rules, bus, salesContext, proxyTracerEnabled);
        ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXY, proxy);
    }

    private RuleProxy<BusParametersExPropertiesProvider, BusParametersActions> applyRules(RuleSet rules, Bus bus, SalesContext salesContext, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(BusTargets.BUS_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new BusProperties(bus, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), salesContext));
        proxy.setActionSet((Object)new BusParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return proxy;
    }
}

