/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.rules;

import com.gridnine.xtrip.common.bus.rules.BusProductPropertiesProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.bus.rules.BusProductPropertySet;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BusProductCommissionActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = -26227262501241682L;

    public BusProductCommissionActionSet(RuleProxy<BusProductPropertySet, BusProductCommissionActionSet> proxy, BusProductPropertiesProvider propertySet, BusProduct product) {
        super(proxy, (BaseProduct)product, BusProductCommissionActionSet.createHandler(product, propertySet));
    }

    private static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final BusProduct product, final BusProductPropertiesProvider propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            public boolean isOneWayTicket() {
                return true;
            }

            public boolean isForcedRefund() {
                return false;
            }

            public List<ValidationMessage> getValidationMessages() {
                return product.getValidationMessages();
            }

            public TicketType getTicketType() {
                return product.getTicketType();
            }

            public String getTargetType() {
                return "TICKET";
            }

            public ProductStatus getStatus() {
                return product.getStatus();
            }

            public int getSegmentsCount() {
                return product.getSegments().size();
            }

            public ProductType getProductType() {
                return ProductType.BUS;
            }

            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return product.getPreviousProduct() != null ? BusProductCommissionActionSet.createHandler(product.getPreviousProduct(), propertySet) : null;
            }

            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return product.getNextProduct() != null ? BusProductCommissionActionSet.createHandler(product.getNextProduct(), propertySet) : null;
            }

            public BigDecimal getAdditionalFare() {
                return null;
            }

            public Set<String> getPaymentTypes() {
                return propertySet.getFopTypes();
            }

            public Date getIssueDate() {
                return product.getIssueDate();
            }

            public EntityReference<SalesPoint> getSalesPoint() {
                return product.getSalesPoint();
            }

            public int getSegmentTariffsCount() {
                return 0;
            }
        };
    }
}

