/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.rules;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.bus.rules.BusProductPropertiesProvider;
import com.gridnine.xtrip.common.bus.rules.BusRulesHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TranslateSupplierFeesPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravellersPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class BusProductPropertySet
implements Serializable,
BusProductPropertiesProvider,
PayersPropertiesProvider,
TranslateSupplierFeesPropertyProvider,
TravellersPropertyProvider,
UDIDsPropertyProvider,
TicketTypePropertiesProvider,
ProductStatusPropertiesProvider,
EmployeeCategoriesProvider,
ClientCreditCardVendorProvider,
TravelSubjectPropertiesProvider {
    private static final long serialVersionUID = -5745569096852733921L;
    private final RuleProxy<? extends BusProductPropertiesProvider, ?> ruleProxy;
    private final Set<String> blankOwners = new HashSet<String>();
    private final Set<String> passengerTypeCategories = new HashSet<String>();
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private final Set<String> fopTypes = new HashSet<String>();
    private final List<String> busNumbers = new ArrayList<String>();
    private final List<String> busBrands = new ArrayList<String>();
    private final List<String> carriers = new ArrayList<String>();
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    protected String gdsName;
    private BusProduct product;
    private String m_passengerType;
    private Date issueDate;
    private String salesPoint;
    private String pnr;
    private Date departureDate;
    private Date arrivalDate;
    protected BigDecimal totalEquivalentFare;
    private EntityReference<Person> agent;
    private EntityReference<Organization> client;
    private int travelDuration;
    private boolean translateSupplierFees;
    private Collection<EntityReference<Person>> travellers = new ArrayList<EntityReference<Person>>();
    private Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(() -> new ArrayList());
    private String clientCreditCardVendor;
    private String agencyCode;
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;

    public BusProductPropertySet(RuleProxy<? extends BusProductPropertiesProvider, ?> ruleProxy) {
        this.ruleProxy = ruleProxy;
    }

    public BusProduct getProduct() {
        return this.product;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getSalesPoint() {
        return this.salesPoint;
    }

    public String getPnr() {
        return this.pnr;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public Set<String> getPassengerTypeCategories() {
        return this.passengerTypeCategories;
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public Set<String> getFopTypes() {
        return this.fopTypes;
    }

    public String getPassengerType() {
        return this.m_passengerType;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public BigDecimal getTotalEquivalentFare() {
        return this.totalEquivalentFare;
    }

    public int getTravelDuration() {
        return this.travelDuration;
    }

    public List<String> getBusNumbers() {
        return this.busNumbers;
    }

    public List<String> getBusBrands() {
        return this.busBrands;
    }

    public void init(BusProduct product) {
        RuleLogTracer tracer = this.ruleProxy.getTracer();
        tracer.traceEnteringMethod(BusProductPropertySet.class, "init()", new String[0]);
        try {
            this.product = product;
            this.agent = product.getAgent();
            if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
                this.client = product.getReservation().getBookingFile().getCustomerProfile();
            }
            this.agencyCode = CommonProductHelper.getAgencyCode((BaseProduct)product);
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)GeneralProductHelper.getSubagency((BaseProduct)product));
            CommonProductHelper.addProfileGroups(this.profileGroups, this.agent);
            this.setTravelSubject(ProductHandler.of((BaseProduct)product).findTravelSubject((BaseProduct)product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)product));
            if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
                CommonProductHelper.addProfileGroups(this.profileGroups, (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
            }
            EntityReference blankOwnerReference = product.getBlankOwner();
            EntityContainer blankOwnerContainer = EntityStorage.get().resolve(blankOwnerReference);
            if (blankOwnerContainer != null) {
                Organization blankOwner = (Organization)EntityStorage.get().resolve(blankOwnerReference).getEntity();
                this.blankOwners.clear();
                this.blankOwners.add(blankOwner.getCode());
                this.blankOwners.addAll(blankOwner.getShortName().getValues().values());
                this.blankOwners.addAll(blankOwner.getFullName().getValues().values());
            }
            this.m_passengerType = RulesHelper.getDictCode((DictionaryReference)product.getPassengerType());
            this.passengerTypeCategories.clear();
            this.passengerTypeCategories.addAll(RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)product.getPassengerType()));
            this.issueDate = product.getIssueDate();
            EntityReference salesPointReference = product.getSalesPoint();
            if (salesPointReference != null) {
                this.salesPoint = product.getSalesPoint().getUid();
            }
            this.pnr = BusProductPropertySet.getString(product.getReservation() != null ? CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()) : null);
            this.departureLocations.clear();
            this.arriveLocations.clear();
            this.visitedCities.clear();
            this.busNumbers.clear();
            this.busBrands.clear();
            this.carriers.clear();
            this.travelDuration = 0;
            for (BusSegment segment : product.getSegments()) {
                Integer durationInMinutes;
                DictionaryReference arriveStation;
                HashSet<String> geoCodes = new HashSet<String>();
                DictionaryReference departureStation = segment.getDeparture();
                if (departureStation != null) {
                    geoCodes.clear();
                    geoCodes.add(departureStation.getCode());
                    geoCodes.addAll(BusRulesHelper.collectBusCodes(geoCodes, (boolean)true));
                    this.departureLocations.addAll(geoCodes);
                    this.visitedCities.add(geoCodes.toArray(new String[geoCodes.size()]));
                }
                if ((arriveStation = segment.getArrival()) != null) {
                    geoCodes.clear();
                    geoCodes.add(arriveStation.getCode());
                    geoCodes.addAll(BusRulesHelper.collectBusCodes(geoCodes, (boolean)true));
                    this.arriveLocations.addAll(geoCodes);
                    this.visitedCities.add(geoCodes.toArray(new String[geoCodes.size()]));
                }
                this.addToList(segment.getNumber(), this.busNumbers);
                this.addToList(segment.getBrand(), this.busBrands);
                this.addToList(segment.getCarrier(), this.carriers);
                if (this.departureDate == null || this.departureDate.after(segment.getDepartureDate())) {
                    this.departureDate = segment.getDepartureDate();
                }
                if (this.arrivalDate == null || this.arrivalDate.before(segment.getArrivalDate())) {
                    this.arrivalDate = segment.getArrivalDate();
                }
                this.travelDuration += (durationInMinutes = segment.getWayTimeMinutes()) != null ? durationInMinutes : 0;
            }
            this.fopTypes.clear();
            for (GeneralProductFop fop : BusProductHelper.getClientFops((BusProduct)product)) {
                PaymentType paymentType = fop.getType();
                if (paymentType == null) continue;
                this.fopTypes.add(BusProductPropertySet.getEnumName(paymentType));
            }
            this.gdsName = BusProductPropertySet.getEnumName(product.getReservation() != null ? CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)product.getReservation()) : null);
            this.totalEquivalentFare = product.getEquivalentFare();
            this.payers.addAll(PayersCollector.collect((BaseProduct)product));
            product.getTravellers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.travellers::add);
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)product));
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor((BaseProduct)product);
        }
        catch (Exception e) {
            tracer.traceError("unable to initialize bus property set", (Throwable)e);
            throw e;
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(BusProductPropertySet.class, "init()", new String[0]);
        }
    }

    public Collection<EntityReference<Person>> getTravellers() {
        return this.travellers;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public boolean isTranslateSupplierFees() {
        return this.translateSupplierFees;
    }

    public void setTranslateSupplierFees(boolean value) {
        this.translateSupplierFees = value;
    }

    public List<CostCode> getCostCodes() {
        return StatisticsHelper.getAllCostCodes((StatisticalData)this.product.getStatisticalData());
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    private static <E extends Enum<?>> String getEnumName(E value) {
        return value == null ? null : value.name();
    }

    private void addToList(String value, List<String> list) {
        if (!TextUtil.isBlank((String)value) && !list.contains(value)) {
            list.add(value);
        }
    }

    private static String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }
}

