/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.storage.indexes;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.util.Collection;
import java.util.List;

public class BusCommonProductIndexHandler
extends BaseCommonProductIndexHandler {
    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof BusProduct)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler handler : handlers) {
                        handler.updateData((BaseIndexData)data, aggregator, etc, (BaseEntity)baseProduct);
                    }
                    data.setAggregator(aggregator);
                    this.updateData(data, etc, (BusProduct)baseProduct);
                    this.updateAggregator(aggregator, (BusProduct)baseProduct);
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, EntityContainer<BookingFile> etc, BusProduct product) {
        super.updateData(data, (BaseProduct)product);
        data.setComments(product.getComments());
    }

    protected void updateAggregator(DataAggregator aggregator, BusProduct product) {
    }
}

