/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.storage.indexes;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusProductIndex;
import com.gridnine.xtrip.common.model.booking.bus.BusProductIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusProductIndexHandler
implements IndexHandler<BookingFile, BusProductIndex> {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, BusProductIndex>> getDataClass() {
        return BusProductIndexData.class;
    }

    public Class<BusProductIndex> getIndexClass() {
        return BusProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, BusProductIndex>> indexes) throws Exception {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof BusProduct)) continue;
                BusProductIndexData data = new BusProductIndexData();
                indexes.add((BaseIndexData<BookingFile, BusProductIndex>)data);
                data.setAggregator(aggregator);
                this.fill(data, aggregator, (BusProduct)baseProduct, bookingFile);
                data.setAggregatedData(aggregator.toString());
                aggregator.reset();
            }
        }
    }

    private void fill(BusProductIndexData data, DataAggregator aggregator, BusProduct product, BookingFile bookingFile) {
        Reservation reservation = product.getReservation();
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)reservation.getBookingFile());
        data.setAgency(bookingFile.getAgency());
        aggregator.aggregate((Object)bookingFile.getAgency());
        data.setAgent(product.getAgent());
        data.setBlankOwner(product.getBlankOwner());
        data.setBookingNumber(bookingNumber);
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setClient(bookingFile.getCustomerProfile());
        aggregator.aggregate((Object)bookingFile.getCustomerProfile());
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        ProductStatus status = handler.getStatus((BaseProduct)product);
        boolean refund = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
        BigDecimal equivalentTotalFare = product.getEquivalentFare();
        if (equivalentTotalFare != null) {
            data.setEquivalentTotalFare(refund ? equivalentTotalFare.negate() : equivalentTotalFare);
        }
        data.setEquivalentFareCurrency(product.getGdsCurrency());
        VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        data.setTotalSum(price.getTotal());
        data.setVatRate(price.getVat());
        data.setVatValue(price.getVatAmount());
        data.setGdsNames((Collection)IndexBuilderHelper.getGdsNames((Reservation)reservation));
        data.setDisplayedGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation));
        data.setRecordLocators((Collection)IndexBuilderHelper.getRecordLocators((Reservation)reservation));
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.TRUE);
        }
        data.setIssueDate(product.getIssueDate());
        data.setPenalty(product.getPenalty());
        data.setRouteLine(BusProductHelper.getRouteLine((BusProduct)product));
        data.setSalesPoint(product.getSalesPoint());
        data.setStartDate(BusProductHelper.getFirstDepartureDate((BusProduct)product));
        data.setStatus(product.getStatus());
        data.setSubagency(reservation.getSubagency());
        data.setSupplier(GeneralProductHelper.getSupplier((BaseProduct)product));
        data.setSystemNumber(product.getSystemNumber());
        data.setTicketType(product.getTicketType());
        data.setTimeLimit(reservation.getTimeLimit());
        data.setTravellers((Collection)product.getTravellers().stream().map(Traveller::getName).collect(Collectors.toList()));
        data.setComments(product.getComments());
        aggregator.aggregate((Object)product.getComments());
        try {
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            GeneralProductContractRelationData vendorContractRelation = GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)product);
            this.updateVendorFopsData(data, vendorContractRelation.getFops(), status, refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating commissions ", (Throwable)e);
        }
        data.setNavigationKey(product.getUid());
    }

    private void updateVendorFopsData(BusProductIndexData data, List<GeneralProductFop> vendorFops, ProductStatus status, boolean refund) {
        if (status == ProductStatus.VOID) {
            return;
        }
        BigDecimal vendorFOPAmount = null;
        for (GeneralProductFop fop : vendorFops) {
            vendorFOPAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vendorFOPAmount, fop.getEquivalentAmount()});
        }
        if (vendorFOPAmount != null) {
            data.setVendorFopAmount(refund ? vendorFOPAmount.negate() : vendorFOPAmount);
        }
    }
}

