/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.h2;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.ConnectionFactory;
import com.gridnine.xtrip.server.db.ConnectionInfo;
import com.gridnine.xtrip.server.db.DbAdapter;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Adapter
implements DbAdapter {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public void cleanup(ConnectionFactory connFactory, ConnectionInfo cnnInfo) throws Exception {
        String prefix;
        String location = cnnInfo.getUrl();
        if (!location.startsWith(prefix = "jdbc:h2:")) {
            throw new Exception("unknown H2 database URL " + location);
        }
        File folder = new File(location = location.substring(prefix.length())).getParentFile();
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("failed creating H2 database folder " + folder);
        }
        if (!IoUtil.emptyFolder((File)folder)) {
            throw new IOException("failed cleaning up H2 database folder " + folder);
        }
        this.log.info("H2 database folder cleanup done " + folder);
    }

    public void maintain(ConnectionFactory connFactory, ConnectionInfo cnnInfo) throws Exception {
        this.log.warn("maintenance procedure disabled for H2 engine");
    }

    public String preprocessSQL(String sql) {
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(ConnectionFactory connFactory, ConnectionInfo cnnInfo) throws Exception {
        Connection cnn = connFactory.createConnection();
        Statement statement = null;
        try {
            statement = cnn.createStatement();
            statement.execute("SHUTDOWN");
            this.log.info("DB SHUTDOWN executed");
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            cnn.close();
        }
    }
}

