/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.idfs;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.idfs.ServerException;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueBundle;
import com.gridnine.xtrip.server.db.storage.replication.keyvalue.driver.KeyValueStorageDriver;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements KeyValueStorageDriver {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String URL_PARAMETER = "url";
    public static final String NAMESPACE_PARAMETER = "namespace";
    public static final String NAME_PARAMETER = "name";
    private URI url;
    private CloseableHttpClient client;
    private static final String METRICS_ROOT = "profiling.idfs.";
    private String name = "(no name)";
    private String namespace = null;
    private final ContentType DELETE_CONTENT_TYPE = ContentType.create((String)"application/delete");

    public void configure(Map<String, String> parameters) {
        String nameParam;
        String urlParam = parameters.get(URL_PARAMETER);
        if (null == urlParam) {
            throw new IllegalArgumentException("the url was not specified");
        }
        String namespaceParam = parameters.get(NAMESPACE_PARAMETER);
        if (TextUtil.nonBlank((String)namespaceParam)) {
            this.namespace = namespaceParam;
        }
        if (TextUtil.nonBlank((String)(nameParam = (String)MiscUtil.guarded((Object)parameters.get(NAME_PARAMETER), (Object)namespaceParam, (Object[])new String[]{urlParam})))) {
            this.name = nameParam;
        }
        this.setURL(urlParam);
        this.client = this.createClient(parameters);
    }

    private void setURL(String urlParam) {
        URI uri;
        String p;
        String uriParam = urlParam;
        if (!uriParam.contains("://")) {
            uriParam = "http://" + uriParam;
        }
        if (!(p = (String)MiscUtil.guarded((Object)(uri = URI.create(uriParam)).getPath(), (Object)"")).endsWith("/")) {
            p = p + "/";
        }
        if (TextUtil.nonBlank((String)this.namespace)) {
            if (!p.endsWith("/ns/")) {
                p = p + "ns/";
            }
            p = p + this.namespace + "/";
        } else if (!p.endsWith("/rest/")) {
            p = p + "rest/";
        }
        try {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort() != -1 ? uri.getPort() : 9095, p, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.url = uri;
    }

    protected CloseableHttpClient createClient(Map<String, String> parameters) {
        HttpClientBuilder builder = HttpClients.custom();
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout(this.getValue(parameters.get("connectTimeout"), Integer.getInteger("sun.net.client.defaultConnectTimeout", -1)));
        requestConfig.setSocketTimeout(this.getValue(parameters.get("socketTimeout"), Integer.getInteger("sun.net.client.defaultReadTimeout", -1)));
        requestConfig.setSocketTimeout(this.getValue(parameters.get("connectionRequestTimeout"), -1));
        builder.setDefaultRequestConfig(requestConfig.build());
        String poolSize = parameters.get("poolSize");
        if (!TextUtil.isBlank((String)poolSize)) {
            try {
                int value = Integer.parseInt(poolSize);
                PoolingHttpClientConnectionManager cm = null;
                String timeToLive = parameters.get("timeToLive");
                if (!TextUtil.isBlank((String)timeToLive)) {
                    try {
                        cm = new PoolingHttpClientConnectionManager((long)Integer.parseInt(timeToLive), TimeUnit.MILLISECONDS);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (null == cm) {
                    cm = new PoolingHttpClientConnectionManager();
                }
                cm.setMaxTotal(value);
                cm.setDefaultMaxPerRoute(value);
                builder.setConnectionManager((HttpClientConnectionManager)cm);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        builder.setRetryHandler(new HttpRequestRetryHandler(){
            private final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(1L);
            private static final int TIME_SLICE = 250;
            private final int MAX_COUNT = this.calc(this.MAX_WAIT_TIME, 1);

            private int calc(long time, int i) {
                long t = i * 250;
                if (t > time) {
                    return i - 1;
                }
                return this.calc(time - t, i + 1);
            }

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > this.MAX_COUNT) {
                    return false;
                }
                try {
                    Thread.sleep(250 * executionCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        });
        return builder.build();
    }

    private int getValue(String value, int def) {
        if (TextUtil.nonBlank((String)value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public void dispose() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                this.log.error("an unexpected error has occurred", (Throwable)e);
            }
        }
        this.url = null;
    }

    public void setupScheme(boolean cleanupMode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkHealth() {
        long timing = System.currentTimeMillis();
        try {
            boolean bl;
            Throwable throwable;
            CloseableHttpResponse response;
            block17: {
                block18: {
                    HttpGet request = new HttpGet(this.healthURL());
                    response = this.client.execute((HttpUriRequest)request);
                    throwable = null;
                    boolean bl2 = bl = response.getStatusLine().getStatusCode() == 200;
                    if (response == null) break block17;
                    if (throwable == null) break block18;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block17;
                }
                response.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (response != null) {
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable t) {
                    Metrics.get().timingAndEvent(METRICS_ROOT + this.name + ".checkHealth.fail." + Driver.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key((String[])new String[]{t.getMessage().toLowerCase()}) : ""), timing);
                    this.log.error("checkHealth failed", t);
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            Metrics.get().timingAndEvent(METRICS_ROOT + this.name + ".checkHealth", timing);
        }
    }

    public void maintain() {
    }

    /*
     * Exception decompiling
     */
    public boolean has(String key) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public KeyValueBundle get(String key, Collection<Integer> versionNumbers) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public KeyValueBundle all(String key) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private KeyValueBundle processDataResponse(CloseableHttpResponse response) throws UnsupportedOperationException, MimeException, IOException, ServerException {
        if (response.getStatusLine().getStatusCode() == 404) {
            return null;
        }
        this.checkError(response);
        final KeyValueBundle result = new KeyValueBundle();
        ContentHandler handler = new ContentHandler(){
            private String fieldName;

            public void startBodyPart() {
                this.fieldName = null;
            }

            public void field(Field filed) throws MimeException {
                if (!"Content-Disposition".equals(filed.getName())) {
                    return;
                }
                try {
                    this.fieldName = new ContentDisposition(filed.getBody()).getParameter(Driver.NAME_PARAMETER);
                }
                catch (ParseException e) {
                    throw new MimeException((Throwable)e);
                }
            }

            public void body(BodyDescriptor bd, InputStream in) throws IOException {
                byte[] bytes;
                byte[] byArray = bytes = !"application/not-found".equals(bd.getMimeType()) ? IOUtils.toByteArray((InputStream)in) : null;
                if (null == bytes || ".".equals(this.fieldName)) {
                    return;
                }
                if (".metadata".equals(this.fieldName)) {
                    result.setMetadata(bytes);
                    return;
                }
                try {
                    Integer version = new Integer(Integer.parseInt(this.fieldName));
                    result.getVersions().put(version, bytes);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            public void endBodyPart() {
            }

            public void endHeader() {
            }

            public void endMessage() {
            }

            public void endMultipart() {
            }

            public void epilogue(InputStream in) {
            }

            public void preamble(InputStream in) {
            }

            public void raw(InputStream in) {
            }

            public void startHeader() {
            }

            public void startMessage() {
            }

            public void startMultipart(BodyDescriptor bd) {
            }
        };
        MimeConfig config = new MimeConfig();
        config.setHeadlessParsing(response.getEntity().getContentType().getValue());
        MimeStreamParser parser = new MimeStreamParser(config);
        parser.setContentHandler(handler);
        parser.parse(response.getEntity().getContent());
        return result;
    }

    public void put(String key, KeyValueBundle bundle) throws Exception {
        long timing = System.currentTimeMillis();
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (bundle.getMetadata() != null) {
                builder.addBinaryBody(".metadata", bundle.getMetadata());
            }
            for (Map.Entry version : bundle.getVersions().entrySet()) {
                byte[] content = (byte[])version.getValue();
                if (content != null) {
                    builder.addBinaryBody(((Integer)version.getKey()).toString(), content);
                    Metrics.get().valueAndSum(METRICS_ROOT + this.name + ".put", (long)content.length);
                    continue;
                }
                builder.addTextBody(((Integer)version.getKey()).toString(), "", this.DELETE_CONTENT_TYPE);
            }
            HttpPost request = new HttpPost(this.modifyURL(this.prepareKey(key)));
            request.setEntity(builder.build());
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                this.checkError(response);
            }
        }
        catch (Throwable t) {
            Metrics.get().timingAndEvent(METRICS_ROOT + this.name + ".put.fail." + Driver.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key((String[])new String[]{t.getMessage().toLowerCase()}) : ""), timing);
            throw t;
        }
        finally {
            Metrics.get().timingAndEvent(METRICS_ROOT + this.name + ".put", timing);
        }
    }

    public void delete(String key) throws Exception {
        long timing = System.currentTimeMillis();
        try {
            HttpDelete request = new HttpDelete(this.modifyURL(this.prepareKey(key)));
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                this.checkError(response);
            }
        }
        catch (Throwable t) {
            Metrics.get().timingAndEvent(METRICS_ROOT + this.name + ".delete.fail." + Driver.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key((String[])new String[]{t.getMessage().toLowerCase()}) : ""), timing);
            throw t;
        }
        finally {
            Metrics.get().timingAndEvent(METRICS_ROOT + this.name + ".put", timing);
        }
    }

    private void checkError(CloseableHttpResponse response) throws ServerException {
        int status = response.getStatusLine().getStatusCode();
        if (status != 200 && status != 201 && status != 204) {
            String body;
            try {
                body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (IOException ex) {
                body = "failed to get http body " + TextUtil.getExceptionStackTrace((Throwable)ex);
            }
            throw new ServerException(String.format("%s\n%s", response.getStatusLine().toString(), body));
        }
    }

    private String prepareKey(String key) throws UnsupportedEncodingException {
        return URLEncoder.encode(key, "UTF-8");
    }

    private URI healthURL() throws URISyntaxException {
        return new URI(this.url.getScheme(), this.url.getUserInfo(), this.url.getHost(), this.url.getPort(), "/health", null, null);
    }

    private URI modifyURL(String path) throws URISyntaxException {
        return new URI(this.url.getScheme(), this.url.getUserInfo(), this.url.getHost(), this.url.getPort(), this.url.getPath() + path, this.url.getQuery(), this.url.getFragment());
    }

    private static String getLabel(String camel) {
        StringBuilder sb = new StringBuilder();
        int l = 0;
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && (l > 0 || 0 == l && i + 1 < camel.length() && Character.isLowerCase(camel.charAt(i + 1)))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                l = 0;
                continue;
            }
            sb.append(c);
            ++l;
        }
        return sb.toString();
    }
}

