/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.postgresql;

import com.gridnine.xtrip.server.db.ConnectionFactory;
import com.gridnine.xtrip.server.db.ConnectionInfo;
import com.gridnine.xtrip.server.db.DbAdapter;
import java.sql.Connection;
import java.sql.Statement;

public class PostgreSQLAdapter
implements DbAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(ConnectionFactory connFactory, ConnectionInfo cnnInfo) throws Exception {
        Connection cnn = connFactory.createConnection();
        Statement st = null;
        try {
            st = cnn.createStatement();
            st.executeUpdate("DROP SCHEMA public CASCADE");
            st.executeUpdate("CREATE SCHEMA public AUTHORIZATION \"" + cnnInfo.getUser() + "\"");
            st.executeUpdate("GRANT ALL ON SCHEMA public TO \"" + cnnInfo.getUser() + "\"");
            st.executeUpdate("COMMENT ON SCHEMA public IS 'Standard xTrip schema'");
            cnn.commit();
        }
        finally {
            if (st != null) {
                st.close();
            }
            if (!cnn.isClosed()) {
                cnn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintain(ConnectionFactory connFactory, ConnectionInfo cnnInfo) throws Exception {
        Connection cnn = connFactory.createConnection();
        boolean autocommit = cnn.getAutoCommit();
        cnn.setAutoCommit(true);
        Statement st = null;
        try {
            st = cnn.createStatement();
            st.executeUpdate("VACUUM ANALYZE;");
        }
        finally {
            if (!cnn.isClosed()) {
                cnn.setAutoCommit(autocommit);
            }
            if (st != null) {
                st.close();
            }
            if (!cnn.isClosed()) {
                cnn.close();
            }
        }
    }

    public String preprocessSQL(String sql) {
        return sql;
    }

    public void dispose(ConnectionFactory connFactory, ConnectionInfo cnnInfo) throws Exception {
    }
}

