/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ens;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.ens.model.ENSLogItem;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ENSInvocationContext {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<ENSInvocationContext> contexts = new ThreadLocal<ENSInvocationContext>(){

        @Override
        protected ENSInvocationContext initialValue() {
            return new ENSInvocationContext();
        }
    };
    private static final String NOTIFICATION = "Notificaiton";
    private final List<TraceData> traceData = new ArrayList<TraceData>();

    public static ENSInvocationContext get() {
        return contexts.get();
    }

    public void begin() {
        this.traceData.clear();
        this.log.debug("BEGIN Notificaiton");
    }

    public void addTraceData(Date startDate, String transactionName, Element notification, Throwable e) {
        this.traceData.add(new TraceData(startDate, transactionName, notification, e));
    }

    public List<TraceData> getTraceData() {
        return this.traceData;
    }

    public void end(Tracer tracer, List<ENSLogItem> ensLog) {
        ENSLogItem logItem = null;
        if (tracer != null && (logItem = this.buildLogItem()) != null) {
            tracer.trace(new TraceItem[]{new ENSTraceItem(NOTIFICATION, logItem)});
        }
        if (ensLog != null) {
            if (logItem == null) {
                logItem = this.buildLogItem();
            }
            if (logItem != null) {
                ensLog.add(logItem);
            }
        }
        this.traceData.clear();
        this.log.debug("END Notificaiton");
    }

    private ENSLogItem buildLogItem() {
        if (this.traceData.isEmpty()) {
            return null;
        }
        ENSLogItem result = new ENSLogItem();
        result.setName(NOTIFICATION);
        result.setDate(new Date());
        result.setTitle("Notification");
        result.setContentType(ContentType.XML);
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("ws-notification");
        doc.appendChild(root);
        for (TraceData data : this.traceData) {
            try {
                root.appendChild(ENSInvocationContext.buildElement(doc, data));
            }
            catch (Throwable t) {
                this.log.error("failed building log element", t);
            }
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(output));
            result.setTraceData(output.toByteArray());
        }
        catch (Throwable t) {
            this.log.error("failed rendering trace data", t);
        }
        return result;
    }

    private static Element buildElement(Document doc, TraceData data) {
        Element result = doc.createElement("notification");
        result.setAttribute("name", data.transaction);
        if (data.date1 != null) {
            result.setAttribute("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(data.date1));
            result.setAttribute("timing", String.valueOf(data.date2.getTime() - data.date1.getTime()));
        }
        if (data.notification != null) {
            result.appendChild(doc.importNode(data.notification, true));
        }
        if (data.error != null) {
            Element errElm = (Element)result.appendChild(doc.createElement("error"));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            data.error.printStackTrace(printWriter);
            printWriter.flush();
            XmlUtil.setValue((Element)errElm, (String)stringWriter.toString());
        }
        return result;
    }

    public static class ENSTraceItem
    implements TraceItem {
        private final String invocationName;
        private final ENSLogItem logItem;
        private final String id;

        ENSTraceItem(String name, ENSLogItem item) {
            this.invocationName = name;
            this.logItem = item;
            this.id = String.format("%s-%s.xml", this.invocationName, MiscUtil.getTimestamp());
        }

        public String getId() {
            return this.id;
        }

        public void write(OutputStream strm) throws IOException {
            strm.write(this.logItem.getTraceData());
        }
    }

    public static class TraceData {
        final Date date1;
        final Date date2;
        final String transaction;
        final Element notification;
        final Throwable error;

        TraceData(Date startDate, String tr, Element value, Throwable e) {
            this.date1 = startDate;
            this.date2 = new Date();
            this.transaction = tr;
            this.notification = value;
            this.error = e;
        }
    }
}

