/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ens;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ens.export.model.ENSExportDocument;
import com.gridnine.xtrip.common.ens.model.ENSLogItem;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ens.ENSInvocationContext;
import com.gridnine.xtrip.server.ens.ENSService;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ENSServlet
extends HttpServlet {
    private static final long serialVersionUID = -9024143301802902198L;
    private static final transient Logger log = LoggerFactory.getLogger(ENSServlet.class);
    private static final transient String MY_SUBSCRIPTION_TAG = "<wse:MySubscription>";
    private static final transient int TAG_LEN = "<wse:MySubscription>".length();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DebugUtil.setThreadName((String)"ENSServlet-service");
        try {
            if (request.getMethod().equals("POST")) {
                Date startDate = new Date();
                MiscUtil.Pair<Set<String>, byte[]> notifications = ENSServlet.recieveNotification(request.getReader());
                notifications.setSecond((Object)ENSServlet.convert((byte[])notifications.getSecond()));
                ENSServlet.trace((byte[])notifications.getSecond(), startDate);
                ENSServlet.exportNotifications(notifications, startDate);
            }
        }
        catch (Exception e) {
            log.error("failed to receive the notification", (Throwable)e);
        }
        finally {
            response.setStatus(202);
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportNotifications(MiscUtil.Pair<Set<String>, byte[]> notifications, Date date) throws Exception {
        try {
            LogicalStorage.get().authorizeAsSystem();
            EntityContainer exportDocument = new EntityContainer(ENSExportDocument.class);
            String user = LogicalStorage.get().getUser();
            exportDocument.setCreated(new Date());
            exportDocument.setCreatedBy(user);
            exportDocument.setModified(new Date());
            exportDocument.setModifiedBy(user);
            String pccs = ((Set)notifications.getFirst()).toString();
            ((ENSExportDocument)exportDocument.getEntity()).setPcc(pccs.substring(1, pccs.length() - 1));
            ((ENSExportDocument)exportDocument.getEntity()).setNotification((byte[])notifications.getSecond());
            ((ENSExportDocument)exportDocument.getEntity()).setDescription("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 ens notification : " + date.getTime());
            ((ENSExportDocument)exportDocument.getEntity()).setTitle("notification " + date.getTime());
            LogicalStorage.get().getEntityStorage().save(exportDocument, true);
        }
        finally {
            LogicalStorage.reset();
        }
    }

    private static byte[] convert(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        StreamSource src = new StreamSource(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        XUtil.newTransformer().transform(src, result);
        return baos.toByteArray();
    }

    private static MiscUtil.Pair<Set<String>, byte[]> recieveNotification(BufferedReader br) throws IOException {
        String notification;
        StringBuilder sb = new StringBuilder(256);
        while ((notification = br.readLine()) != null) {
            sb.append(notification).append("\n");
        }
        return new MiscUtil.Pair(ENSServlet.getPCCs(sb.toString()), (Object)sb.toString().getBytes());
    }

    private static Set<String> getPCCs(String notification) {
        HashSet<String> pccs = new HashSet<String>(3);
        int i = notification.indexOf(MY_SUBSCRIPTION_TAG, 0);
        while (i != -1) {
            pccs.add(notification.substring(i + TAG_LEN, i + TAG_LEN + 4));
            i = notification.indexOf(MY_SUBSCRIPTION_TAG, i + TAG_LEN);
        }
        return pccs;
    }

    private static ENSLogItem trace(byte[] notification, Date date) {
        ENSLogItem item = new ENSLogItem();
        item.setName("notification");
        item.setDate(date);
        item.setTitle("notification");
        item.setContentType(ContentType.XML);
        item.setTraceData(notification);
        ((ENSService)((ServerApplication)Environment.getPublished(ServerApplication.class)).getService("ens")).getTracer().trace(new TraceItem[]{new ENSInvocationContext.ENSTraceItem("notification", item)});
        return item;
    }
}

