/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bus.handler;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.bus.helpers.clone.BusProductCloneHelper;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BusProductFXHandler
extends BaseProductFXHandler<BusProduct> {
    public void setSubAgency(BusProduct product, EntityReference<Organization> subagency) {
        BusProductHelper.setSubagency((BusProduct)product, subagency);
    }

    public Class<BusProduct> getProductClass() {
        return BusProduct.class;
    }

    public Collection<? extends Message> sellProduct(BusProduct product, String number) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getNextProduct() == null && product.getStatus().equals((Object)ProductStatus.BOOKING)) {
            product.setStatus(ProductStatus.SELL);
        } else {
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430", (Object[])new Object[0]));
        }
        return errorList;
    }

    public Collection<? extends Message> unsellProduct(BusProduct product) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() == null && product.getNextProduct() == null) {
            product.setStatus(ProductStatus.BOOKING);
        } else {
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430", (Object[])new Object[0]));
        }
        return errorList;
    }

    public List<Message> recalculateFOP(BusProduct product, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)product, (ProductStatus[])appropriateStatusArray, GeneralProductHelper::updateFops, (ProductStatus)product.getStatus(), ctr);
    }

    public BookingFileService.ProductRPCResult refundProduct(BusProduct product, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        String productName = BookingHelper.generateShortProductName((BaseProduct)product);
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (product.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productName, (String)ProductStatus.SELL.toString()));
        } else if (product.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productName));
        } else {
            try {
                BusProduct refundProduct = BusProductHelper.createRefund((BusProduct)product);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productName, (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    public List<Message> cloneProductToSameReservation(BusProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation((BaseProduct)source, bookingFileContainer, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewReservation(BusProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation((BaseProduct)source, bookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewBookingFile(BusProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile((BaseProduct)source, sourceBookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, targetBookingFileContainer, (int)amount, (boolean)forwardAgencyMemo, targetClient, (boolean)changeRetailPayer, this.createCloneHandler());
    }

    public List<Message> cloneProductForCorrection(BusProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return BusProductFXHandler.cloneProductForCorrection((BaseProduct)source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<BusProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<BusProduct>(){
            final Date date = new Date();

            public BusProduct createProduct() {
                return new BusProduct();
            }

            public void cloneProduct(BusProduct source, BusProduct target) throws Exception {
                BusProductCloneHelper.clone((BusProduct)source, (BusProduct)target);
            }

            public void cloneProduct(BusProduct source, BusProduct target, Map<String, String> uidsMapping) throws Exception {
                BusProductCloneHelper.clone((BusProduct)source, (BusProduct)target, uidsMapping);
            }

            public void updateProduct(BusProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            public void updateProductsForCorrection(BusProduct source, BusProduct target, Map<String, String> uidsMapping) {
            }

            public void resetTraveller(BusProduct target) {
                target.getTravellers().clear();
            }
        };
    }
}

