/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bus.handler;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.fx.bus.model.uidata.BusProductUIData;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BusProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof BusProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (BusProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private BusProductUIData createProductUIData(BookingFile bookingFile, BusProduct product) {
        BusProductUIData uiData = new BusProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(GeneralProductHelper.getSupplier((BaseProduct)product));
        uiData.setAgency(GeneralProductHelper.getAgency((BaseProduct)product));
        uiData.setSubagency(GeneralProductHelper.getSubagency((BaseProduct)product));
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof BusProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof BusProductUIData && products.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((BusProduct)products.get(product.getRelatedProductUID()), (BusProductUIData)product);
            }
        });
    }

    private void saveProductUIData(BusProduct product, BusProductUIData uiData) {
        BusProductHelper.setAgency((BusProduct)product, (EntityReference)uiData.getAgency());
        BusProductHelper.setSubagency((BusProduct)product, (EntityReference)uiData.getSubagency());
        BusProductHelper.setSupplier((BusProduct)product, (EntityReference)uiData.getSupplier());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

