/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bus.rpc;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.fx.bus.model.uidata.BusProductUIData;
import com.gridnine.xtrip.common.fx.bus.rpc.BusProductPrototypeService;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Date;

public class BusProductPrototypeServiceImpl
extends BaseSecureServiceImpl
implements BusProductPrototypeService {
    public MiscUtil.Pair<BusProduct, BusProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, BusProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"BusProductPrototypeServiceImpl-getPrototypeData-aeroexpressTicket");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : BusProductHelper.getAgency((BusProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : BusProductHelper.getSubagency((BusProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = lastProduct.getBlankOwner();
                EntityReference supplier = BusProductHelper.getSupplier((BusProduct)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                BusProduct product = new BusProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwner(blankOwner);
                BusProductHelper.setSupplier((BusProduct)product, (EntityReference)supplier);
                BusProductHelper.setAgency((BusProduct)product, (EntityReference)agency);
                BusProductHelper.setSubagency((BusProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                BusProductUIData productSupplementData = new BusProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

