/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.restriction.resource.RestrictionEntityResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AclUtil {
    public static Map<String, Boolean> getPermissions(EntityContainer<? extends BaseEntity> entityContainer, Class<? extends BaseEntity> entityClass, String userId) throws Exception {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (entityContainer != null) {
            Map proxies = RestrictionsHelper.buildProxies(entityContainer, (String)entityContainer.getEntityType().getName());
            if (proxies.isEmpty()) {
                return Collections.emptyMap();
            }
            List<String> supportedOperations = Arrays.asList(StandardRestrictionResourceOperations.VIEW.getId(), StandardRestrictionResourceOperations.EDIT.getId(), StandardRestrictionResourceOperations.DELETE.getId());
            for (RestrictionResourceProxy proxy : proxies.values()) {
                RestrictionResource resource = RestrictionResourcesRegistry.get().getResource(proxy.getResourceId());
                for (String operationId : resource.getOperationIds()) {
                    if (!supportedOperations.contains(operationId)) continue;
                    boolean granted = AclHelper.isGranted((RestrictionResourceProxy)proxy, (String)proxy.getResourceId(), (String)userId, (String)operationId, Collections.emptyList());
                    result.put(com.gridnine.xtrip.common.security.acl.helper.AclHelper.createPermission((String)proxy.getId(), (String)operationId), granted);
                }
            }
        }
        result.putAll(AclUtil.getResourcePermissions(entityClass.getName(), Collections.singletonList(StandardRestrictionResourceOperations.CREATE.getId()), userId));
        return result;
    }

    private static Map<String, Boolean> getResourcePermissions(String resourceId, List<String> supportedOperations, String userId) throws Exception {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        RestrictionResourcesRegistry registry = RestrictionResourcesRegistry.get();
        RestrictionResource resource = registry.getResource(RestrictionsHelper.lookupResourceId((String)resourceId, (RestrictionResourcesRegistry)registry));
        if (resource != null) {
            if (resource instanceof RestrictionEntityResource) {
                for (String operationId : resource.getOperationIds()) {
                    if (!supportedOperations.contains(operationId)) continue;
                    boolean granted = AclHelper.isGranted(null, (String)resourceId, (String)userId, (String)operationId, Collections.emptyList());
                    result.put(com.gridnine.xtrip.common.security.acl.helper.AclHelper.createPermission((String)resourceId, (String)operationId), granted);
                }
            }
            for (String childId : registry.getResourceChildren(resource.getId())) {
                result.putAll(AclUtil.getResourcePermissions(childId, supportedOperations, userId));
            }
        }
        return result;
    }
}

