/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.assets;

import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.xml.sax.InputSource;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"lockToken"}), @UniqueConstraint(columnNames={"owner", "activityToken"})})
public class ActivityItemData
extends BaseAssetData<ActivityItem> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ActivityItemData_modified")
    private Date modified;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ActivityItemData_created")
    private Date created;
    @Column(nullable=false)
    @Index(name="ActivityItemData_owner")
    private String owner;
    @Column(nullable=false)
    @Index(name="ActivityItemData_activityToken")
    private String activityToken;
    @Column(nullable=true)
    private String lockToken;
    @Column(nullable=false)
    @Index(name="ActivityItemData_handlerId")
    private String handlerId;
    @Column(nullable=true)
    private String title;
    @Column(nullable=true)
    private String description;
    @Lob
    @Column(length=0x40000000)
    private byte[] data = new byte[0];

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public ActivityItem toAsset(Set<String> preferredProperties) throws Exception {
        ActivityItem result = new ActivityItem(this.getUid());
        if (preferredProperties.isEmpty() || preferredProperties.contains(ActivityItem.Property.parameters.name())) {
            result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.data))).getDocumentElement());
            return result;
        }
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.contains(ActivityItem.Property.created.name())) {
            result.setCreated(MiscUtil.cloneDate((Date)this.created));
        }
        if (preferredProperties.contains(ActivityItem.Property.owner.name())) {
            result.setOwner(this.owner);
        }
        if (preferredProperties.contains(ActivityItem.Property.activityToken.name())) {
            result.setActivityToken(this.activityToken);
        }
        if (preferredProperties.contains(ActivityItem.Property.lockToken.name())) {
            result.setLocked(this.lockToken != null);
        }
        if (preferredProperties.contains(ActivityItem.Property.handlerId.name())) {
            result.setHandlerId(this.handlerId);
        }
        if (preferredProperties.contains(ActivityItem.Property.title.name())) {
            result.setTitle(this.title);
        }
        if (preferredProperties.contains(ActivityItem.Property.description.name())) {
            result.setDescription(this.description);
        }
        return result;
    }

    public void fromAsset(ActivityItem asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.created = asset.getCreated();
        if (this.created == null) {
            this.created = new Date();
            asset.setCreated(MiscUtil.cloneDate((Date)this.created));
        }
        this.owner = asset.getOwner();
        this.activityToken = asset.getActivityToken();
        this.lockToken = asset.isLocked() ? asset.getActivityToken() : null;
        this.handlerId = asset.getHandlerId();
        this.title = TextUtil.first((String)asset.getTitle(), (int)250);
        this.description = asset.getDescription();
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)asset, (OutputStream)strm);
        this.data = strm.toByteArray();
    }
}

