/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.assets;

import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Entity
public class AsyncTaskAssignmentData
extends BaseAssetData<AsyncTaskAssignment> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AsyncTaskAssignmentData_modified")
    private Date modified;
    @Lob
    @Column(length=0x40000000)
    private byte[] data = new byte[0];
    private Integer accumulatedDataSize;
    @Enumerated(value=EnumType.STRING)
    @Index(name="AsyncTaskAssignmentData_state")
    private AsyncTaskAssignment.TaskState state;
    @Index(name="AsyncTaskAssignmentData_creator")
    private String creator;
    @Index(name="AsyncTaskAssignmentData_progress")
    private byte progress;
    @Index(name="AsyncTaskAssignmentData_enqueued")
    private Date enqueued;
    @Index(name="AsyncTaskAssignmentData_started")
    private Date started;
    @Index(name="AsyncTaskAssignmentData_stopped")
    private Date stopped;
    @Index(name="AsyncTaskAssignmentData_tag")
    private String tag;
    @Index(name="AsyncTaskAssignmentData_nodeId")
    private String nodeId;
    @Index(name="AsyncTaskAssignmentData_taskClassName")
    private String taskClassName;
    @Index(name="AsyncTaskAssignmentData_failed")
    private boolean failed;
    private Boolean interruptRequested;
    private Boolean cleanupRequested;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date value) {
        this.modified = value;
    }

    public AsyncTaskAssignment toAsset(Set<String> preferredProperties) throws Exception {
        AsyncTaskAssignment result = new AsyncTaskAssignment(this.getUid());
        if (preferredProperties.isEmpty()) {
            if (this.data != null && this.data.length > 0) {
                result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.data))).getDocumentElement());
            }
            return result;
        }
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.contains(AsyncTaskAssignment.Property.state.name())) {
            result.setState(this.state);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.creator.name())) {
            result.setCreator(this.creator);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.progress.name())) {
            result.setProgress(this.progress);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.enqueued.name())) {
            result.setEnqueued(this.enqueued);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.started.name())) {
            result.setStarted(this.started);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.stopped.name())) {
            result.setStopped(this.stopped);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.tag.name())) {
            result.setTag(this.tag);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.nodeId.name())) {
            result.setNodeId(this.nodeId);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.taskClassName.name())) {
            result.setTaskClassName(this.taskClassName);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.interruptRequested.name())) {
            result.setInterruptRequested(this.interruptRequested == null ? false : this.interruptRequested);
        }
        if (preferredProperties.contains(AsyncTaskAssignment.Property.cleanupRequested.name())) {
            result.setCleanupRequested(this.cleanupRequested == null ? false : this.cleanupRequested);
        }
        return result;
    }

    public void fromAsset(AsyncTaskAssignment asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        int ACCUMULATED_DATA_SIZE_LIMIT = 0xC800000;
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)asset, (OutputStream)strm);
        this.data = strm.toByteArray();
        boolean deleteOperation = false;
        try {
            deleteOperation = "DELETE".equalsIgnoreCase((String)LogicalStorage.get().getAssetStorage().getGlobalOperationContext().getParameters().get("OPERATION"));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("illegal use of global operation context");
        }
        if (!deleteOperation) {
            if (this.accumulatedDataSize != null && this.accumulatedDataSize + this.data.length > ACCUMULATED_DATA_SIZE_LIMIT) {
                throw Xeption.forDeveloper((String)"task data size limit overrun, assignmentUid={0}, taskClassName={1}", (Object[])new Object[]{this.getUid(), this.taskClassName});
            }
            this.accumulatedDataSize = (this.accumulatedDataSize == null ? 0 : this.accumulatedDataSize) + this.data.length;
        }
        this.state = asset.getState();
        this.creator = asset.getCreator();
        this.progress = asset.getProgress();
        this.enqueued = asset.getEnqueued();
        this.started = asset.getStarted();
        this.stopped = asset.getStopped();
        this.tag = asset.getTag();
        this.nodeId = asset.getNodeId();
        this.taskClassName = asset.getTaskClassName();
        this.failed = asset.getError() != null;
        this.interruptRequested = asset.isInterruptRequested();
        this.cleanupRequested = asset.isCleanupRequested();
    }
}

