/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.assets;

import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.xml.sax.InputSource;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"owner"})})
public class FxWorkspaceData
extends BaseAssetData<FxWorkspace> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="FxWorkspaceData_modified")
    private Date modified;
    private String owner;
    private String name;
    @Lob
    @Column(length=0x40000000)
    private byte[] data = new byte[0];

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public FxWorkspace toAsset(Set<String> preferredProperties) throws Exception {
        FxWorkspace result = new FxWorkspace(this.getUid());
        if (preferredProperties.isEmpty()) {
            result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.data))).getDocumentElement());
            return result;
        }
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.contains(FxWorkspace.Property.owner.name())) {
            result.setOwner(this.owner);
        }
        if (preferredProperties.contains(FxWorkspace.Property.name.name())) {
            result.setName(this.name);
        }
        return result;
    }

    public void fromAsset(FxWorkspace asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.owner = asset.getOwner();
        this.name = asset.getName();
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)asset, (OutputStream)strm);
        this.data = strm.toByteArray();
    }

    public static enum Property {
        data;

    }
}

