/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.gracefulstop.GracefulStoppable;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.ControlThread;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class AsyncTasksManager
implements Disposable,
GracefulStoppable {
    private final ControlThread controlThread;

    public static AsyncTasksManager get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (AsyncTasksManager)Environment.getPublished(AsyncTasksManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AsyncTaskAssignment doWithLock(String assignmentUid, Function<AsyncTaskAssignment, AsyncTaskAssignment> job) throws Exception {
        LockManager lockManager = (LockManager)Environment.getPublished(LockManager.class);
        Throwable throwable = null;
        try (NamedLock lock = lockManager.getLock((Object)assignmentUid);){
            AsyncTaskAssignment asyncTaskAssignment;
            if (!lock.tryLock(30L, TimeUnit.SECONDS)) {
                throw Xeption.forDeveloper((String)"failed acquiring lock for task assignment {0}", (Object[])new Object[]{assignmentUid});
            }
            try {
                asyncTaskAssignment = job.apply((AsyncTaskAssignment)AssetsStorage.get().load(AsyncTaskAssignment.class, assignmentUid));
            }
            catch (Throwable throwable2) {
                try {
                    lock.unlock();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            lock.unlock();
            return asyncTaskAssignment;
        }
    }

    AsyncTasksManager() {
        this.handleOrphans();
        this.controlThread = new ControlThread();
        this.controlThread.start();
    }

    private void handleOrphans() {
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add("uid");
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AsyncTaskAssignment.Property.state.name(), (Object)AsyncTaskAssignment.TaskState.RUNNING));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AsyncTaskAssignment.Property.nodeId.name(), (Object)Environment.getApplicationId()));
        for (AsyncTaskAssignment assignment : AssetsStorage.get().search(AsyncTaskAssignment.class, query).getData()) {
            assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
            assignment.setStopped(new Date());
            assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted upon server restart", (Object[])new Object[0]));
            AssetsStorage.get().save((BaseAsset)assignment);
        }
    }

    public void initiateShutdown() throws Exception {
        this.controlThread.shutdownInitiated = true;
        this.controlThread.interrupt();
    }

    public boolean canStop() {
        return true;
    }

    public void dispose() {
        if (!this.controlThread.shutdownInitiated) {
            this.controlThread.interrupt();
        }
        try {
            this.controlThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public <P extends Serializable, R extends Serializable> AsyncTaskAssignment enqueue(Class<? extends AsyncTask<P, R>> taskClass, P parameters, String tag) throws Exception {
        if (this.controlThread.shutdownInitiated) {
            throw new IllegalStateException("shutdown process was initiated for this manager instance");
        }
        AsyncTaskAssignment result = new AsyncTaskAssignment();
        result.setState(AsyncTaskAssignment.TaskState.ENQUEUED);
        result.setCreator(UserData.get().getCurrentUser());
        result.setParameters(MiscUtil.serialize(parameters));
        result.setEnqueued(new Date());
        result.setTag(tag);
        result.setTaskClassName(taskClass.getName());
        AssetsStorage.get().save((BaseAsset)result);
        this.controlThread.maybeStart(result.getUid());
        return result;
    }

    public AsyncTaskAssignment interrupt(String assignmentUid) throws Exception {
        if (this.controlThread.shutdownInitiated) {
            throw new IllegalStateException("shutdown process was initiated for this manager instance");
        }
        AsyncTaskAssignment result = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
            if (assignment == null) {
                return null;
            }
            if (assignment.getState().isFinished() || assignment.isInterruptRequested()) {
                return assignment;
            }
            if (assignment.getState() == AsyncTaskAssignment.TaskState.ENQUEUED) {
                assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
                assignment.setStopped(new Date());
                assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted upon direct call", (Object[])new Object[0]));
            } else {
                assignment.setInterruptRequested(true);
            }
            AssetsStorage.get().save((BaseAsset)assignment);
            return assignment;
        });
        if (result != null && !result.getState().isFinished()) {
            this.controlThread.maybeInterrupt(result.getUid());
        }
        return result;
    }

    public void cleanup(String assignmentUid) throws Exception {
        if (this.controlThread.shutdownInitiated) {
            throw new IllegalStateException("shutdown process was initiated for this manager instance");
        }
        AsyncTaskAssignment validAssignment = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
            if (assignment == null) {
                return null;
            }
            if (assignment.isCleanupRequested()) {
                return null;
            }
            if (!assignment.getState().isFinished()) {
                assignment.setInterruptRequested(true);
            }
            assignment.setCleanupRequested(true);
            AssetsStorage.get().save((BaseAsset)assignment);
            return assignment;
        });
        if (validAssignment != null && validAssignment.getState().isFinished()) {
            this.controlThread.maybeCleanup(validAssignment);
        }
    }

    private static class Holder {
        public static final AsyncTasksManager INSTANCE = (AsyncTasksManager)Environment.getPublished(AsyncTasksManager.class);

        private Holder() {
        }
    }
}

