/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.AsyncTasksManager;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControlThread
extends Thread {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final ThreadPoolExecutor executor;
    private final ConcurrentMap<String, Future<?>> tasks = new ConcurrentHashMap();
    volatile boolean shutdownInitiated;

    ControlThread() {
        super("async-tasks-control-thread");
        this.setDaemon(true);
        int poolSize = Runtime.getRuntime().availableProcessors() - 1;
        if (poolSize < 2) {
            poolSize = 2;
        }
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private long counter;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "asnyc-worker-thread-" + ++this.counter);
            }
        });
        this.log.info("number of executor service workers is " + poolSize);
    }

    @Override
    public void run() {
        this.log.info("started");
        while (!this.isInterrupted()) {
            try {
                ControlThread.sleep(5000L);
                this.doControl();
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception e) {
                this.log.error("failed executing tasks control procedure", (Throwable)e);
                IncidentsLog.reportException((String)"failed executing tasks control procedure", (Throwable)e);
            }
        }
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            this.log.warn("timeout has occured while waiting for termination of some running tasks");
        }
        this.log.info("terminated");
    }

    private void doControl() {
        if (this.shutdownInitiated) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(AsyncTaskAssignment.Property.state.name());
        query.getPreferredProperties().add(AsyncTaskAssignment.Property.stopped.name());
        query.getPreferredProperties().add(AsyncTaskAssignment.Property.interruptRequested.name());
        query.getPreferredProperties().add(AsyncTaskAssignment.Property.cleanupRequested.name());
        query.getCriteria().getOrders().put(AsyncTaskAssignment.Property.enqueued.name(), SortOrder.ASC);
        block8: for (AsyncTaskAssignment assignment : AssetsStorage.get().search(AsyncTaskAssignment.class, query).getData()) {
            if (this.isInterrupted() || this.shutdownInitiated) break;
            try {
                switch (assignment.getState()) {
                    case ENQUEUED: {
                        this.maybeStart(assignment.getUid());
                        break;
                    }
                    case RUNNING: {
                        if (!assignment.isInterruptRequested()) continue block8;
                        this.maybeInterrupt(assignment.getUid());
                        break;
                    }
                    case COMPLETED: 
                    case INTERRUPTED: {
                        this.maybeCleanup(assignment);
                        break;
                    }
                    default: {
                        this.log.warn(String.format("unexpected state %s of assignment %s", assignment.getState().name(), assignment.getUid()));
                        break;
                    }
                }
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception e) {
                this.log.error(String.format("failed executing task control procedure for assignment %s", assignment.getUid()), (Throwable)e);
                IncidentsLog.reportException((String)String.format("failed executing task control procedure for assignment %s", assignment.getUid()), (Throwable)e);
            }
        }
    }

    void maybeStart(String assignmentUid) throws InterruptedException {
        AsyncTaskAssignment validAssignment;
        if (this.executor.getMaximumPoolSize() <= this.executor.getActiveCount()) {
            return;
        }
        try {
            validAssignment = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
                if (assignment == null) {
                    return null;
                }
                if (assignment.getState() != AsyncTaskAssignment.TaskState.ENQUEUED) {
                    return null;
                }
                if (assignment.isInterruptRequested()) {
                    assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
                    assignment.setStopped(new Date());
                    assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted before execution", (Object[])new Object[0]));
                    AssetsStorage.get().save((BaseAsset)assignment);
                    return null;
                }
                assignment.setState(AsyncTaskAssignment.TaskState.RUNNING);
                assignment.setNodeId(Environment.getApplicationId());
                assignment.setStarted(new Date());
                AssetsStorage.get().save((BaseAsset)assignment);
                return assignment;
            });
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            if (this.shutdownInitiated) {
                throw new InterruptedException();
            }
            this.log.error("failed starting task for assignment " + assignmentUid, (Throwable)e);
            IncidentsLog.reportException((String)("failed starting task for assignment " + assignmentUid), (Throwable)e);
            return;
        }
        if (validAssignment == null) {
            return;
        }
        Future<?> future = this.executor.submit(() -> {
            try {
                LogicalStorage.get().setUser(validAssignment.getCreator());
                AsyncTask task = (AsyncTask)XSHelper.getClass((String)validAssignment.getTaskClassName()).newInstance();
                this.executeTask(validAssignment.getUid(), task, MiscUtil.deserialize((byte[])validAssignment.getParameters()));
            }
            catch (Throwable e) {
                this.handleError(validAssignment.getUid(), e);
            }
            finally {
                this.tasks.remove(validAssignment.getUid());
            }
        });
        this.tasks.put(validAssignment.getUid(), future);
    }

    private <P extends Serializable> void executeTask(String assignmentUid, AsyncTask<P, ?> task, P parameters) throws Exception {
        AsyncTaskAssignment validAssignment = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
            if (assignment == null) {
                return null;
            }
            if (assignment.getState() != AsyncTaskAssignment.TaskState.RUNNING) {
                return null;
            }
            if (assignment.isInterruptRequested() || Thread.currentThread().isInterrupted()) {
                assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
                assignment.setStopped(new Date());
                assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted in the beginning of execution", (Object[])new Object[0]));
                AssetsStorage.get().save((BaseAsset)assignment);
                return null;
            }
            return assignment;
        });
        if (validAssignment == null) {
            return;
        }
        Object result = task.execute(parameters, this.createCallback(assignmentUid));
        boolean interrupted = Thread.currentThread().isInterrupted();
        AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
            if (assignment == null) {
                return null;
            }
            if (assignment.getState() != AsyncTaskAssignment.TaskState.RUNNING) {
                return null;
            }
            if (interrupted && result == null) {
                assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
                assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted after execution finished", (Object[])new Object[0]));
            } else {
                assignment.setState(AsyncTaskAssignment.TaskState.COMPLETED);
            }
            assignment.setStopped(new Date());
            try {
                assignment.setResult(MiscUtil.serialize((Serializable)((Serializable)result)));
            }
            catch (Exception e) {
                this.log.error("failed serializing task execution result", (Throwable)e);
                IncidentsLog.reportException((String)"failed serializing task execution result", (Throwable)e);
                assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"failed serializing task execution result", (Throwable)e, (Object[])new Object[0]));
            }
            AssetsStorage.get().save((BaseAsset)assignment);
            return null;
        });
    }

    private TaskExecutionCallback createCallback(final String assignmentUid) {
        return new TaskExecutionCallback(){

            @Override
            public void setProgress(byte progress, String message) throws Exception {
                AsyncTaskAssignment validAssignment = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
                    if (assignment == null) {
                        return null;
                    }
                    assignment.setProgress(progress);
                    assignment.setMessage(message);
                    AssetsStorage.get().save((BaseAsset)assignment);
                    return assignment;
                });
                if (validAssignment != null && validAssignment.isInterruptRequested()) {
                    ControlThread.this.tryToCancelTask(assignmentUid);
                }
            }

            @Override
            public void addMessages(Collection<Message> messages) throws Exception {
                if (messages == null || messages.isEmpty()) {
                    return;
                }
                AsyncTaskAssignment validAssignment = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
                    if (assignment == null) {
                        return null;
                    }
                    for (Message message : messages) {
                        assignment.getLog().add(message);
                    }
                    AssetsStorage.get().save((BaseAsset)assignment);
                    return assignment;
                });
                if (validAssignment != null && validAssignment.isInterruptRequested()) {
                    ControlThread.this.tryToCancelTask(assignmentUid);
                }
            }
        };
    }

    private void handleError(String assignmentUid, Throwable error) {
        if (this.shutdownInitiated) {
            if (!(error instanceof InterruptedException)) {
                this.log.error(String.format("error %s for task assignment %s occured during shutdown process", error, assignmentUid), error);
            }
            return;
        }
        try {
            AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
                if (assignment == null) {
                    return null;
                }
                if (ExceptionUtil.isInterruptedError((Throwable)error)) {
                    assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
                    assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted upon InterruptedException handling", (Object[])new Object[0]));
                } else {
                    assignment.setState(AsyncTaskAssignment.TaskState.COMPLETED);
                    try {
                        this.log.error("handle error ", error);
                        if (error instanceof Xeption) {
                            assignment.setError(MiscUtil.serialize((Serializable)error));
                        } else {
                            assignment.setError(MiscUtil.serialize((Serializable)Xeption.forDeveloper((String)"failed executing task {0}, error - {1}", (Throwable)error, (Object[])new Object[]{assignment.getTaskClassName(), error.toString()})));
                        }
                    }
                    catch (Exception e) {
                        this.log.error("failed serializing task execution error", (Throwable)e);
                        assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"failed serializing task execution error {0}", (Throwable)e, (Object[])new Object[]{error.toString()}));
                        try {
                            Xeption de = Xeption.forDeveloper((String)"task failed - {0}", (Object[])new Object[]{error.toString()});
                            ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
                            for (StackTraceElement elm : error.getStackTrace()) {
                                if (!"<<Context>>".equals(elm.getClassName())) continue;
                                elements.add(elm);
                            }
                            IncidentsHelper.addStackTraceElement((Throwable)de, (StackTraceElement[])elements.toArray(new StackTraceElement[elements.size()]));
                            IncidentsLog.reportException((String)String.format("async task failed, taskClassName=%s, assignmentUid=%s", assignment.getTaskClassName(), assignmentUid), (Throwable)error);
                            assignment.setError(MiscUtil.serialize((Serializable)de));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                assignment.setStopped(new Date());
                AssetsStorage.get().save((BaseAsset)assignment);
                return null;
            });
        }
        catch (InterruptedException ie) {
            this.log.warn(String.format("handling error %s for task assignment %s was interrupted", error, assignmentUid), (Throwable)ie);
        }
        catch (Throwable e) {
            this.log.error(String.format("failed handling error %s for task assignment %s", error, assignmentUid), e);
            IncidentsLog.reportException((String)String.format("failed handling error %s for task assignment %s", error, assignmentUid), (Throwable)e);
        }
    }

    void maybeInterrupt(String assignmentUid) throws InterruptedException {
        try {
            AsyncTaskAssignment validAssignment = AsyncTasksManager.doWithLock(assignmentUid, assignment -> {
                if (assignment == null) {
                    return null;
                }
                if (assignment.getState() != AsyncTaskAssignment.TaskState.RUNNING) {
                    return null;
                }
                if (MiscUtil.equals((Object)Environment.getApplicationId(), (Object)assignment.getNodeId()) && !this.tasks.containsKey(assignment.getUid())) {
                    assignment.setState(AsyncTaskAssignment.TaskState.INTERRUPTED);
                    assignment.setStopped(new Date());
                    assignment.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"task interrupted as a result of orphaned assignment handling", (Object[])new Object[0]));
                    AssetsStorage.get().save((BaseAsset)assignment);
                    return null;
                }
                if (!assignment.isInterruptRequested()) {
                    return null;
                }
                return assignment;
            });
            if (validAssignment != null) {
                this.tryToCancelTask(validAssignment.getUid());
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            if (this.shutdownInitiated) {
                throw new InterruptedException();
            }
            this.log.error(String.format("failed handling interruption for task assignment %s", assignmentUid), (Throwable)e);
            IncidentsLog.reportException((String)String.format("failed handling interruption for task assignment %s", assignmentUid), (Throwable)e);
        }
    }

    void maybeCleanup(AsyncTaskAssignment assignment) throws InterruptedException {
        if (!this.isOutdated(assignment)) {
            return;
        }
        try {
            AsyncTasksManager.doWithLock(assignment.getUid(), actualAssignment -> {
                if (actualAssignment == null) {
                    return null;
                }
                if (this.isOutdated((AsyncTaskAssignment)actualAssignment)) {
                    AssetsStorage.get().delete((BaseAsset)actualAssignment);
                }
                return actualAssignment;
            });
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            if (this.shutdownInitiated) {
                throw new InterruptedException();
            }
            this.log.error(String.format("failed handling cleanup for task assignment %s", assignment.getUid()), (Throwable)e);
            IncidentsLog.reportException((String)String.format("failed handling cleanup for task assignment %s", assignment.getUid()), (Throwable)e);
        }
    }

    private boolean isOutdated(AsyncTaskAssignment assignment) {
        if (!assignment.getState().isFinished()) {
            return false;
        }
        if (assignment.isCleanupRequested() || assignment.getStopped() == null) {
            return true;
        }
        return TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - assignment.getStopped().getTime()) >= 24L;
    }

    void tryToCancelTask(String assignmentUid) {
        Future future = (Future)this.tasks.get(assignmentUid);
        if (future != null && !future.isDone() && !future.isCancelled()) {
            future.cancel(true);
        }
    }
}

