/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibus.rpc;

import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.MulticallException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.ValidatableUtil;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IntegrationBusRpcServiceImpl
extends BaseSecureServiceImpl
implements IntegrationBusRpcService {
    private static final List<Class<? extends RuntimeException>> CLIENT_EXCEPTION_CLASSES = Arrays.asList(Xeption.class, MulticallException.class);

    private static IntegrationBusAdapter getAdapter(String adapterId) throws Exception {
        IntegrationBusAdapter adapter = IntegrationBusFacade.get().getRequestReplyAdapter(adapterId);
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("no adapter with id '%s' found", adapterId));
        }
        return adapter;
    }

    public Map<String, Object> processSync(ServiceInvocationContext ctx, String adapterId, Map<String, Object> data) throws ServiceException {
        HashMap<String, Object> inputData = new HashMap<String, Object>(data);
        try {
            this.checkContext(ctx);
            this.copyActionSource(ctx, data);
            IntegrationBusRpcServiceImpl.getAdapter(adapterId).processSync(data);
            return data;
        }
        catch (Xeption x) {
            this.log.error("processSync failed", (Throwable)x);
            throw x;
        }
        catch (MulticallException me) {
            this.log.error("processSync failed", (Throwable)me);
            throw me;
        }
        catch (Throwable t) {
            this.log.error("processSync failed", t);
            RuntimeException ve = this.lookForException(t, Arrays.asList(ValidationException.class));
            if (ve != null) {
                ArrayList messages = new ArrayList();
                ValidatableUtil.addMessages(inputData, (String)"", messages);
                List strMessages = ValidatableUtil.toStrings(messages);
                throw Xeption.forDeveloper((String)"validation error: \n{0}", (Object[])new Object[]{TextUtil.join((String)"\n", (Iterable)strMessages)});
            }
            RuntimeException x = this.lookForException(t, CLIENT_EXCEPTION_CLASSES);
            if (x != null) {
                throw x;
            }
            throw new ServiceException("processSync failed", t);
        }
    }

    private RuntimeException lookForException(Throwable ibe, List<Class<? extends RuntimeException>> exceptionClasses) {
        if (ibe.getCause() == null) {
            return null;
        }
        for (Class<? extends RuntimeException> cl : exceptionClasses) {
            if (!cl.isAssignableFrom(ibe.getCause().getClass())) continue;
            return (RuntimeException)ibe.getCause();
        }
        return this.lookForException(ibe.getCause(), exceptionClasses);
    }

    public void sendAsync(ServiceInvocationContext ctx, String adapterId, Map<String, Object> data) throws ServiceException {
        try {
            this.checkContext(ctx);
            this.copyActionSource(ctx, data);
            IntegrationBusRpcServiceImpl.getAdapter(adapterId).sendAsync(data);
        }
        catch (MulticallException | Xeption e) {
            this.log.error("sendAsync failed", e);
            throw e;
        }
        catch (Throwable t) {
            this.log.error("sendAsync failed", t);
            throw new ServiceException("sendAsync failed", t);
        }
    }

    public Map<String, Object> processRouteSync(ServiceInvocationContext ctx, String routeId, Map<String, Object> data) throws ServiceException {
        return this.processRouteSync(ctx, routeId, data, Collections.emptySet());
    }

    public Map<String, Object> processRouteSync(ServiceInvocationContext ctx, String routeId, Map<String, Object> data, Set<String> out) throws ServiceException {
        try {
            this.checkContext(ctx);
            this.copyActionSource(ctx, data);
            IntegrationBusFacade.get().processRouteSync(routeId, data);
            return null == out ? data : out.stream().filter(k -> data.get(k) != null).collect(Collectors.toMap(Function.identity(), data::get));
        }
        catch (MulticallException | Xeption e) {
            this.log.error("processRouteSync failed", e);
            throw e;
        }
        catch (Throwable t) {
            this.log.error("processRouteSync failed", t);
            RuntimeException x = this.lookForException(t, CLIENT_EXCEPTION_CLASSES);
            if (x != null) {
                throw x;
            }
            throw new ServiceException("processRouteSync failed", t);
        }
    }

    public void sendRouteAsync(ServiceInvocationContext ctx, String routeId, Map<String, Object> data) throws ServiceException {
        try {
            this.checkContext(ctx);
            this.copyActionSource(ctx, data);
            IntegrationBusFacade.get().sendRouteAsync(routeId, data);
        }
        catch (MulticallException | Xeption e) {
            this.log.error("sendRouteAsync failed", e);
            throw e;
        }
        catch (Throwable t) {
            this.log.error("sendRouteAsync failed", t);
            throw new ServiceException("sendRouteAsync failed", t);
        }
    }

    private void copyActionSource(ServiceInvocationContext ctx, Map<String, Object> data) {
        if (!data.containsKey(IBusStandardContextKeys.ACTION_SOURCE.name())) {
            data.put(IBusStandardContextKeys.ACTION_SOURCE.name(), ctx.getActionSource());
        }
    }
}

