/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Predefinable;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.fx.rpc.RpcServiceHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DictServiceImpl
extends BaseSecureServiceImpl
implements DictService {
    private static final Map<String, Function<DictQuery.SearchCriterion, Predicate<BaseDictionary>>> PSEUDO_PROPERTY_HANDLERS = new HashMap<String, Function<DictQuery.SearchCriterion, Predicate<BaseDictionary>>>();

    public static void registerPseudoPropertyHandler(String id, Function<DictQuery.SearchCriterion, Predicate<BaseDictionary>> handler) {
        PSEUDO_PROPERTY_HANDLERS.put(id, handler);
    }

    public <D extends BaseDictionary> List<DictItem<D>> searchBypassingAcl(ServiceInvocationContext ctx, Class<D> cls, DictQuery query) throws ServiceException {
        return this.searchInternal(ctx, cls, query, true);
    }

    public <D extends BaseDictionary> List<DictItem<D>> search(ServiceInvocationContext ctx, Class<D> cls, DictQuery query) throws ServiceException {
        return this.searchInternal(ctx, cls, query, false);
    }

    private <D extends BaseDictionary> List<DictItem<D>> searchInternal(ServiceInvocationContext ctx, Class<D> cls, DictQuery query, boolean bypassAcl) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-search");
        try {
            Stream<D> stream;
            block9: {
                this.checkContext(ctx);
                try {
                    if (!bypassAcl && !this.isAclGranted(cls, StandardRestrictionResourceOperations.VIEW.getId())) {
                        List<DictItem<D>> list = Collections.emptyList();
                        return list;
                    }
                    stream = this.createStream(cls, query);
                    if (query.getSorting().isEmpty()) break block9;
                    stream = stream.sorted((dict1, dict2) -> this.compare((BaseDictionary)dict1, (BaseDictionary)dict2, query.getSorting()));
                }
                catch (Throwable t) {
                    this.log.error("failed searching dictionary " + cls, t);
                    throw new ServiceException("failed searching dictionary", t);
                }
            }
            if (query.getOffset() > 0) {
                stream = stream.skip(query.getOffset());
            }
            EntityActualizer actualizer = RpcServiceHelper.createActualizer();
            List list = stream.limit(query.getLimit() <= 0 || query.getLimit() > 200 ? 200L : (long)query.getLimit()).map(dict -> this.createItem(dict, query.getFields(), actualizer)).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <D extends BaseDictionary> int count(ServiceInvocationContext ctx, Class<D> cls, DictQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-count");
        try {
            block7: {
                this.checkContext(ctx);
                try {
                    if (this.isAclGranted(cls, StandardRestrictionResourceOperations.VIEW.getId())) break block7;
                    int n = 0;
                    return n;
                }
                catch (Throwable t) {
                    this.log.error("failed counting items for " + cls, t);
                    throw new ServiceException("failed counting dictionary items", t);
                }
            }
            int n = (int)this.createStream(cls, query).count();
            return n;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <D extends BaseDictionary> D loadBypassingAcl(ServiceInvocationContext ctx, DictionaryReference<D> ref) throws ServiceException {
        return this.loadInternal(ctx, ref, true);
    }

    public <D extends BaseDictionary> D load(ServiceInvocationContext ctx, DictionaryReference<D> ref) throws ServiceException {
        return this.loadInternal(ctx, ref, false);
    }

    private <D extends BaseDictionary> D loadInternal(ServiceInvocationContext ctx, DictionaryReference<D> ref, boolean bypassAcl) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-load");
        try {
            this.checkContext(ctx);
            if (ref == null) {
                D d = null;
                return d;
            }
            if (!bypassAcl && !this.isAclGranted(ref.getType(), StandardRestrictionResourceOperations.VIEW.getId())) {
                throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW, ref.getType().getName(), MetaRegistryHelper.getDisplayName((Class)ref.getType()));
            }
            BaseDictionary result = (BaseDictionary)XCloneHelper.clone((XCloneable)DictionaryStorage.get().load(ref.getType(), ref.getCode()));
            RpcServiceHelper.createActualizer().actualize((Object)result);
            BaseDictionary baseDictionary = result;
            return (D)baseDictionary;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <D extends BaseDictionary> List<D> loadBypassingAcl(ServiceInvocationContext ctx, Class<D> cls, DictQuery query) throws ServiceException {
        return this.load(ctx, cls, query, true);
    }

    public <D extends BaseDictionary> List<D> load(ServiceInvocationContext ctx, Class<D> cls, DictQuery query) throws ServiceException {
        return this.load(ctx, cls, query, false);
    }

    private <D extends BaseDictionary> List<D> load(ServiceInvocationContext ctx, Class<D> cls, DictQuery query, boolean bypassAcl) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-load");
        try {
            this.checkContext(ctx);
            if (cls == null) {
                List<D> list = null;
                return list;
            }
            if (!bypassAcl && !this.isAclGranted(cls, StandardRestrictionResourceOperations.VIEW.getId())) {
                throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW, cls.getName(), MetaRegistryHelper.getDisplayName(cls));
            }
            Stream<D> stream = this.createStream(cls, query);
            if (!query.getSorting().isEmpty()) {
                stream = stream.sorted((dict1, dict2) -> this.compare((BaseDictionary)dict1, (BaseDictionary)dict2, query.getSorting()));
            }
            if (query.getOffset() > 0) {
                stream = stream.skip(query.getOffset());
            }
            List list = stream.limit(query.getLimit() <= 0 || query.getLimit() > 200 ? 200L : (long)query.getLimit()).collect(Collectors.toList());
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * Exception decompiling
     */
    public <D extends BaseDictionary> D save(ServiceInvocationContext ctx, D dict) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ServiceInvocationContext ctx, DictionaryReference<?> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-delete");
        try {
            this.checkContext(ctx);
            try {
                if (!this.isAclGranted(ref.getType(), StandardRestrictionResourceOperations.DELETE.getId())) {
                    throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE, ref.getType().getName(), MetaRegistryHelper.getDisplayName((Class)ref.getType()));
                }
                DictionaryStorage ds = DictionaryStorage.get();
                BaseDictionary dict = ds.load(ref.getType(), ref.getCode());
                if (dict != null) {
                    ds.delete(dict);
                }
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Throwable t) {
                this.log.error("failed deleting dictionary " + ref, t);
                throw new ServiceException("failed deleting dictionary", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(ServiceInvocationContext ctx, Class<? extends BaseDictionary> cls) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-delete");
        try {
            this.checkContext(ctx);
            try {
                if (!this.isAclGranted(cls, StandardRestrictionResourceOperations.DELETE.getId())) {
                    throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE, cls.getName(), MetaRegistryHelper.getDisplayName(cls));
                }
                DictionaryStorage ds = DictionaryStorage.get();
                ds.deleteAll(cls);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Throwable t) {
                this.log.error("failed deleting dictionary " + cls, t);
                throw new ServiceException("failed deleting dictionary", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <D extends BaseDictionary> DictionaryReference<D> getReference(ServiceInvocationContext ctx, Class<D> clazz, String code) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-getReference");
        try {
            this.checkContext(ctx);
            try {
                BaseDictionary dict = DictionaryCache.get().findByCode(clazz, code);
                DictionaryReference dictionaryReference = dict != null ? dict.toReference() : null;
                return dictionaryReference;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed actualizing dictionary reference for %s %s", clazz, code), t);
                throw new ServiceException(String.format("failed actualizing dictionary reference for %s %s", clazz, code), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <D extends BaseDictionary> List<D> loadAll(ServiceInvocationContext ctx, Class<D> clazz) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-getAll");
        try {
            this.checkContext(ctx);
            try {
                ArrayList arrayList = new ArrayList(DictionaryCache.get().getAll(clazz).values());
                return arrayList;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed loading dictionaries for %s", clazz), t);
                throw new ServiceException(String.format("failed loading dictionaries for %s", clazz), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    protected boolean isAclGranted(Class<? extends BaseDictionary> cls, String operationId) throws Exception {
        return AclHelper.isGranted(null, (String)cls.getName(), (String)LogicalStorage.get().getUser(), (String)operationId, Collections.emptyList());
    }

    private <D extends BaseDictionary> Stream<D> createStream(Class<D> cls, DictQuery query) {
        Stream<Object> result;
        if (query.getCriterions().isEmpty()) {
            result = DictionaryCache.get().getAll(cls).values().stream();
        } else {
            Collection data;
            MetaRegistry reg = MetaRegistry.get();
            DictionaryType dictType = (DictionaryType)reg.getDictionaries().get(cls.getName());
            if (dictType == null) {
                throw Xeption.forDeveloper((String)"can't find meta data for dict {0}", (Object[])new Object[]{cls.getName()});
            }
            ArrayList<DictSearchCriterion> dictCriterions = new ArrayList<DictSearchCriterion>();
            ArrayList predicates = new ArrayList();
            for (DictQuery.SearchCriterion criterion : query.getCriterions()) {
                DictionaryProperty prop = (DictionaryProperty)dictType.getProperties().get(criterion.getFiled());
                if (prop != null && prop.isIndexed()) {
                    if (criterion.getValues().length == 0) {
                        dictCriterions.add(DictSearchCriterion.eq((String)criterion.getFiled(), null));
                        continue;
                    }
                    if (criterion.getValues().length == 1) {
                        dictCriterions.add(DictSearchCriterion.eq((String)criterion.getFiled(), (Object)criterion.getValues()[0]));
                        continue;
                    }
                    predicates.add(this.createPredicate(criterion));
                    continue;
                }
                predicates.add(this.createPredicate(criterion));
            }
            if (!dictCriterions.isEmpty()) {
                HashSet set = null;
                for (DictSearchCriterion criterion : dictCriterions) {
                    Set searchResult = DictionaryCache.get().search(cls, criterion);
                    if (set == null) {
                        set = new HashSet(searchResult);
                        continue;
                    }
                    set.retainAll(searchResult);
                }
                data = set == null ? Collections.emptyList() : set;
            } else {
                data = DictionaryCache.get().getAll(cls).values();
            }
            if (data.isEmpty()) {
                return Stream.empty();
            }
            result = data.stream();
            if (!predicates.isEmpty()) {
                result = result.filter(item -> {
                    for (Predicate predicate : predicates) {
                        if (predicate.test(item)) continue;
                        return false;
                    }
                    return true;
                });
            }
        }
        if (!TextUtil.isBlank((String)query.getPattern())) {
            String[] patterns = query.getPattern().trim().toLowerCase(Locale.ROOT).split("[^a-zA-Z\u0430-\u044f\u0410-\u042f_0-9]");
            Predicate<Object> matcher = obj -> this.matches(patterns, obj);
            result = result.filter(dict -> {
                for (String field : query.getFields()) {
                    try {
                        if (!matcher.test(this.getValue((BaseDictionary)dict, field, null, true))) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                }
                return false;
            });
        }
        return result;
    }

    private <D extends BaseDictionary> Predicate<D> createPredicate(DictQuery.SearchCriterion criterion) {
        String[] values;
        if (BaseDictionary.Property.code.name().equals(criterion.getFiled())) {
            Object[] values2 = criterion.getValues();
            if (values2 == null || values2.length == 0) {
                return item -> false;
            }
            String[] patterns = new String[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                patterns[i] = String.valueOf(values2[i]);
            }
            return item -> {
                String code = item.getCode();
                for (String pattern : patterns) {
                    if (!pattern.equalsIgnoreCase(code)) continue;
                    return true;
                }
                return false;
            };
        }
        if (BaseDictionary.Property.codeVariants.name().equals(criterion.getFiled())) {
            String[] values3 = this.toPatterns(criterion.getValues());
            return item -> {
                for (String code : item.getCodeVariants().values()) {
                    if (!this.contains(code, values3)) continue;
                    return true;
                }
                return false;
            };
        }
        if ("codeVariantsKey".equals(criterion.getFiled())) {
            String[] values4 = this.toPatterns(criterion.getValues());
            return item -> {
                for (String code : item.getCodeVariants().keySet()) {
                    if (!this.contains(code, values4)) continue;
                    return true;
                }
                return false;
            };
        }
        Function<DictQuery.SearchCriterion, Predicate<BaseDictionary>> function = PSEUDO_PROPERTY_HANDLERS.get(criterion.getFiled());
        if (function != null) {
            return function.apply(criterion);
        }
        if (BaseDictionary.Property.translations.name().equals(criterion.getFiled())) {
            values = this.toPatterns(criterion.getValues());
            return item -> {
                for (String translation : item.getTranslations().values()) {
                    if (!this.contains(translation, values)) continue;
                    return true;
                }
                return false;
            };
        }
        if (BaseDictionary.Property.spellVariants.name().equals(criterion.getFiled())) {
            values = this.toPatterns(criterion.getValues());
            return item -> {
                for (String spellVariant : item.getSpellVariants()) {
                    if (!this.contains(spellVariant, values)) continue;
                    return true;
                }
                return false;
            };
        }
        if (criterion.getValues().length == 0) {
            return item -> {
                try {
                    Object value = this.getValue((BaseDictionary)item, criterion.getFiled(), null, true);
                    if (value instanceof Collection) {
                        return ((Collection)value).isEmpty();
                    }
                    return value == null;
                }
                catch (Exception exception) {
                    return false;
                }
            };
        }
        return item -> {
            try {
                Object value = this.getValue((BaseDictionary)item, criterion.getFiled(), null, true);
                for (Object val : criterion.getValues()) {
                    if (value instanceof Iterable) {
                        for (Object obj : (Iterable)value) {
                            if (!MiscUtil.equals(obj, (Object)val)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!MiscUtil.equals((Object)value, (Object)val)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        };
    }

    private String[] toPatterns(Object[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = String.valueOf(values[i]).toLowerCase(Locale.ROOT);
        }
        return result;
    }

    private boolean contains(String str, String[] patterns) {
        if (patterns.length == 0) {
            return TextUtil.isBlank((String)str);
        }
        if (str == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (str.toLowerCase(Locale.ROOT).indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String[] patterns, Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CharSequence) {
            return this.matches(patterns, (CharSequence)obj);
        }
        if (obj instanceof DictionaryReference) {
            DictionaryReference ref = (DictionaryReference)obj;
            return this.matches(patterns, ref.getCode()) || this.matches(patterns, ref.getCaption());
        }
        if (obj instanceof Enum) {
            return this.matches(patterns, obj.toString());
        }
        if (obj instanceof Collection) {
            for (Object item : (Collection)obj) {
                if (!this.matches(patterns, item)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (!this.matches(patterns, entry.getKey()) && !this.matches(patterns, entry.getValue())) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Locale) {
            Locale loc = (Locale)obj;
            return this.matches(patterns, loc.getDisplayName(LocaleManager.get().getCurrentLocale()));
        }
        return false;
    }

    private boolean matches(String[] patterns, CharSequence value) {
        if (value == null) {
            return false;
        }
        boolean result = false;
        String searchableValue = value.toString().toLowerCase(Locale.ROOT);
        for (String pattern : patterns) {
            boolean found = false;
            int idx = searchableValue.indexOf(pattern);
            while (idx >= 0) {
                if (idx == 0 || DictServiceImpl.isDelimeter(searchableValue.charAt(idx - 1))) {
                    found = true;
                    break;
                }
                idx = searchableValue.indexOf(pattern, idx + pattern.length());
            }
            if (!found) {
                return false;
            }
            result = true;
        }
        return result;
    }

    private static boolean isDelimeter(char c) {
        if (c >= 'a' && c <= 'z') {
            return false;
        }
        if (c >= 'A' && c <= 'Z') {
            return false;
        }
        if (c >= '\u0430' && c <= '\u044f') {
            return false;
        }
        if (c >= '\u0410' && c <= '\u042f') {
            return false;
        }
        if (c >= '0' && c <= '9') {
            return false;
        }
        return c != '_';
    }

    private int compare(BaseDictionary dict1, BaseDictionary dict2, Map<String, SortOrder> sorting) {
        for (Map.Entry<String, SortOrder> entry : sorting.entrySet()) {
            int result;
            String field = entry.getKey();
            if (BaseDictionary.Property.codeVariants.name().equals(field)) {
                result = this.toComparableString(dict1.getCodeVariants()).compareTo(this.toComparableString(dict2.getCodeVariants()));
            } else if (BaseDictionary.Property.translations.name().equals(field)) {
                result = this.toComparableString(dict1.getTranslations()).compareTo(this.toComparableString(dict2.getTranslations()));
            } else {
                try {
                    Object value1 = this.getValue(dict1, field, null, true);
                    Object value2 = this.getValue(dict2, field, null, true);
                    result = value1 == null ? (value2 == null ? 0 : -1) : (value2 == null ? 1 : (value1 instanceof Comparable ? ((Comparable)value1).compareTo(value2) : String.valueOf(value1).compareTo(String.valueOf(value2))));
                }
                catch (Exception e) {
                    result = 0;
                }
            }
            if (result == 0) continue;
            return entry.getValue() == SortOrder.ASC ? result : result * -1;
        }
        return 0;
    }

    private String toComparableString(Map<?, ?> map) {
        return map.entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).map(entry -> entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(";"));
    }

    private <D extends BaseDictionary> DictItem<D> createItem(D dict, Set<String> fields, EntityActualizer actualizer) throws RuntimeException {
        DictItem result;
        try {
            result = new DictItem((DictionaryReference)dict.getClass().getMethod("toReference", new Class[0]).invoke(dict, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (dict instanceof Predefinable) {
            result.getFields().put("predefined", ((Predefinable)dict).isPredefined());
        }
        for (String field : fields) {
            try {
                result.getFields().put(field, this.getValue(dict, field, actualizer, false));
            }
            catch (Exception e) {
                result.getFields().put(field, e.toString());
            }
        }
        return result;
    }

    private Object getValue(BaseDictionary dict, String field, EntityActualizer actualizer, boolean forMatching) {
        BaseDictionary.Property prop = (BaseDictionary.Property)CollectionUtil.findEnumConstant(BaseDictionary.Property.class, (String)field);
        if (prop != null) {
            switch (prop) {
                case code: {
                    return dict.getCode();
                }
                case codeVariants: {
                    return forMatching ? dict.getCodeVariants().values() : dict.getCodeVariants();
                }
                case translations: {
                    return forMatching ? dict.getTranslations().values() : dict.getTranslations();
                }
                case created: {
                    return dict.getCreated();
                }
                case createdBy: {
                    return dict.getCreatedBy();
                }
                case modified: {
                    return dict.getModified();
                }
                case modifiedBy: {
                    return dict.getModifiedBy();
                }
                case spellVariants: {
                    return dict.getSpellVariants();
                }
                case notUpdatable: {
                    return dict.isNotUpdatable();
                }
            }
            throw new IllegalArgumentException("unsupported standard field " + field);
        }
        Object result = dict.getValue(field);
        if (actualizer != null) {
            actualizer.actualize(result);
        }
        return result;
    }
}

