/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.db.storage.entity.RevisionConflictException;
import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.NestedEntity;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageIsAvailableParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.standard.helpers.SystemSettingsHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriteria;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.fx.AclUtil;
import com.gridnine.xtrip.server.fx.rpc.RpcServiceHelper;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandlersRegistry;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class EntityServiceImpl
extends BaseSecureServiceImpl
implements EntityService {
    public static final String KEY_CLIENT_ENTITY_OPERATION = "KEY_CLIENT_ENTITY_OPERATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity, I extends EntityIndex<E>> List<I> search(ServiceInvocationContext ctx, Class<I> cls, SearchQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-search");
        try {
            this.checkContext(ctx);
            List<I> list = this.doSearch(cls, query);
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends EntityIndex<?>>[] multiSearch(ServiceInvocationContext ctx, MiscUtil.Pair<Class<? extends EntityIndex<?>>, SearchQuery>[] queries) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-multiSearch");
        try {
            this.checkContext(ctx);
            List[] result = new List[queries.length];
            for (int i = 0; i < queries.length; ++i) {
                MiscUtil.Pair<Class<? extends EntityIndex<?>>, SearchQuery> pair = queries[i];
                result[i] = this.doSearch((Class)pair.getFirst(), (SearchQuery)pair.getSecond());
            }
            List[] listArray = result;
            return listArray;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> List<I> doSearch(Class<I> cls, SearchQuery query) throws ServiceException {
        try {
            if (!com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted(null, (String)cls.getName(), (String)LogicalStorage.get().getUser(), (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList())) {
                return Collections.emptyList();
            }
            com.gridnine.xtrip.server.security.acl.helper.AclHelper.modifyQuery((SearchQuery)query, (String)cls.getName(), (String)LogicalStorage.get().getUser(), Collections.emptyList());
            SearchResult searchResult = EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)((EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).context("irrelevance-tolerant-query", (Object)Boolean.TRUE));
            ArrayList result = new ArrayList(searchResult.getData());
            if (result.isEmpty()) {
                return result;
            }
            MetaRegistry metaRegistry = MetaRegistry.get();
            IndexType indexType = (IndexType)metaRegistry.getIndexes().get(cls.getName());
            HashSet<String> props = new HashSet<String>();
            HashSet<String> colls = new HashSet<String>();
            for (IndexProperty prop : indexType.getProperties().values()) {
                if (!query.getPreferredProperties().isEmpty() && !query.getPreferredProperties().contains(prop.getId()) || !metaRegistry.getDictionaries().containsKey(prop.getType()) && !metaRegistry.getEntities().containsKey(prop.getType())) continue;
                props.add(prop.getId());
            }
            for (IndexCollection coll : indexType.getCollections().values()) {
                if (!query.getPreferredProperties().isEmpty() && !query.getPreferredProperties().contains(coll.getId()) || !metaRegistry.getDictionaries().containsKey(coll.getElementType()) && !metaRegistry.getEntities().containsKey(coll.getElementType())) continue;
                colls.add(coll.getId());
            }
            if (props.isEmpty() && colls.isEmpty()) {
                return result;
            }
            EntityActualizer actualizer = RpcServiceHelper.createActualizer();
            for (EntityIndex idx : result) {
                props.forEach(id -> {
                    try {
                        actualizer.actualize(idx.getValue(id));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                colls.forEach(id -> {
                    Collection value = (Collection)idx.getValue(id);
                    if (value.isEmpty()) {
                        return;
                    }
                    value.forEach(val -> {
                        try {
                            actualizer.actualize(val);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                });
            }
            return result;
        }
        catch (Throwable t) {
            this.log.error("failed searching index " + cls, t);
            throw new ServiceException("failed searching index " + cls + ", query = " + query.toString(), t);
        }
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(ServiceInvocationContext ctx, Class<I> cls, ProjectionQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-projection");
        try {
            block7: {
                this.checkContext(ctx);
                try {
                    if (com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted(null, (String)cls.getName(), (String)LogicalStorage.get().getUser(), (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList())) break block7;
                    ProjectionResult projectionResult = new ProjectionResult();
                    return projectionResult;
                }
                catch (Throwable t) {
                    this.log.error("failed searching index " + cls, t);
                    throw new ServiceException("failed searching index " + cls, t);
                }
            }
            ProjectionResult projectionResult = EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)((EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).context("irrelevance-tolerant-query", (Object)Boolean.TRUE));
            return projectionResult;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> List<?> getValuesForFilter(ServiceInvocationContext ctx, Class<I> cls, String propertyId, SearchCriteria criteria) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-getValuesForFilter");
        try {
            block22: {
                this.checkContext(ctx);
                try {
                    if (com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted(null, (String)cls.getName(), (String)LogicalStorage.get().getUser(), (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList())) break block22;
                    List<?> list = null;
                    return list;
                }
                catch (Throwable t) {
                    this.log.error(String.format("failed collecting filter values for index %s and property %s", cls, propertyId), t);
                    throw new ServiceException(String.format("failed collecting filter values for index %s and property %s", cls, propertyId), t);
                }
            }
            MetaRegistry metaRegistry = MetaRegistry.get();
            IndexType indexType = (IndexType)metaRegistry.getIndexes().get(cls.getName());
            if (indexType == null) {
                List<?> list = null;
                return list;
            }
            IndexProperty prop = (IndexProperty)indexType.getProperties().get(propertyId);
            if (prop == null || !prop.isFilterable()) {
                List<?> list = null;
                return list;
            }
            if ("String".equals(prop.getType()) || metaRegistry.getEnums().containsKey(prop.getType()) || metaRegistry.getEnumRefs().containsKey(prop.getType())) {
                ProjectionQuery query = new ProjectionQuery();
                query.getProjections().add(Projection.group((String)propertyId, (String)"filter"));
                query.getCriteria().getCriterions().addAll(criteria.getCriterions());
                query.getCriteria().getRestrictions().addAll(criteria.getRestrictions());
                ProjectionResult searchResult = EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)((EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).context("irrelevance-tolerant-query", (Object)Boolean.TRUE));
                ArrayList result = new ArrayList();
                for (Map row : searchResult.getData()) {
                    Object value = row.get("filter");
                    if (value == null) continue;
                    result.add(value);
                }
                ArrayList arrayList = result;
                return arrayList;
            }
            if (metaRegistry.getDictionaries().containsKey(prop.getType())) {
                Object row2;
                HashSet<String> set = new HashSet<String>();
                ProjectionQuery query = new ProjectionQuery();
                query.getProjections().add(Projection.group((String)propertyId, (String)"filter"));
                query.getCriteria().getCriterions().addAll(criteria.getCriterions());
                query.getCriteria().getRestrictions().addAll(criteria.getRestrictions());
                ProjectionResult searchResult = EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)((EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).context("irrelevance-tolerant-query", (Object)Boolean.TRUE));
                for (Object row2 : searchResult.getData()) {
                    String code2 = (String)row2.get("filter");
                    if (TextUtil.isBlank((String)code2)) continue;
                    set.add(code2);
                }
                if (set.isEmpty()) {
                    List list = Collections.emptyList();
                    return list;
                }
                Map map = DictionaryCache.get().getAll(XSHelper.getClass((String)prop.getType()));
                row2 = set.stream().map(code -> {
                    BaseDictionary dict = (BaseDictionary)map.get(code);
                    return dict == null ? null : dict.toReference();
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return row2;
            }
            if (metaRegistry.getEntities().containsKey(prop.getType()) || metaRegistry.getEntityRefs().containsKey(prop.getType())) {
                ProjectionQuery query = new ProjectionQuery();
                query.getProjections().add(Projection.group((String)propertyId, (String)"filter"));
                query.getProjections().add(Projection.group((String)(propertyId + "EntityClassName"), (String)"filterEntityClassName"));
                query.getProjections().add(Projection.group((String)(propertyId + "ReferenceCaption"), (String)"filterReferenceCaption"));
                query.getCriteria().getCriterions().addAll(criteria.getCriterions());
                query.getCriteria().getRestrictions().addAll(criteria.getRestrictions());
                ProjectionResult searchResult = EntityStorage.get().search(cls, query, (EntityStorageSearchParameters)((EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).context("irrelevance-tolerant-query", (Object)Boolean.TRUE));
                EntityActualizer actualizer = RpcServiceHelper.createActualizer();
                ArrayList<EntityReference> result = new ArrayList<EntityReference>();
                HashSet<String> uids = new HashSet<String>();
                for (Map row : searchResult.getData()) {
                    String uid = (String)row.get("filter");
                    String className = (String)row.get("filterEntityClassName");
                    if (TextUtil.isBlank((String)uid) || TextUtil.isBlank((String)className) || uids.contains(uid)) continue;
                    uids.add(uid);
                    EntityReference ref = new EntityReference(uid, XSHelper.getClass((String)className), (String)row.get("filterReferenceCaption"));
                    actualizer.actualize((Object)ref);
                    result.add(ref);
                }
                ArrayList<EntityReference> arrayList = result;
                return arrayList;
            }
            List<?> list = null;
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity> List<EntityReference<E>> getReferences(ServiceInvocationContext ctx, Class<E> cls, String ... uids) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-getReferences");
        try {
            this.checkContext(ctx);
            try {
                ArrayList<EntityReference<EntityReference>> result = new ArrayList<EntityReference<EntityReference>>(uids.length);
                EntityActualizer actualizer = RpcServiceHelper.createActualizer();
                for (String uid : uids) {
                    if (TextUtil.isBlank((String)uid) || !EntityStorage.get().isAvailable(cls, uid)) continue;
                    EntityReference ref = new EntityReference(uid, cls, null);
                    actualizer.actualize((Object)ref);
                    result.add(ref);
                }
                ArrayList<EntityReference<EntityReference>> arrayList = result;
                return arrayList;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed actualizing references for %s %s", cls, Arrays.toString(uids)), t);
                throw new ServiceException(String.format("failed actualizing references for %s %s", cls, Arrays.toString(uids)), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity> List<VersionInfo> getVersionInfos(ServiceInvocationContext ctx, EntityReference<E> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-versions");
        try {
            this.checkContext(ctx);
            if (ref == null) {
                List<VersionInfo> list = null;
                return list;
            }
            if (!LogicalStorage.get().getEntityStorage().isAvailable(ref.getType(), ref.getUid(), new EntityStorageIsAvailableParameters())) {
                List<VersionInfo> list = Collections.emptyList();
                return list;
            }
            ArrayList<VersionInfo> arrayList = new ArrayList<VersionInfo>(LogicalStorage.get().getEntityStorage().getVersionInfos(ref));
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity> List<VersionInfo> getVersionInfos(ServiceInvocationContext ctx, Class<E> cls, String uid) throws ServiceException {
        return this.getVersionInfos(ctx, new EntityReference(uid, cls, null));
    }

    public <E extends BaseEntity> EntityContainer<E> loadBypassingAcl(ServiceInvocationContext ctx, EntityReference<E> ref) throws ServiceException {
        if (ref == null) {
            return null;
        }
        return ((DataTransferPackage)this.loadInternal(ctx, ref.getType(), ref.getUid(), null, null, true, false).getFirst()).getContainer();
    }

    public <E extends BaseEntity> EntityContainer<E> loadBypassingAcl(ServiceInvocationContext ctx, Class<E> cls, String uid) throws ServiceException {
        return ((DataTransferPackage)this.loadInternal(ctx, cls, uid, null, null, true, false).getFirst()).getContainer();
    }

    public <E extends BaseEntity> EntityContainer<E> load(ServiceInvocationContext ctx, EntityReference<E> ref) throws ServiceException {
        if (ref == null) {
            return null;
        }
        return ((DataTransferPackage)this.loadInternal(ctx, ref.getType(), ref.getUid(), null, null, false, false).getFirst()).getContainer();
    }

    public <E extends BaseEntity> EntityContainer<E> load(ServiceInvocationContext ctx, Class<E> cls, String uid) throws ServiceException {
        return ((DataTransferPackage)this.loadInternal(ctx, cls, uid, null, null, false, false).getFirst()).getContainer();
    }

    public <E extends BaseEntity, S> DataTransferPackage<E, S> load(ServiceInvocationContext ctx, EntityReference<E> ref, Class<S> supplementClass) throws ServiceException {
        if (ref == null) {
            return null;
        }
        return (DataTransferPackage)this.loadInternal(ctx, ref.getType(), ref.getUid(), null, supplementClass, false, false).getFirst();
    }

    public <E extends BaseEntity, S> DataTransferPackage<E, S> load(ServiceInvocationContext ctx, Class<E> entityClass, String entityUid, int versionNumber, Class<S> supplementClass) throws ServiceException {
        return (DataTransferPackage)this.loadInternal(ctx, entityClass, entityUid, versionNumber, supplementClass, false, false).getFirst();
    }

    public <E extends BaseEntity, S> DataTransferPackage<E, S> load(ServiceInvocationContext ctx, Class<E> entityClass, String entityUid, Class<S> supplementClass) throws ServiceException {
        return (DataTransferPackage)this.loadInternal(ctx, entityClass, entityUid, null, supplementClass, false, false).getFirst();
    }

    public <E extends BaseEntity, S> DataTransferPackage<E, S> load(ServiceInvocationContext ctx, Class<E> entityClass, String entityUid, Integer versionNumber, Class<S> supplementClass) throws ServiceException {
        return (DataTransferPackage)this.loadInternal(ctx, entityClass, entityUid, versionNumber, supplementClass, false, false).getFirst();
    }

    public <E extends BaseEntity, S> MiscUtil.Pair<DataTransferPackage<E, S>, Map<String, Boolean>> loadWithPermissions(ServiceInvocationContext ctx, Class<E> entityClass, String entityUid, Integer versionNumber, Class<S> supplementClass) throws ServiceException {
        return this.loadInternal(ctx, entityClass, entityUid, versionNumber, supplementClass, false, true);
    }

    private <E extends BaseEntity, S> MiscUtil.Pair<DataTransferPackage<E, S>, Map<String, Boolean>> loadInternal(ServiceInvocationContext ctx, Class<E> entityClass, String entityUid, Integer versionNumber, Class<S> supplementClass, boolean bypassAcl, boolean loadAclPermissions) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-load");
        try {
            boolean viewGranted;
            MiscUtil.Pair result;
            Map<String, Boolean> permissions;
            EntityContainer ctr;
            DataTransferPackage dtp;
            block9: {
                this.checkContext(ctx);
                try {
                    dtp = new DataTransferPackage();
                    ctr = EntityStorage.get().load(entityClass, entityUid, versionNumber);
                    permissions = loadAclPermissions ? AclUtil.getPermissions((EntityContainer<? extends BaseEntity>)ctr, entityClass, ctx.getUser()) : null;
                    result = new MiscUtil.Pair((Object)dtp, permissions);
                    if (ctr != null) break block9;
                    MiscUtil.Pair pair = result;
                    return pair;
                }
                catch (ServiceException se) {
                    throw se;
                }
                catch (Throwable t) {
                    this.log.error(String.format("failed loading entity %s %s", entityClass, entityUid), t);
                    throw new ServiceException(String.format("failed loading entity %s %s", entityClass, entityUid), t);
                }
            }
            if (!bypassAcl && !(viewGranted = permissions != null ? !Boolean.FALSE.equals(permissions.get(AclHelper.createPermission((String)ctr.getEntity().getUid(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW))) : com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((EntityContainer)ctr, (String)ctr.getEntity().getUid(), (String)ctr.getEntityType().getName(), (String)ctx.getUser(), (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList()))) {
                throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW, ctr.getUid() + "|" + ctr.getEntityType().getName(), ctr.getEntity().toString());
            }
            ctr = (EntityContainer)XCloneHelper.clone((XCloneable)ctr);
            RpcServiceHelper.createActualizer().actualize((Object)ctr.getEntity());
            dtp.setContainer(ctr);
            dtp.setSupplement(SupplementHandlersRegistry.get().populateSupplement(supplementClass, ctr));
            MiscUtil.Pair pair = result;
            return pair;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity> EntityContainer<E> save(ServiceInvocationContext ctx, EntityContainer<E> ctr, VersionInfo versionInfo, boolean withCheckPoint) throws ServiceException {
        return this.save(ctx, new DataTransferPackage(ctr), versionInfo, withCheckPoint).getContainer();
    }

    public <E extends BaseEntity, S> DataTransferPackage<E, S> save(ServiceInvocationContext ctx, DataTransferPackage<E, S> data, VersionInfo versionInfo, boolean withCheckPoint) throws ServiceException {
        return (DataTransferPackage)this.saveInternal(ctx, data, versionInfo, withCheckPoint, false).getFirst();
    }

    public <E extends BaseEntity, S> MiscUtil.Pair<DataTransferPackage<E, S>, Map<String, Boolean>> saveWithPermissions(ServiceInvocationContext ctx, DataTransferPackage<E, S> data, VersionInfo versionInfo, boolean withCheckPoint) throws ServiceException {
        return this.saveInternal(ctx, data, versionInfo, withCheckPoint, true);
    }

    /*
     * Exception decompiling
     */
    private <E extends BaseEntity, S> MiscUtil.Pair<DataTransferPackage<E, S>, Map<String, Boolean>> saveInternal(ServiceInvocationContext ctx, DataTransferPackage<E, S> data, VersionInfo versionInfo, boolean withCheckPoint, boolean loadAclPermissions) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void delete(ServiceInvocationContext ctx, EntityReference<E> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-delete");
        try {
            this.checkContext(ctx);
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr != null && !com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((EntityContainer)ctr, (String)ctr.getEntity().getUid(), (String)ctr.getEntityType().getName(), (String)ctx.getUser(), (String)StandardRestrictionResourceOperations.DELETE.getId(), Collections.emptyList())) {
                    throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.DELETE, ctr.getUid() + "|" + ctr.getEntityType().getName(), ctr.getEntity().toString());
                }
                EntityStorageDeleteParameters deleteParameters = new EntityStorageDeleteParameters();
                deleteParameters.getContext().put(KEY_CLIENT_ENTITY_OPERATION, ClientEntityOperation.DELETE);
                EntityStorage.get().delete(ref, deleteParameters);
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.like((String)ActivityItem.Property.activityToken.name(), (String)('%' + ref.getUid() + '%')));
                for (ActivityItem item : AssetsStorage.get().search(ActivityItem.class, query).getData()) {
                    AssetsStorage.get().delete((BaseAsset)item);
                }
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed deleting entity %s %s", ref.getType(), ref.getUid()), t);
                throw new ServiceException("failed deleting entity " + ref, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <E extends BaseEntity> void delete(ServiceInvocationContext ctx, Class<E> cls, String uid) throws ServiceException {
        this.delete(ctx, new EntityReference(uid, cls, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Root extends BaseEntity, Nested extends BaseEntity> NestedEntity<Root, Nested> resolve(ServiceInvocationContext ctx, NestedEntityReference<Root, Nested> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxEntityServiceImpl-resolve");
        try {
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().load(ref.getType(), ref.getUid());
            BaseEntity ett = ctr == null ? null : EntityStorageHelper.findNestedEntity((BaseEntity)ctr.getEntity(), ref);
            NestedEntity nestedEntity = new NestedEntity(ctr, ett);
            return nestedEntity;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * Exception decompiling
     */
    public VersionInfo rollback(ServiceInvocationContext ctx, EntityReference<?> ref, VersionInfo version) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyActionSource(ServiceInvocationContext ctx, EntityStorageSaveParameters parameters) {
        if (!parameters.getContext().containsKey(IBusStandardContextKeys.ACTION_SOURCE.name())) {
            parameters.getContext().put(IBusStandardContextKeys.ACTION_SOURCE.name(), ctx.getActionSource());
        }
    }

    private /* synthetic */ VersionInfo lambda$rollback$9(EntityReference ref, VersionInfo version, ServiceInvocationContext ctx) throws Exception {
        EntityContainer ctr = EntityStorage.get().load(ref.getType(), ref.getUid(), Integer.valueOf(version.getVersionNumber()));
        if (ctr == null) {
            throw new ServiceException(String.format("\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432\u0435\u0440\u0441\u0438\u044f %s \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 %s", version.getVersionNumber() + 1, ref), true);
        }
        if (!com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((EntityContainer)ctr, (String)ctr.getEntity().getUid(), (String)ctr.getEntityType().getName(), (String)ctx.getUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList())) {
            throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT, ctr.getUid() + "|" + ctr.getEntityType().getName(), ctr.getEntity().toString());
        }
        return (VersionInfo)EntityStorageThreadContext.execute(() -> {
            EntityContainer newCtr = new EntityContainer(ctr.getEntityType());
            XCloneModelHelper.copy((BaseEntity)ctr, (BaseEntity)newCtr);
            newCtr.setUid(ctr.getUid());
            newCtr.getVersionInfo().setCreated(null);
            newCtr.getVersionInfo().setCreatedBy(null);
            newCtr.getVersionInfo().setModified(null);
            newCtr.getVersionInfo().setCreatedBy(null);
            newCtr.getVersionInfo().setUid(null);
            newCtr.getVersionInfo().setVersionNotes("restored from version " + (ctr.getVersionInfo().getVersionNumber() + 1));
            newCtr.getVersionInfo().setDataSource("fx-rollback");
            EntityStorageThreadContext.setActionSource((EntityStorageThreadContext.ActionSource)EntityStorageThreadContext.ActionSource.MIDOFFICE_CLIENT_FX);
            EntityStorageSaveParameters entityStorageSaveParameters = new EntityStorageSaveParameters();
            entityStorageSaveParameters.getContext().put(KEY_CLIENT_ENTITY_OPERATION, ClientEntityOperation.ROLLBACK);
            newCtr = EntityStorage.get().save(newCtr, true, entityStorageSaveParameters);
            return newCtr.getVersionInfo();
        });
    }

    private /* synthetic */ MiscUtil.Pair lambda$saveInternal$7(DataTransferPackage data, ServiceInvocationContext ctx, VersionInfo versionInfo, boolean withCheckPoint, boolean loadAclPermissions) throws Exception {
        EntityContainer ctr = data.getContainer();
        return (MiscUtil.Pair)LockUtil.lock((EntityContainer)ctr, () -> {
            LogicalSession session = LogicalStorage.get().beginUnitOfWork();
            try {
                EntityContainer newCtr;
                Map<String, Boolean> permissions = AclUtil.getPermissions((EntityContainer<? extends BaseEntity>)ctr, ctr.getEntityType(), ctx.getUser());
                boolean editPermissionChecked = permissions.keySet().stream().anyMatch(permission -> AclHelper.isForOperation((String)permission, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
                boolean editPermissionGranted = permissions.entrySet().stream().anyMatch(entry -> (Boolean)entry.getValue() != false && AclHelper.isForOperation((String)((String)entry.getKey()), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
                if (editPermissionChecked && !editPermissionGranted) {
                    throw this.createPermissionDeniedException(ctx.getUser(), (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT, ctr.getUid() + "|" + ctr.getEntityType().getName(), ctr.getEntity().toString());
                }
                SupplementHandlersRegistry.get().populateEntity(data.getSupplement(), ctr);
                EntityStorageSaveParameters entityStorageSaveParameters = new EntityStorageSaveParameters();
                this.copyActionSource(ctx, entityStorageSaveParameters);
                entityStorageSaveParameters.getContext().put(KEY_CLIENT_ENTITY_OPERATION, ClientEntityOperation.SAVE);
                if (versionInfo != null && SystemSettingsHelper.isCheckThirdPartyChange()) {
                    entityStorageSaveParameters.versionToCheckThirdPartyChanges(versionInfo);
                }
                try {
                    EntityStorageThreadContext.setActionSource((EntityStorageThreadContext.ActionSource)EntityStorageThreadContext.ActionSource.MIDOFFICE_CLIENT_FX);
                    newCtr = EntityStorage.get().save(ctr, withCheckPoint, entityStorageSaveParameters);
                    LogicalStorage.get().endUnitOfWork(session, false);
                }
                catch (RevisionConflictException e) {
                    String message = "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442.\u043a. \u043e\u043d \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0451\u043d \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c.\n\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043d\u043e\u0432\u043e \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e.";
                    Xeption error = Xeption.forEndUser((String)message, (Object[])new Object[0]);
                    StackTraceElement[] elms = new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"container", (String)ctr.toString()), IncidentsHelper.getContextStackTraceElement((String)"expectedRevision", (String)String.valueOf(e.getExpected())), IncidentsHelper.getContextStackTraceElement((String)"conflictedRevision", (String)String.valueOf(e.getConflicted()))};
                    IncidentsHelper.addStackTraceElement((Throwable)error, (StackTraceElement[])elms);
                    throw new ServiceException(message, (Throwable)error);
                }
                newCtr = (EntityContainer)XCloneHelper.clone((XCloneable)newCtr);
                RpcServiceHelper.createActualizer().actualize((Object)newCtr.getEntity());
                DataTransferPackage dtp = new DataTransferPackage(newCtr);
                if (data.getSupplement() != null) {
                    Object supplement = SupplementHandlersRegistry.get().populateSupplement(data.getSupplement().getClass(), ctr);
                    dtp.setSupplement(supplement);
                }
                permissions = loadAclPermissions ? AclUtil.getPermissions((EntityContainer<? extends BaseEntity>)newCtr, newCtr.getEntityType(), ctx.getUser()) : null;
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)dtp, permissions);
                return pair;
            }
            finally {
                LogicalStorage.get().cancelUnitOfWork(session);
            }
        });
    }

    public static enum ClientEntityOperation {
        SAVE,
        ROLLBACK,
        DELETE;

    }
}

