/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.rpc.WorkspaceService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.java.plugin.registry.Extension;
import org.xml.sax.InputSource;

public class WorkspaceServiceImpl
extends BaseSecureServiceImpl
implements WorkspaceService {
    public FxWorkspace getWorkspace(ServiceInvocationContext ctx, String owner, boolean strict) throws ServiceException {
        DebugUtil.setThreadName((String)"WorkspaceServiceImpl-getWorkspace");
        try {
            this.checkContext(ctx);
            try {
                FxWorkspace fxWorkspace = this.findWorkspace(owner, strict);
                return fxWorkspace;
            }
            catch (Throwable t) {
                this.log.error("failed loading workspace", t);
                throw new ServiceException("failed loading workspace", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public FxWorkspace getDefaultWorkspace(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"WorkspaceServiceImpl-getDefaultWorkspace");
        try {
            this.checkContext(ctx);
            try {
                FxWorkspace fxWorkspace = (FxWorkspace)XCloneHelper.clone((XCloneable)this.createDefaultWorkspace(), (boolean)true);
                return fxWorkspace;
            }
            catch (Throwable t) {
                this.log.error("failed loading default workspace", t);
                throw new ServiceException("failed loading default workspace", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private FxWorkspace findWorkspace(String owner, boolean strict) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FxWorkspace.Property.owner.name(), (Object)owner));
        List data = AssetsStorage.get().search(FxWorkspace.class, query).getData();
        if (!data.isEmpty()) {
            return (FxWorkspace)data.get(0);
        }
        if (strict) {
            return null;
        }
        Collection groups = AclHelper.getUserGroups((String)owner);
        if (!groups.isEmpty()) {
            query = new SearchQuery();
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>(groups.size());
            for (AclGroup group : groups) {
                criterions.add(SearchCriterion.eq((String)FxWorkspace.Property.owner.name(), (Object)group.getId()));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            query.getCriteria().getOrders().put(FxWorkspace.Property.owner.name(), SortOrder.ASC);
            query.setLimit(1);
            data = AssetsStorage.get().search(FxWorkspace.class, query).getData();
            if (!data.isEmpty()) {
                return this.cloneWorkspace((FxWorkspace)data.get(0), owner);
            }
        }
        HashSet<String> checkedGroups = new HashSet<String>();
        block1: for (AclGroup group : groups) {
            String groupId = group.getParentId();
            while (groupId != null && !checkedGroups.contains(groupId)) {
                checkedGroups.add(groupId);
                group = AclHelper.getGroupParent((String)groupId);
                if (group == null) continue block1;
                query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FxWorkspace.Property.owner.name(), (Object)group.getId()));
                data = AssetsStorage.get().search(FxWorkspace.class, query).getData();
                if (!data.isEmpty()) {
                    return this.cloneWorkspace((FxWorkspace)data.get(0), owner);
                }
                groupId = group.getParentId();
            }
        }
        query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FxWorkspace.Property.owner.name(), null));
        data = AssetsStorage.get().search(FxWorkspace.class, query).getData();
        return this.cloneWorkspace(data.isEmpty() ? this.createDefaultWorkspace() : (FxWorkspace)data.get(0), owner);
    }

    private FxWorkspace createDefaultWorkspace() throws Exception {
        List extensions = JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server.fx.core", (String)"DefaultWorkspace");
        FxWorkspace result = new FxWorkspace();
        if (!extensions.isEmpty()) {
            result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)JpfUtil.getResource((Extension)((Extension)extensions.get(extensions.size() - 1)), (String)"location").openStream())).getDocumentElement());
        }
        return result;
    }

    public FxWorkspace saveWorkspace(ServiceInvocationContext ctx, FxWorkspace workspace) throws ServiceException {
        try {
            return (FxWorkspace)AssetsStorage.get().save((BaseAsset)workspace);
        }
        catch (Throwable t) {
            this.log.error("failed saving workspace", t);
            throw new ServiceException("failed saving workspace", t);
        }
    }

    private FxWorkspace cloneWorkspace(FxWorkspace src, String newOwner) throws Exception {
        FxWorkspace result = (FxWorkspace)XCloneHelper.clone((XCloneable)src, (boolean)false);
        result.setUid(UUIDUtil.toString((UUID)UUID.randomUUID()));
        result.setOwner(newOwner);
        return result;
    }
}

