/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc.service;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModification;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCache;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetServiceImpl
extends BaseSecureServiceImpl
implements AssetService {
    public <A extends BaseAsset> SearchResult<A> search(ServiceInvocationContext ctx, Class<A> cls, SearchQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-search");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("search() BEGIN cls=" + cls.getName());
                SearchResult result = AssetsStorage.get().search(cls, query);
                this.log.debug("search() END cls=" + cls.getName());
                SearchResult searchResult = result;
                return searchResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed searching assets of type %s", cls.getName()), t);
                throw new ServiceException("failed searching assets", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <A extends BaseAsset> SearchResult<A> find(ServiceInvocationContext ctx, Class<A> cls, String propertyName, Object value) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-find");
        try {
            this.checkContext(ctx);
            this.log.debug("find() BEGIN cls=" + cls.getName());
            try {
                SearchResult result = new SearchResult();
                BaseAsset asset = AssetsStorage.get().find(cls, propertyName, value);
                result.setTimestamp(new Date());
                result.setTotalCount(asset == null ? 0 : 1);
                if (asset != null) {
                    result.getData().add(asset);
                }
                this.log.debug("find() END cls=" + cls.getName());
                SearchResult searchResult = result;
                return searchResult;
            }
            catch (Throwable t) {
                SearchResult searchResult;
                try {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)propertyName, (Object)value));
                    searchResult = AssetsStorage.get().search(cls, query);
                }
                catch (Throwable t2) {
                    this.log.error(String.format("failed findinf asset of type %s", cls.getName()), t2);
                    throw new ServiceException("failed searching assets", t2);
                }
                DebugUtil.restoreThreadName();
                return searchResult;
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <A extends BaseAsset> ProjectionResult search(ServiceInvocationContext ctx, Class<A> cls, ProjectionQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-search");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("search() BEGIN cls=" + cls.getName());
                ProjectionResult result = AssetsStorage.get().search(cls, query);
                this.log.debug("search() END cls=" + cls.getName());
                ProjectionResult projectionResult = result;
                return projectionResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed searching assets of type %s", cls.getName()), t);
                throw new ServiceException("failed searching assets", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <A extends BaseAsset> A save(ServiceInvocationContext ctx, A asset) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-save");
        try {
            A a;
            this.checkContext(ctx);
            try {
                this.log.debug("save() BEGIN asset=" + asset);
                AssetsStorage.get().save(asset);
                this.log.debug("save() END asset=" + asset);
                a = asset;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed saving asset %s", asset), t);
                throw new ServiceException("failed saving asset", t);
            }
            return a;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <A extends BaseAsset> A load(ServiceInvocationContext ctx, Class<A> cls, String uid) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-load");
        try {
            BaseAsset baseAsset;
            this.checkContext(ctx);
            try {
                this.log.debug("load() BEGIN cls={}, uid={}", (Object)cls.getName(), (Object)uid);
                BaseAsset asset = AssetsStorage.get().load(cls, uid);
                this.log.debug("load() END  cls={}, uid={}", (Object)cls.getName(), (Object)uid);
                baseAsset = asset;
            }
            catch (Throwable t) {
                this.log.error("failed loading asset {} {}", new Object[]{cls.getName(), uid, t});
                throw new ServiceException("failed loading asset", t);
            }
            return (A)baseAsset;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public <A extends BaseAsset> List<A> saveMultiple(ServiceInvocationContext ctx, List<A> assets) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-saveMultiple");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("saveMultiple() BEGIN");
                AssetsStorage.get().save(assets);
                this.log.debug("saveMultiple() END");
                List<A> list = assets;
                return list;
            }
            catch (Throwable t) {
                this.log.error("failed saving multiple assets", t);
                throw new ServiceException("failed saving multiple assets", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends BaseAsset> void delete(ServiceInvocationContext ctx, A asset) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-delete");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("delete() BEGIN asset=" + asset);
                AssetsStorage.get().delete(asset);
                this.log.debug("delete() END asset=" + asset);
            }
            catch (Throwable t) {
                this.log.error(String.format("failed deleting asset %s", asset), t);
                throw new ServiceException("failed deleting asset", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public CacheDataModification<AssetReference<?>> getModifications(ServiceInvocationContext ctx, Date timeStamp, Collection<String> classNames) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-getModifications");
        try {
            this.checkContext(ctx);
            try {
                CacheDataModification cacheDataModification = ((AssetsCacheServerModificationsCache)Environment.getPublished(AssetsCacheServerModificationsCache.class)).getModifications(timeStamp, classNames);
                return cacheDataModification;
            }
            catch (Throwable t) {
                this.log.error("getModifications failed", t);
                throw new ServiceException("getModifications failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Map<String, String> getMetadata(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"AssetServiceImpl-getMetadata");
        try {
            this.checkContext(ctx);
            try {
                HibernatePhysicalStorageRegistry hpsr;
                this.log.debug("getMetadata() BEGIN");
                HashMap<String, String> result = new HashMap<String, String>();
                try {
                    hpsr = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
                }
                catch (Exception e) {
                    hpsr = null;
                }
                if (hpsr != null) {
                    for (Class assetClass : hpsr.getAssetDataClasses().keySet()) {
                        result.put(assetClass.getName(), "Asset " + MiscUtil.getSimpleClassName((Class)assetClass));
                    }
                }
                this.log.debug("getMetadata() END");
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            catch (Throwable t) {
                this.log.error("failed get metadata", t);
                throw new ServiceException("failed get metadata", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

