/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SupplementHandlersRegistry {
    private final Map<String, List<SupplementHandler<?, ?>>> handlers = new HashMap();

    public static SupplementHandlersRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (SupplementHandlersRegistry)Environment.getPublished(SupplementHandlersRegistry.class);
    }

    private static String buildKey(Class<?> entityClass, Class<?> supplementClass) {
        return entityClass.getName() + '|' + supplementClass.getName();
    }

    SupplementHandlersRegistry() {
    }

    public void register(SupplementHandler<?, ?> handler) {
        String key = SupplementHandlersRegistry.buildKey(handler.getEntityClass(), handler.getSupplementClass());
        List<SupplementHandler<?, ?>> list = this.handlers.get(key);
        if (list == null) {
            list = new ArrayList();
            this.handlers.put(key, list);
        }
        list.add(handler);
        if (list.size() > 1) {
            list.sort(Comparator.comparing(SupplementHandler::getPriority));
        }
    }

    public <S> S populateSupplement(Class<S> supplementClass, EntityContainer<?> ctr) throws Exception {
        if (supplementClass == null) {
            return null;
        }
        S result = supplementClass.newInstance();
        for (Class entityClass = ctr.getEntityType(); entityClass != null; entityClass = entityClass.getSuperclass()) {
            List<SupplementHandler<?, ?>> list = this.handlers.get(SupplementHandlersRegistry.buildKey(entityClass, supplementClass));
            if (list == null) continue;
            for (SupplementHandler<?, ?> handler : list) {
                handler.populateSupplement(ctr, result);
            }
        }
        return result;
    }

    public void populateEntity(Object supplement, EntityContainer<?> ctr) {
        if (supplement == null) {
            return;
        }
        Class<?> supplementClass = supplement.getClass();
        for (Class entityClass = ctr.getEntityType(); entityClass != null; entityClass = entityClass.getSuperclass()) {
            List<SupplementHandler<?, ?>> list = this.handlers.get(SupplementHandlersRegistry.buildKey(entityClass, supplementClass));
            if (list == null) continue;
            for (SupplementHandler<?, ?> handler : list) {
                handler.populateEntity(supplement, ctr);
            }
        }
    }

    private static class Holder {
        public static final SupplementHandlersRegistry INSTANCE = (SupplementHandlersRegistry)Environment.getPublished(SupplementHandlersRegistry.class);

        private Holder() {
        }
    }
}

