/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp;

import com.gridnine.xtrip.common.fx.model.AclAspectVariantData;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.model.IbeAclAspectData;
import com.gridnine.xtrip.common.fx.model.PrefetchedData;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspect;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectIndex;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariant;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.fx.prefetched.PrefetchedDataHandler;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;

public class IbePrefetchedDataHandler
implements PrefetchedDataHandler {
    public void populate(PrefetchedData data) {
        AgentData agentData = data.getCurrentAgentData();
        for (EntityContainer aspectCtr : StorageHelper.getEntityContainers((SearchQuery)new SearchQuery(), IbeCorpAclAspectIndex.class)) {
            IbeAclAspectData aspectData = new IbeAclAspectData(aspectCtr.getUid());
            aspectData.setName(((IbeCorpAclAspect)aspectCtr.getEntity()).getName());
            aspectData.setVariantsType(((IbeCorpAclAspect)aspectCtr.getEntity()).getVariantsType());
            data.getAvailableIbeAclAspects().add(aspectData);
            for (IbeCorpAclAspectVariant variant : ((IbeCorpAclAspect)aspectCtr.getEntity()).getVariants()) {
                AclAspectVariantData variantData = new AclAspectVariantData(variant.getUid());
                variantData.setName(variant.getName());
                aspectData.getVariants().add(variantData);
            }
        }
        data.getReloadTriggersClassNames().add(IbeCorpAclAspect.class.getName());
        data.setXreportsIntegrationEnabled(XreportsIntegrationHelper.settingsExist() && XreportsIntegrationHelper.getSettings().isEnabled());
        data.setSbisIntegrationEnabled(SbisIntegrationHelper.hasEnabledSbisIntegrationSettings());
        data.setSapIntegrationEnabled(SapIntegrationHelper.hasEnabledSapIntegrationSettings());
        EntityContainer container = EntityStorage.get().load(MailServerSettings.class, UniqueSettingsRegistry.get().getUidByClassName(MailServerSettings.class.getName()));
        if (container != null && ((MailServerSettings)container.getEntity()).getMailServerParameters() != null) {
            data.setMailHostSpecified(TextUtil.nonBlank((String)((MailServerSettings)container.getEntity()).getMailServerParameters().getHost()));
        }
        data.setShipmentReconciliationReportEnabled(EntityStorage.get().isAvailable(IndexBasedTemplateReportDescription.class, "SHIPMENT_RECONCILIATION_REPORT_TEMPLATE_UID"));
    }
}

