/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.async;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.RpcBookingFileRef;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.model.FxRpcImportHotelBookingFileParameters;
import com.gridnine.xtrip.common.hotels2.model.BaseHotelsProviderAccount;
import com.gridnine.xtrip.common.hotels2.model.FindReservationsParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorData;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.ImportHotelBookingFileParams;
import com.gridnine.xtrip.common.hotels2.model.ReservationInfo;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ImportHotelAsyncTask
implements AsyncTask<FxRpcImportHotelBookingFileParameters, RpcBookingFileRef> {
    public RpcBookingFileRef execute(FxRpcImportHotelBookingFileParameters fxParams, TaskExecutionCallback callback) throws Exception {
        SalesContext salesContext = this.buildSalesContext(fxParams);
        List<String> orderNumbers = fxParams.isImportByNumber() ? Collections.singletonList(fxParams.getOrderNumber()) : this.findReservations(fxParams, callback);
        ImportHotelBookingFileParams params = new ImportHotelBookingFileParams();
        params.setGdsAccount(fxParams.getGdsAccount());
        params.setProvider(fxParams.getHotelProvider());
        RpcBookingFileRef rpcBookingFileRef = null;
        for (String orderNumber : orderNumbers) {
            params.setPnr(orderNumber);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS.name(), params);
            data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
            Exception ex = null;
            try {
                IntegrationBusFacade.get().processRouteSync("hotels2:import-booking:import-booking-route", data);
            }
            catch (Exception e) {
                ex = e;
            }
            Boolean bookingFileSaved = (Boolean)data.get(IBusHotelsContextKeys.HOTELS_BOOKING_FILE_SAVED.name());
            if (bookingFileSaved == null || bookingFileSaved.booleanValue()) {
                callback.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0}", (Object[])new Object[]{orderNumber})});
                if (fxParams.isImportByNumber()) {
                    EntityContainer bookingCtr = (EntityContainer)data.get(IBusMidofficeContextKeys.BOOKING_FILE.name());
                    rpcBookingFileRef = new RpcBookingFileRef(bookingCtr.toReference());
                }
            }
            ArrayList messages = new ArrayList(((Map)data.get("messages")).values());
            if (ex != null && !MessagesHelper.hasErrorMessage(messages)) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)ex.getMessage(), (Throwable)ex, (Object[])new Object[0]));
            }
            callback.addMessages(messages);
        }
        return rpcBookingFileRef;
    }

    private List<String> findReservations(FxRpcImportHotelBookingFileParameters fxParams, TaskExecutionCallback callback) throws Exception {
        FindReservationsParameters params = new FindReservationsParameters();
        params.setStartDate(fxParams.getDateFrom());
        params.setEndDate(fxParams.getDateTo());
        params.setGdsAccount(fxParams.getGdsAccount());
        HashMap<String, FindReservationsParameters> data = new HashMap<String, FindReservationsParameters>();
        data.put(IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS.name(), params);
        Exception ex = null;
        try {
            IntegrationBusFacade.get().processRouteSync("hotels2:find-reservations:find-reservations-route", data);
        }
        catch (Exception e) {
            ex = e;
        }
        ArrayList messages = new ArrayList(((Map)data.get("messages")).values());
        if (ex != null && !MessagesHelper.hasErrorMessage(messages)) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)ex.getMessage(), (Throwable)ex, (Object[])new Object[0]));
        }
        callback.addMessages(messages);
        List orders = (List)data.get(IBusHotelsContextKeys.HOTELS_FIND_RESERVATIONS_RESULT.name());
        if (CollectionUtil.isNotEmpty((Collection)orders)) {
            Optional<String> login;
            HotelsAggregatorGdsAccount gdsAccount;
            EntityContainer gdsAccountCtr = EntityStorageHelper.resolve((EntityReference)fxParams.getGdsAccount());
            if (gdsAccountCtr != null && HotelProvider.OSTROVOK == (gdsAccount = (HotelsAggregatorGdsAccount)gdsAccountCtr.getEntity()).getProvider() && (login = Optional.ofNullable(gdsAccount.getHotelsAggregatorData()).map(HotelsAggregatorData::getVendors).map(vendors -> (BaseHotelsProviderAccount)vendors.get(HotelProvider.OSTROVOK)).map(BaseHotelsProviderAccount::getLogin)).isPresent()) {
                orders = orders.stream().filter(reservationInfo -> MiscUtil.equals((Object)reservationInfo.getAccountLogin(), login.get())).collect(Collectors.toList());
            }
            return orders.stream().map(ReservationInfo::getRecordLocatorProvider).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private SalesContext buildSalesContext(FxRpcImportHotelBookingFileParameters fxParams) {
        SalesContext result = new SalesContext();
        result.setAgent(fxParams.getAgent());
        result.setAgency(fxParams.getAgency());
        result.setSubagency(fxParams.getSubagency());
        result.setClient(fxParams.getClient());
        result.setSalesPoint(fxParams.getSalesPoint());
        return result;
    }
}

