/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpMiscService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportParameters;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.PrepareReportCallback;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.HashMap;

public class IbecorpMiscServiceImpl
extends BaseSecureServiceImpl
implements IbecorpMiscService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexBasedTemplateReportDocument getShipmentReconciliationReport(ServiceInvocationContext ctx, EntityReference<Shipment> shipment) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpMiscServiceImpl-getShipmentReconciliationReport");
        try {
            this.checkContext(ctx);
            EntityContainer descriptionCtr = EntityStorage.get().load(IndexBasedTemplateReportDescription.class, "SHIPMENT_RECONCILIATION_REPORT_TEMPLATE_UID");
            if (descriptionCtr == null) {
                IndexBasedTemplateReportDocument doc = new IndexBasedTemplateReportDocument();
                doc.getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0432 \u0431\u0430\u0437\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d \u043e\u0442\u0447\u0435\u0442\u0430 \u0441\u0432\u0435\u0440\u043a\u0438 \u043f\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", (Object[])new Object[0]));
                IndexBasedTemplateReportDocument indexBasedTemplateReportDocument = doc;
                return indexBasedTemplateReportDocument;
            }
            IndexBasedTemplateReportParameters reportParameters = new IndexBasedTemplateReportParameters();
            reportParameters.setDescription(descriptionCtr.toReference());
            reportParameters.setReportId("index-based-template-report");
            RequestedParameterValue parameterValue = new RequestedParameterValue();
            parameterValue.setKey("shipment");
            parameterValue.setValue(shipment);
            reportParameters.getRequestedParameters().add(parameterValue);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ASYNC_TASK_REPORT_ID", reportParameters.getReportId());
            params.put("key-report-params", reportParameters);
            params.put("KEY_PREPARE_REPORT_CALLBACK", new PrepareReportCallback(){

                public void updateProgress(byte progress, String message) {
                }

                public boolean isToBeStopped() {
                    return Thread.currentThread().isInterrupted();
                }
            });
            ReportPrepareHandler prepareHandler = ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(reportParameters.getReportId());
            try {
                prepareHandler.prepareData(params);
            }
            catch (Exception e) {
                IndexBasedTemplateReportDocument doc = new IndexBasedTemplateReportDocument();
                doc.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442", (Throwable)e, (Object[])new Object[0]));
                IndexBasedTemplateReportDocument indexBasedTemplateReportDocument = doc;
                DebugUtil.restoreThreadName();
                return indexBasedTemplateReportDocument;
            }
            IndexBasedTemplateReportDocument e = (IndexBasedTemplateReportDocument)((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get(reportParameters.getReportId()).renderReport(params).getEntity();
            return e;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

