/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.rpc;

import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.PrintActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.PrintPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.kkt.atol.AtolCommonHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.DocumentSortType;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinancePrintData;
import com.gridnine.xtrip.common.model.finance.PrintDocumentType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportGroup;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportReference;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.CustomNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class IbecorpModelServiceImpl
extends BaseSecureServiceImpl
implements IbecorpModelService {
    public List<ReportReference> getAllXreportsRegistriesReferences(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getAllXreportsRegistriesReferences");
        try {
            this.checkContext(ctx);
            try {
                List list = XreportsIntegrationHelper.getAllRegistries();
                return list;
            }
            catch (Throwable t) {
                throw new ServiceException("failed getting reports list", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<ReportGroup> getAllXreportsReportGroups(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getAllXreportsReportGroups");
        try {
            this.checkContext(ctx);
            try {
                List list = XreportsIntegrationHelper.getAllReportGroups();
                return list;
            }
            catch (Throwable t) {
                throw new ServiceException("failed getting report groups list", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Map<String, String> getAllXreportsRegistryFields(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getAllXreportsRegistryFields");
        try {
            this.checkContext(ctx);
            try {
                Map map = XreportsIntegrationHelper.getAllRegistryFields();
                return map;
            }
            catch (Throwable t) {
                throw new ServiceException("failed getting report registry fields", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public boolean isPersonalDataStuffOff(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-isPersonalDataStuffOn");
        try {
            this.checkContext(ctx);
            try {
                boolean bl = XreportsIntegrationHelper.isPersonalDataStuffOff();
                return bl;
            }
            catch (Throwable t) {
                throw new ServiceException("failed to check if personal data stuff is on", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Integer getKettlePackSize(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getKettlePackSize");
        try {
            this.checkContext(ctx);
            try {
                Integer n = XreportsIntegrationHelper.getKettlePackSize();
                return n;
            }
            catch (Throwable t) {
                throw new ServiceException("failed to get kettle pack size", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public boolean setKettlePackSize(ServiceInvocationContext ctx, int size) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-setKettlePackSize");
        try {
            this.checkContext(ctx);
            try {
                boolean bl = XreportsIntegrationHelper.setKettlePackSize((int)size);
                return bl;
            }
            catch (Throwable t) {
                throw new ServiceException("failed to set kettle pack size", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Integer getOptKettlePackSize(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getOptKettlePackSize");
        try {
            this.checkContext(ctx);
            try {
                Integer n = XreportsIntegrationHelper.getOptimalKettlePackSize();
                return n;
            }
            catch (Throwable t) {
                throw new ServiceException("failed to get optimal kettle pack size", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public IbecorpModelService.ShipmentDocumentsData getShipmentDocumentsData(ServiceInvocationContext context, EntityReference<Shipment> shipmentReference, IbecorpModelService.FinanceDocumentsChangeSettings financeDocumentsChangeSettings, boolean getReportRegistries, boolean usePrintSettings) throws ServiceException {
        DebugUtil.setThreadName((String)"ShipmentsServiceImpl-getShipmentDocumentsData");
        try {
            this.checkContext(context);
            try {
                ArrayList<Message> messages = new ArrayList<Message>();
                EntityStorageContext entityStorageContext = new EntityStorageContext();
                EntityContainer shipmentContainer = EntityStorageHelper.resolve(shipmentReference, (EntityStorageContext)entityStorageContext);
                Objects.requireNonNull(shipmentContainer);
                LazyValueHolder shipmentContracts = new LazyValueHolder(() -> IbecorpRulesHelper.getContractsForShipment((EntityContainer)shipmentContainer));
                PrintActionSet printActionSet = usePrintSettings ? this.applyPrintRules((EntityContainer<Shipment>)shipmentContainer, (LazyValueHolder<List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>>>)shipmentContracts, messages) : null;
                List<IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData> financeDocuments = this.getFinanceDocuments((EntityContainer<Shipment>)shipmentContainer, financeDocumentsChangeSettings, printActionSet, entityStorageContext, messages);
                List<IbecorpModelService.ShipmentDocumentsData.DocumentData> documents = this.getDocumentsByProducts((EntityContainer<Shipment>)shipmentContainer, printActionSet, entityStorageContext, messages);
                IbecorpModelService.ReportRegistryData reportRegistry = getReportRegistries ? this.getReportRegistry((EntityContainer<Shipment>)shipmentContainer, (LazyValueHolder<List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>>>)shipmentContracts, messages) : null;
                IbecorpModelService.ShipmentDocumentsData shipmentDocumentsData = new IbecorpModelService.ShipmentDocumentsData(shipmentReference, financeDocuments, documents, reportRegistry, messages);
                return shipmentDocumentsData;
            }
            catch (Throwable t) {
                this.log.error("failed getting print data", t);
                throw new ServiceException("failed getting print data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public IbecorpModelService.ReportRegistryData getReportRegistryData(ServiceInvocationContext context, EntityReference<Shipment> shipment) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getReportRegistryData");
        try {
            this.checkContext(context);
            try {
                ArrayList<Message> messages = new ArrayList<Message>();
                EntityStorageContext entityStorageContext = new EntityStorageContext();
                EntityContainer shipmentContainer = EntityStorageHelper.resolve(shipment, (EntityStorageContext)entityStorageContext);
                if (shipmentContainer == null) {
                    throw Xeption.forDeveloper((String)("unable to load shipment " + shipment), (Object[])new Object[0]);
                }
                IbecorpModelService.ReportRegistryData reportRegistryData = this.getReportRegistry((EntityContainer<Shipment>)shipmentContainer, (LazyValueHolder<List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>>>)new LazyValueHolder(() -> IbecorpRulesHelper.getContractsForShipment((EntityContainer)shipmentContainer)), messages);
                return reportRegistryData;
            }
            catch (Throwable t) {
                this.log.error("failed getting registry data", t);
                throw new ServiceException("failed getting registry data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MailDocument createMailDocument(ServiceInvocationContext context, EntityReference<BookingFile> bookingRef, String navigationKey, EntityReference<?> ... documentsRefs) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-createMailDocument");
        try {
            this.checkContext(context);
            try {
                List docs = null;
                if (documentsRefs.length > 0) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])Arrays.stream(documentsRefs).map(ref -> SearchCriterion.eq((String)"containerUid", (Object)ref)).toArray(SearchCriterion[]::new))));
                    docs = (List)CollectionUtil.requireNonEmpty((Collection)EntityStorage.get().search(BasicDocumentIndex.class, query).getData());
                }
                EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
                BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
                Reservation res = TextUtil.isBlank((String)navigationKey) ? (Reservation)bookingFile.getReservations().stream().findFirst().orElse(null) : (Reservation)BookingHelper.getProducts((BookingFile)bookingFile).stream().filter(product -> MiscUtil.equals((Object)product.getUid(), (Object)navigationKey)).findFirst().map(BaseProduct::getReservation).orElse(null);
                EntityReference siteReference = Optional.ofNullable(bookingFile.getSite()).orElseGet(() -> {
                    EntityContainer agencyCtr = EntityStorage.get().resolve(bookingFile.getAgency());
                    if (agencyCtr == null) {
                        return null;
                    }
                    Organization agency = (Organization)agencyCtr.getEntity();
                    return agency.getB2bSite() != null ? agency.getB2bSite() : agency.getB2cSite();
                });
                Locale locale = Optional.ofNullable(bookingFile.getCustomer()).map(Customer::getPreferredLocale).orElse(LocaleHelper.getCurrentLocale());
                NotificationParameters parameters = new NotificationParameters(bookingFile.getAgency(), bookingFile.getCustomerProfile(), siteReference, locale, bookingCtr.toReference(), SalesContextHandler.get().createSalesContext(res));
                CustomNotification notification = new CustomNotification(parameters, res, docs);
                MailDocument mailDocument = Objects.requireNonNull(notification.getTemplate() != null ? NotificationHelper.prepareMailDocument((Notification)notification) : NotificationHelper.prepareSimpleMailDocument((Notification)notification));
                return mailDocument;
            }
            catch (Throwable t) {
                this.log.error("failed creation of mail document", t);
                throw new ServiceException("failed creation of mail document", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMailDocument(ServiceInvocationContext context, MailDocument mailDocument, boolean saveDocument) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-sendMailDocument");
        try {
            this.checkContext(context);
            try {
                EntityContainer bookingCtr = Optional.ofNullable(EntityStorage.get().resolve(mailDocument.getOwner())).orElseThrow(() -> new Exception("Can't resolve booking with uid " + mailDocument.getOwner()));
                EntityReference siteRef = Optional.ofNullable(((BookingFile)bookingCtr.getEntity()).getSite()).orElseGet(() -> {
                    Organization agency = (Organization)EntityStorage.get().resolve(((BookingFile)bookingCtr.getEntity()).getAgency()).getEntity();
                    return agency.getB2bSite() != null ? agency.getB2bSite() : agency.getB2cSite();
                });
                if (siteRef == null) {
                    throw new Exception("Missing site reference in booking " + ((BookingFile)bookingCtr.getEntity()).getNumber());
                }
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)siteRef), SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)SMProfileType.NOTIFICATIONS_SETTINGS)}));
                List indexes = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
                BaseSMProfileIndex index = (BaseSMProfileIndex)indexes.stream().findFirst().orElseThrow(() -> new Exception("Missing notifications settings!"));
                SMNotificationsSettings notificationsSettings = (SMNotificationsSettings)EntityStorage.get().resolve(index.getSource()).getEntity();
                boolean isSent = NotificationHelper.sendMail((MailServerParameters)notificationsSettings.getMailServerParameters(), (MailDocument)mailDocument, (boolean)saveDocument);
                if (!isSent) {
                    throw new Exception("Mail document not sent. Check your system properties");
                }
            }
            catch (Throwable t) {
                this.log.error("failed to send mail document", t);
                throw new ServiceException("failed to send mail document", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFinanceMailDocument(ServiceInvocationContext context, List<EntityReference<Shipment>> shipments, List<String> notificationEmails) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-sendFinanceMailDocument");
        try {
            this.checkContext(context);
            try {
                if (notificationEmails.isEmpty()) {
                    throw Xeption.forDeveloper((String)"Missing email!", (Object[])new Object[0]);
                }
                EntityStorageContext entityStorageContext = new EntityStorageContext();
                Map<NestedEntityReference, List<Shipment>> shipmentsMap = shipments.stream().map(it -> (Shipment)EntityStorageHelper.resolve((EntityReference)it, (EntityStorageContext)entityStorageContext).getEntity()).collect(Collectors.groupingBy(Shipment::getContract));
                for (Map.Entry<NestedEntityReference, List<Shipment>> entry : shipmentsMap.entrySet()) {
                    FinanceDocument finDoc;
                    EntityReference contractRef = (EntityReference)entry.getKey();
                    EntityContainer contractCtr = EntityStorageHelper.resolve((EntityReference)contractRef, (EntityStorageContext)entityStorageContext);
                    if (contractCtr == null) continue;
                    RuleProxy proxy = new RuleProxy();
                    proxy.setProxyType(Targets.NOTIFICATION_TEMPLATE_FINDOCS.getId());
                    proxy.setProxyDate(new Date());
                    proxy.setPropertySet((Object)new NotificationsPropertySet());
                    proxy.setActionSet((Object)new NotificationsActionSet());
                    proxy.setContractType(((Contract)contractCtr.getEntity()).getContractType().name());
                    StringBuilder shipmentNumbers = new StringBuilder();
                    ArrayList mailPartsList = new ArrayList();
                    HashSet rules = new HashSet();
                    for (Shipment shipment : entry.getValue()) {
                        rules.addAll(ProfileHelper.getRuleContainers((EntityContainer)contractCtr, (Date)shipment.getDate(), Collections.singleton(proxy.getProxyType())));
                        if (shipmentNumbers.length() > 0) {
                            shipmentNumbers.append(",");
                        }
                        shipmentNumbers.append(shipment.getNumber());
                        ArrayList<MailPart> attachments = new ArrayList<MailPart>();
                        for (EntityReference finDocRef : shipment.getFinanceDocuments()) {
                            BinaryData content;
                            EntityContainer finDocCtr = EntityStorageHelper.resolve((EntityReference)finDocRef, (EntityStorageContext)entityStorageContext);
                            if (finDocCtr == null || (content = (finDoc = (FinanceDocument)finDocCtr.getEntity()).getContent()) == null || content.getData() == null) continue;
                            MailPart att = new MailPart();
                            att.setName(TextUtil.nonNullStr((String)finDoc.getName()).concat(".pdf"));
                            att.setContentType(ContentType.PDF);
                            att.setData(content.getContentType() != ContentType.PDF ? JasperUtil.convertToPdf((byte[])content.getData()) : content.getData());
                            attachments.add(att);
                        }
                        mailPartsList.addAll(attachments);
                    }
                    for (EntityContainer rule : rules) {
                        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                    }
                    MailTemplate template = ((NotificationsActionSet)proxy.getActionSet()).getFinanceDocsNotificationTemplate();
                    if (template == null) {
                        throw Xeption.forEndUser((String)"\u041e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u044e\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043f\u0438\u0441\u044c\u043c\u0430 \u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u0445", (Object[])new Object[0]);
                    }
                    Locale locale = this.getLocale(template);
                    MailAddress mailFrom = new MailAddress();
                    MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
                    MailServerParameters mailServerParameters = mailServerSettings.getMailServerParameters();
                    mailFrom.setAddress(mailServerSettings.getDefaultFrom());
                    ArrayList<MailAddress> mailsTo = new ArrayList<MailAddress>();
                    finDoc = notificationEmails.iterator();
                    while (finDoc.hasNext()) {
                        String recipient = finDoc.next();
                        MailAddress mailTo = new MailAddress();
                        mailTo.setAddress(recipient);
                        mailsTo.add(mailTo);
                    }
                    MailPart body = new MailPart();
                    body.setContentType(ContentType.HTML);
                    body.setName("body.html");
                    String templateData = this.getTemplateData(template);
                    String templateBody = this.getReplaceVariableInText(shipmentNumbers.toString(), templateData);
                    body.setData(templateBody.getBytes());
                    String localeSubject = this.getTemplateSubject(template);
                    if (StringUtils.isBlank((String)localeSubject)) {
                        localeSubject = L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.FinanceDocNotification_Subject, (Locale)locale, (Object[])new Object[0]);
                    }
                    String subject = this.getReplaceVariableInText(shipmentNumbers.toString(), localeSubject);
                    MailPart[] attachments = mailPartsList.toArray(new MailPart[0]);
                    MailDocument mailDocument = NotificationHelper.buildMailDocument(null, (MailAddress)mailFrom, mailsTo, null, null, (String)subject, (MailPart)body, (boolean)false, (boolean)false, (MailPart[])attachments);
                    NotificationHelper.sendMail((MailServerParameters)mailServerParameters, (MailDocument)mailDocument, (boolean)false);
                }
            }
            catch (Throwable t) {
                this.log.error("failed to send mail document", t);
                throw new ServiceException("failed to send mail document", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<String> getCustomerEmails(ServiceInvocationContext context, List<EntityReference<Shipment>> shipmentRefs) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getEmails");
        try {
            this.checkContext(context);
            try {
                EntityStorageContext entityStorageContext = new EntityStorageContext();
                ArrayList<BaseEntity> shipments = new ArrayList<BaseEntity>();
                for (EntityReference<Shipment> shipmentRef : shipmentRefs) {
                    EntityContainer shipmentContainer = EntityStorageHelper.resolve(shipmentRef, (EntityStorageContext)entityStorageContext);
                    if (shipmentContainer == null) {
                        throw Xeption.forDeveloper((String)("unable to load shipment " + shipmentRef), (Object[])new Object[0]);
                    }
                    shipments.add(shipmentContainer.getEntity());
                }
                Shipment shipment = (Shipment)shipments.stream().findAny().orElseThrow(() -> Xeption.forDeveloper((String)"unable to load shipment ", (Object[])new Object[0]));
                EntityReference customer = shipment.getCustomer();
                boolean differentCustomers = shipments.stream().anyMatch(it -> !MiscUtil.equals((Object)it.getCustomer(), (Object)customer));
                if (differentCustomers) {
                    throw Xeption.forEndUser((String)"Select single client shipments", (Object[])new Object[0]);
                }
                EntityReference customerRef = shipment.getCustomer();
                EntityContainer customerCtr = EntityStorageHelper.resolve((EntityReference)customerRef, (EntityStorageContext)entityStorageContext);
                if (customerCtr == null) {
                    throw Xeption.forDeveloper((String)("unable to load customer " + customerRef), (Object[])new Object[0]);
                }
                Organization organization = (Organization)customerCtr.getEntity();
                List<String> list = organization.getCommunications().stream().filter(Communication::isSendFinDoc).map(Communication::getSense).filter(TextUtil::nonBlank).collect(Collectors.toList());
                return list;
            }
            catch (Throwable t) {
                this.log.error("failed to load customer", t);
                throw new ServiceException("failed to load customer", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<EntityContainer<AtolSettings>> findAtolSettings(ServiceInvocationContext context, Collection<Reservation> reservations) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-findAtolSettings");
        try {
            this.checkContext(context);
            try {
                List list = AtolCommonHelper.findSettingsByReservations(reservations);
                return list;
            }
            catch (Throwable t) {
                this.log.error("failed to find atol settings", t);
                throw new ServiceException("failed to find atol settings", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Set<String> getProductPaymentGatesNames(ServiceInvocationContext context, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpModelServiceImpl-getProductPaymentGatesNames");
        try {
            this.checkContext(context);
            try {
                Set paymentTypes = GeneralProductHelper.getClientFops((BaseProduct)product).stream().map(Fop::getType).collect(Collectors.toSet());
                Set<String> set = paymentTypes.stream().map(PGHelper::getPaymentGateNameFromPaymentType).filter(Objects::nonNull).collect(Collectors.toSet());
                return set;
            }
            catch (Throwable t) {
                this.log.error("failed to get product payment gates names", t);
                throw new ServiceException("failed to get product payment gates names", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private List<IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData> getFinanceDocuments(EntityContainer<Shipment> shipment, IbecorpModelService.FinanceDocumentsChangeSettings financeDocumentsChangeSettings, PrintActionSet printActionSet, EntityStorageContext entityStorageContext, List<Message> messages) {
        ArrayList<IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData> result = new ArrayList<IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData>();
        List financeDocuments = ((Shipment)shipment.getEntity()).getFinanceDocuments().stream().distinct().collect(Collectors.toList());
        List financeDocumentContainers = financeDocumentsChangeSettings != null ? financeDocuments.stream().map(financeDocumentReference -> {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), financeDocumentReference);
            context.put(IBusFinanceContextKeys.AGENT.name(), financeDocumentsChangeSettings.getAgent());
            context.put(IBusFinanceContextKeys.USE_DELEGATE.name(), financeDocumentsChangeSettings.isUseDelegate());
            context.put(IBusFinanceContextKeys.USE_FACSIMILE.name(), financeDocumentsChangeSettings.isUseFacsimile());
            try {
                IntegrationBusFacade.get().processRouteSync("finance-documents:render", context);
                EntityContainer financeDocumentContainer = (EntityContainer)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER.name());
                return Objects.requireNonNull(financeDocumentContainer);
            }
            catch (Exception e) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDocuments_processingError, (Throwable)e, (Object[])new Object[]{financeDocumentReference}));
                return null;
            }
        }).collect(Collectors.toList()) : ((Shipment)shipment.getEntity()).getFinanceDocuments().stream().distinct().map(ref -> EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)entityStorageContext)).collect(Collectors.toList());
        financeDocumentContainers.stream().filter(EntityStorageHelper::nonEmpty).filter(doc -> ((FinanceDocument)doc.getEntity()).getContent() != null && ((FinanceDocument)doc.getEntity()).getContent().getData() != null && ((FinanceDocument)doc.getEntity()).getContent().getData().length > 0 && ((FinanceDocument)doc.getEntity()).getContent().getContentType() != null).map(doc -> {
            int numberOfCopies;
            if (printActionSet != null) {
                FinancePrintData docPrintData = printActionSet.getPrintDatas().stream().filter(printData -> printData.getDocumentType() == this.getPrintDocumentType((FinanceDocument)doc.getEntity())).findFirst().orElse(null);
                if (docPrintData != null) {
                    numberOfCopies = docPrintData.getNumberOfCopies();
                } else {
                    numberOfCopies = 1;
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.DocumentPrintSettingNotFound, (Object[])new Object[]{doc.toReference(), shipment.toReference()}));
                }
            } else {
                numberOfCopies = 1;
            }
            return new IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData(doc, numberOfCopies);
        }).forEach(result::add);
        return result;
    }

    private List<IbecorpModelService.ShipmentDocumentsData.DocumentData> getDocumentsByProducts(EntityContainer<Shipment> shipment, PrintActionSet printActionSet, EntityStorageContext entityStorageContext, List<Message> messages) {
        List<NestedEntityReference<BookingFile, BaseProduct>> productRefs = FinanceDocumentHelper.getBillingItems((List)((Shipment)shipment.getEntity()).getBillingItems(), (EntityStorageContext)entityStorageContext).stream().map(BillingItem::getProduct).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (productRefs.isEmpty()) {
            return Collections.emptyList();
        }
        Map<NestedEntityReference<BookingFile, BaseProduct>, List<IbecorpModelService.ShipmentDocumentsData.DocumentData>> productToDocumentsMap = this.getProductAndDocuments(productRefs, shipment, printActionSet, entityStorageContext, messages);
        if (productToDocumentsMap.isEmpty()) {
            return Collections.emptyList();
        }
        if (printActionSet != null && printActionSet.getDocumentSortType() == DocumentSortType.TRAVELLER_NAME) {
            return this.getSortedByTravellerDocuments(productToDocumentsMap, entityStorageContext);
        }
        return productToDocumentsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<NestedEntityReference<BookingFile, BaseProduct>, List<IbecorpModelService.ShipmentDocumentsData.DocumentData>> getProductAndDocuments(List<NestedEntityReference<BookingFile, BaseProduct>> productRefs, EntityContainer<Shipment> shipment, PrintActionSet printActionSet, EntityStorageContext entityStorageContext, List<Message> messages) {
        HashMap<NestedEntityReference<BookingFile, BaseProduct>, List<IbecorpModelService.ShipmentDocumentsData.DocumentData>> productToDocumentsMap = new HashMap<NestedEntityReference<BookingFile, BaseProduct>, List<IbecorpModelService.ShipmentDocumentsData.DocumentData>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"navigationKey", (Collection)productRefs.stream().map(NestedEntityReference::getNestedEntityUid).collect(Collectors.toList())));
        for (BasicDocumentIndex index : EntityStorage.get().search(BasicDocumentIndex.class, query).getData()) {
            int numberOfCopies;
            EntityContainer doc;
            if (!Document.class.isAssignableFrom(index.getSource().getType()) || (doc = EntityStorageHelper.resolve((EntityReference)index.getSource(), (EntityStorageContext)entityStorageContext)) == null || ((Document)doc.getEntity()).getContent() == null || ((Document)doc.getEntity()).getContent().length == 0 || ((Document)doc.getEntity()).getContentType() == null) continue;
            if (printActionSet != null) {
                FinancePrintData docPrintData = printActionSet.getPrintDatas().stream().filter(printData -> printData.getDocumentType() == PrintDocumentType.RELATED_DOCUMENT).findFirst().orElse(null);
                if (docPrintData != null) {
                    numberOfCopies = docPrintData.getNumberOfCopies();
                } else {
                    numberOfCopies = 1;
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.DocumentPrintSettingNotFound, (Object[])new Object[]{doc.toReference(), shipment.toReference()}));
                }
            } else {
                numberOfCopies = 1;
            }
            IbecorpModelService.ShipmentDocumentsData.DocumentData documentData = new IbecorpModelService.ShipmentDocumentsData.DocumentData(doc, numberOfCopies);
            productRefs.stream().filter(ref -> ref.getNestedEntityUid().equals(index.getNavigationKey())).findFirst().ifPresent(prod -> productToDocumentsMap.computeIfAbsent((NestedEntityReference<BookingFile, BaseProduct>)prod, p -> new ArrayList()).add(documentData));
        }
        return productToDocumentsMap;
    }

    private List<IbecorpModelService.ShipmentDocumentsData.DocumentData> getSortedByTravellerDocuments(Map<NestedEntityReference<BookingFile, BaseProduct>, List<IbecorpModelService.ShipmentDocumentsData.DocumentData>> productToDocumentsMap, EntityStorageContext entityStorageContext) {
        Locale locale = LocaleHelper.getCurrentLocale();
        TreeMap<Optional, List> sortedTravellersToProducts = new TreeMap<Optional, List>(FinanceDocumentsIbusHelper.getTravellerComparator((EntityStorageContext)entityStorageContext, (Locale)locale));
        for (NestedEntityReference<BookingFile, BaseProduct> productRef : productToDocumentsMap.keySet()) {
            Optional result;
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve(productRef, (EntityStorageContext)entityStorageContext);
            if (product == null) continue;
            List travellers = ProductHandler.of((BaseProduct)product).getTravellers(product).stream().map(traveller -> new NestedEntityReference((EntityReference)productRef, (BaseEntity)traveller)).map(Optional::of).collect(Collectors.toList());
            if (travellers.isEmpty()) {
                result = Optional.empty();
            } else if (travellers.size() == 1) {
                result = (Optional)travellers.iterator().next();
            } else {
                TreeSet sortedTravellers = new TreeSet(FinanceDocumentsIbusHelper.getTravellerComparator((EntityStorageContext)entityStorageContext, (Locale)locale));
                sortedTravellers.addAll(travellers);
                result = (Optional)sortedTravellers.first();
            }
            sortedTravellersToProducts.computeIfAbsent(result, t -> new ArrayList()).add(productRef);
        }
        return sortedTravellersToProducts.values().stream().flatMap(Collection::stream).map(productToDocumentsMap::get).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private IbecorpModelService.ReportRegistryData getReportRegistry(EntityContainer<Shipment> shipment, LazyValueHolder<List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>>> contracts, List<Message> messages) {
        XreportsIntegrationHelper.ExportedReport shipmentRegistry;
        ReportReference reportReference = IbecorpRulesHelper.applyShipmentRules(shipment, (List)((List)contracts.get()), messages).getReportReference();
        if (reportReference == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.ShipmentReportReferenceNotFound, (Object[])new Object[]{shipment.toReference()}));
            return new IbecorpModelService.ReportRegistryData(true, null, null);
        }
        try {
            shipmentRegistry = XreportsIntegrationHelper.getShipmentRegistry((String)reportReference.getUid(), (Shipment)((Shipment)shipment.getEntity()));
        }
        catch (Exception e) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.ShipmentGetReportError, (Throwable)e, (Object[])new Object[]{reportReference.getTitle(), shipment.toReference()}));
            return null;
        }
        if (shipmentRegistry == null) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.ShipmentReportWasNotReturned, (Object[])new Object[]{reportReference.getTitle(), shipment.toReference()}));
            return null;
        }
        return new IbecorpModelService.ReportRegistryData(false, shipmentRegistry.getFileName(), shipmentRegistry.getContent());
    }

    private PrintActionSet applyPrintRules(EntityContainer<Shipment> shipmentContainer, LazyValueHolder<List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>>> contracts, List<Message> messages) {
        RuleProxy documentProxy = new RuleProxy();
        PrintPropertySet printPropertySet = new PrintPropertySet(documentProxy);
        PrintActionSet printActionSet = new PrintActionSet();
        documentProxy.setProxyType(Targets.PRINT_PARAMETERS.getId());
        documentProxy.setProxyDate(((Shipment)shipmentContainer.getEntity()).getDate());
        documentProxy.setPropertySet((Object)printPropertySet);
        documentProxy.setActionSet((Object)printActionSet);
        for (MiscUtil.Pair contract : (List)contracts.get()) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)((EntityContainer)contract.getFirst()), (Date)((Shipment)shipmentContainer.getEntity()).getDate());
            for (EntityContainer rule : rules) {
                try {
                    RuleEngine.applyRules(Collections.singletonList(documentProxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                }
                catch (Exception e) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)com.gridnine.xtrip.common.ibecorp.l10n.Messages.ShipmentApplyRulesError, (Throwable)e, (Object[])new Object[]{((EntityContainer)contract.getFirst()).toReference(), shipmentContainer.toReference()}));
                }
            }
        }
        return printActionSet;
    }

    private PrintDocumentType getPrintDocumentType(FinanceDocument financeDocument) {
        if (financeDocument.getType() != null) {
            switch (financeDocument.getType()) {
                case STANDARD_BILL: {
                    return PrintDocumentType.STANDARD_BILL;
                }
                case INVOICE: {
                    return PrintDocumentType.INVOICE;
                }
                case INVOICE_CONSOLIDATED: {
                    return PrintDocumentType.INVOICE_CONSOLIDATED;
                }
                case INVOICE_FACTURA: {
                    return PrintDocumentType.INVOICE_FACTURA;
                }
                case ACCEPTANCE_CERTIFICATE: {
                    return PrintDocumentType.ACCEPTANCE_CERTIFICATE;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported finance document type: " + financeDocument.getType());
    }

    private String getReplaceVariableInText(String replacement, String target) {
        return target.replace("${shipmentNumbers}", replacement);
    }

    private Locale getLocale(MailTemplate template) {
        if (TextUtil.nonBlank((String)template.getSubjectRu())) {
            return LocaleHelper.RU_LOCALE;
        }
        if (TextUtil.nonBlank((String)template.getSubjectEn())) {
            return LocaleHelper.EN_LOCALE;
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getTemplateSubject(MailTemplate template) {
        String localeSubject = null;
        if ("ru".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectRu();
        } else if ("en".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectEn();
        } else if ("bg".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectBg();
        } else if ("uk".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectUk();
        } else if ("hy".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectHy();
        } else if ("az".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectAz();
        } else if ("kk".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeSubject = template.getSubjectKz();
        }
        return localeSubject == null ? "" : localeSubject;
    }

    private String getTemplateData(MailTemplate template) {
        String localeData = null;
        if ("ru".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataRu();
        } else if ("en".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataEn();
        } else if ("bg".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataBg();
        } else if ("uk".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataUk();
        } else if ("hy".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataHy();
        } else if ("az".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataAz();
        } else if ("kk".equalsIgnoreCase(this.getLocale(template).getLanguage())) {
            localeData = template.getDataKz();
        }
        return localeData == null ? "" : localeData;
    }
}

