/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.rpc;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.complementBooking.ComplementBookingHelper;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bus.templates.jr.BusItineraryReceiptRender;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpRpcService;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.BusItineraryReceiptProperties;
import com.gridnine.xtrip.common.hotels2.HotelAggregatorSettings;
import com.gridnine.xtrip.common.hotels2.helper.CommonHotelHelper;
import com.gridnine.xtrip.common.hotels2.model.BaseHotelParameters;
import com.gridnine.xtrip.common.hotels2.model.FindHotelsParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelSummary;
import com.gridnine.xtrip.common.hotels2.model.SearchHotelsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.RemoteDictionaryResolver;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.hotels.MealItem;
import com.gridnine.xtrip.common.model.ibecorp.profile.OrganizationHotel;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IbecorpRpcServiceImpl
extends BaseSecureServiceImpl
implements IbecorpRpcService {
    public List<MealItem> getMealInfo(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"HotelsServiceImpl-mealInfo");
        try {
            this.checkContext(ctx);
            this.log.debug("getMealInfo() BEGIN");
            HashMap data = new HashMap();
            IntegrationBusFacade.get().processRouteSync("hotels2:get-meal-dictionary:get-meal-dictionary-route", data);
            List result = (List)data.get(IBusHotelsContextKeys.HOTELS_MEAL_ITEMS.name());
            this.log.debug("getMealInfo() END");
            List list = result;
            return list;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.log.error("failed loading meal info", t);
            throw new ServiceException("failed loading meal info", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public HotelCard getHotel(ServiceInvocationContext ctx, String number) throws ServiceException {
        DebugUtil.setThreadName((String)"HotelsServiceImpl-getHotel");
        try {
            this.checkContext(ctx);
            this.log.debug("getHotel() BEGIN");
            HashMap<String, BaseHotelParameters> data = new HashMap<String, BaseHotelParameters>();
            BaseHotelParameters params = new BaseHotelParameters();
            params.setHotelNumber(number);
            data.put(IBusHotelsContextKeys.HOTELS_BASE_HOTEL_PARAMS.name(), params);
            IntegrationBusFacade.get().processRouteSync("hotels2:get-hotel:get-hotel-route", data);
            HotelCard result = (HotelCard)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_CARD.name());
            this.log.debug("getHotel() END");
            HotelCard hotelCard = result;
            return hotelCard;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.log.error("failed loading hotel info", t);
            throw new ServiceException("failed loading hotel info", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<Message> synchBooking(ServiceInvocationContext ctx, EntityReference<BookingFile> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpServiceImpl-synchBooking");
        try {
            Map messagesMap;
            HashMap<String, Object> data;
            this.checkContext(ctx);
            this.log.debug("synchBooking() BEGIN");
            EntityContainer bookingFileContainer = EntityStorage.get().resolve(ref);
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            boolean syncHotel = !CommonHotelHelper.getHotelReservationsForSync((BookingFile)bookingFile).isEmpty();
            boolean syncRailway = RzdCommonHelper.needActualBookingFile((BookingFile)bookingFile, (boolean)true);
            ArrayList<Message> messages = new ArrayList<Message>();
            if (syncHotel) {
                data = new HashMap<String, Object>();
                data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFileContainer);
                IntegrationBusFacade.get().processRouteSync("hotels2:sync-booking:sync-booking-route", data);
                messagesMap = (Map)data.get("messages");
                messages.addAll(messagesMap.values());
            }
            if (syncRailway) {
                data = new HashMap();
                data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFileContainer);
                data.put(IBusRailwayContextKeys.RAILWAY_RESERVATION_CHECK_ALL_STATUSES.name(), true);
                IntegrationBusFacade.get().processRouteSync("railway:check-reservation:check-booking-route", data);
                messagesMap = (Map)data.get("messages");
                messages.addAll(messagesMap.values());
            }
            this.log.debug("synchBooking() END");
            ArrayList<Message> arrayList = messages;
            return arrayList;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.log.error("failed sync hotel booking", t);
            throw new ServiceException("failed sync hotel booking", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<Message> complementBooking(ServiceInvocationContext ctx, EntityReference<BookingFile> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"IbecorpServiceImpl-complementBooking");
        try {
            this.checkContext(ctx);
            this.log.debug("complementBooking() BEGIN");
            if (ref == null) {
                List<Message> list = Collections.singletonList(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"BOOKING_REF_IS_NULL", (Object[])new Object[0]));
                return list;
            }
            EntityContainer bookingCtr = EntityStorage.get().resolve(ref);
            if (bookingCtr == null) {
                List<Message> list = Collections.singletonList(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"BOOKING_IS_NOT_FOUND", (Object[])new Object[0]));
                return list;
            }
            Map activeHandlersDataMap = ComplementBookingHelper.getActiveHandlersDataMap((BookingFile)((BookingFile)bookingCtr.getEntity()));
            if (!ComplementBookingHelper.hasActiveComplementBookingHandlers((Map)activeHandlersDataMap)) {
                List<Message> list = Collections.singletonList(ComplementBookingHelper.NO_ACTIVE_HANDLERS_MESSAGE);
                return list;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(IBusMidofficeContextKeys.BOOKING_FILE_REFERENCE.name(), ref);
            data.put(IBusMidofficeContextKeys.COMPLEMENT_BOOKING_SKIP_COMPLETED_CHECK.name(), true);
            IntegrationBusFacade.get().processRouteSync("midoffice:complement-booking:complement-booking", data);
            Map messagesMap = (Map)data.get("messages");
            this.log.debug("complementBooking() END");
            ArrayList<Message> arrayList = new ArrayList<Message>(messagesMap.values());
            return arrayList;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.log.error("failed complement booking", t);
            throw new ServiceException("failed complement booking", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<String> getHotelRoomNames(ServiceInvocationContext ctx, EntityReference<Organization> orgRef) throws ServiceException {
        DebugUtil.setThreadName((String)"HotelsServiceImpl-getHotelRoomNames");
        try {
            this.checkContext(ctx);
            this.log.debug("getRoomNames() BEGIN");
            EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
            if (null == orgCtr) {
                List<String> list = null;
                return list;
            }
            Organization organization = (Organization)orgCtr.getEntity();
            OrganizationHotel hotel = organization.getHotel();
            if (null == hotel) {
                List<String> list = null;
                return list;
            }
            List<String> list = hotel.getRooms().stream().map(r -> r.getName().toString(ctx.getLocale())).collect(Collectors.toList());
            return list;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.log.error("failed loading hotel room names", t);
            throw new ServiceException("failed loading room names", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<HotelSummary> searchHotels(ServiceInvocationContext ctx, String pattern) throws ServiceException {
        DebugUtil.setThreadName((String)"HotelsServiceImpl-searchHotels");
        try {
            this.checkContext(ctx);
            this.log.debug("searchHotels() BEGIN");
            HashMap<String, FindHotelsParameters> data = new HashMap<String, FindHotelsParameters>();
            FindHotelsParameters params = new FindHotelsParameters();
            params.setPattern(pattern);
            params.setSystemOnly(false);
            params.setIncludeOffline(Boolean.valueOf(false));
            params.setIncludeOnline(Boolean.valueOf(true));
            data.put(IBusHotelsContextKeys.HOTELS_FIND_HOTELS_PARAMS.name(), params);
            IntegrationBusFacade.get().processRouteSync("hotels2:find-hotels:find-hotels-route", data);
            List result = (List)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_SUMMARY_LIST.name());
            this.log.debug("searchHotels() END");
            List list = result;
            return list;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.log.error("failed loading hotels", t);
            throw new ServiceException("failed loading hotels", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<Hotel> searchHotels2(ServiceInvocationContext ctx, HotelProvider provider, String id, DictionaryReference<Country> country, DictionaryReference<GeoLocation> location, DictionaryReference<HotelsBrand> chain, String name) throws ServiceException {
        DebugUtil.setThreadName((String)"HotelsServiceImpl-searchHotels2");
        try {
            this.checkContext(ctx);
            int limit = 50;
            EntityContainer settingsCtr = HotelsHelper.getHotelAggregatorSettings();
            if (settingsCtr != null && ((HotelAggregatorSettings)settingsCtr.getEntity()).isEnabled()) {
                if (!TextUtil.isBlank((String)id)) {
                    Hotel hotel = this.searchHotelByProviderCode(id, provider);
                    List<Hotel> list = hotel == null ? Collections.emptyList() : Collections.singletonList(hotel);
                    return list;
                }
                List<Hotel> list = this.searchHotels(provider, country, location, name, limit, null);
                return list;
            }
            List list = ((RemoteDictionaryResolver)Environment.getPublished(RemoteDictionaryResolver.class)).getHotel(TextUtil.isBlank((String)id) ? "" : id, country == null ? "" : country.getCode(), location == null ? "" : location.getCode(), chain == null ? "" : chain.getCode(), TextUtil.isBlank((String)name) ? "" : name, limit);
            return list;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed searching hotels", t);
            throw new ServiceException("failed searching hotels", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private Hotel searchHotelByProviderCode(String providerCode, HotelProvider provider) {
        if (TextUtil.isBlank((String)providerCode)) {
            return null;
        }
        HashMap<String, BaseHotelParameters> data = new HashMap<String, BaseHotelParameters>();
        BaseHotelParameters params = new BaseHotelParameters();
        params.setHotelNumber(providerCode);
        params.setProvider(provider);
        data.put(IBusHotelsContextKeys.HOTELS_BASE_HOTEL_PARAMS.name(), params);
        try {
            IntegrationBusFacade.get().processRouteSync("hotels2:get-hotel:get-hotel-route", data);
            HotelCard hotelCard = (HotelCard)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_CARD.name());
            return HotelsHelper.convertToHotel((HotelCard)hotelCard);
        }
        catch (Throwable t) {
            throw Xeption.forDeveloper((String)"error of search hotel with code {0} of provider {1}", (Throwable)t, (Object[])new Object[]{providerCode, provider});
        }
    }

    private List<Hotel> searchHotels(HotelProvider provider, DictionaryReference<Country> countryReference, DictionaryReference<GeoLocation> locationReference, String namePattern, Integer limit, Integer offset) {
        namePattern = TextUtil.nonBlank((String)namePattern) ? namePattern.trim() : null;
        countryReference = null == locationReference && IbecorpRpcServiceImpl.haveHotelAggregatorCode(countryReference) ? countryReference : null;
        locationReference = IbecorpRpcServiceImpl.haveHotelAggregatorCode(locationReference) ? locationReference : null;
        try {
            SearchHotelsParameters params = new SearchHotelsParameters();
            params.setProvider(provider);
            params.setCountry(countryReference);
            params.setLocation(locationReference);
            params.setNamePattern(namePattern);
            params.setLimit(limit);
            params.setOffset(offset);
            HashMap<String, SearchHotelsParameters> data = new HashMap<String, SearchHotelsParameters>();
            data.put(IBusHotelsContextKeys.HOTELS_SEARCH_HOTELS_PARAMS.name(), params);
            IntegrationBusFacade.get().processRouteSync("hotels2:search-hotels:search-hotels-route", data);
            List hotels = (List)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_SUMMARY_LIST.name());
            return hotels.stream().filter(Objects::nonNull).map(HotelsHelper::convertToHotel).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Throwable t) {
            String message = String.format("error of search hotel with provider %s, country %s, location %s, name pattern %s, limit %s and offset %s", provider, countryReference, locationReference, namePattern, limit, offset);
            throw Xeption.forDeveloper((String)message, (Throwable)t, (Object[])new Object[0]);
        }
    }

    private static boolean haveHotelAggregatorCode(DictionaryReference<? extends BaseDictionary> ref) {
        if (ref == null) {
            return false;
        }
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        return dict != null && dict.getCodeVariants().containsKey(CodeSystem.HOTEL_AGGREGATOR.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ItineraryReceiptRPCResult createBusItineraryReceipts(ServiceInvocationContext ctx, BusItineraryReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createBusItineraryReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Map<String, Collection> productUids2TemplateCtrs = properties.getProductsWithTemplates().entrySet().stream().map(entry -> {
                List templateCtrs = ((Collection)entry.getValue()).stream().map(templateRef -> {
                    EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                    if (templateCtr == null) {
                        messages.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                    }
                    return templateCtr;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry(entry.getKey(), templateCtrs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                messages.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry2 : properties.getProductsWithBookings().entrySet()) {
                String productUid = (String)entry2.getKey();
                Collection templateCtrs = productUids2TemplateCtrs.get(productUid);
                EntityReference bfRef = (EntityReference)entry2.getValue();
                EntityContainer bfCont = ref2ctr.computeIfAbsent(bfRef, k -> EntityStorage.get().resolve(bfRef));
                BusProduct product = (BusProduct)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bfCont.getEntity()));
                if (product == null) continue;
                if (CollectionUtil.isEmpty((Collection)product.getTravellers())) {
                    messages.add(Messages.getErrorFormingItineraryNoTraveller((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    continue;
                }
                for (EntityContainer templateCtr : templateCtrs) {
                    try {
                        result.add(new BusItineraryReceiptRender().renderReport(bfCont, product, templateCtr));
                        messages.add(Messages.getNotificationItineraryGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render itinerary for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        messages.add(Messages.getExceptionFormingItinerary((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ItineraryReceiptRPCResult(messages, result);
    }
}

