/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.rpc;

import com.gridnine.xtrip.common.fx.ibecorp.rpc.IssueService;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueStatus;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.RequestForHotelBookingIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.SimpleIssue;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.correspondence.storage.MailDocumentBuilder;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class IssueServiceImpl
extends BaseSecureServiceImpl
implements IssueService {
    public void addNewPost(ServiceInvocationContext ctx, EntityReference<BaseIssue> baseIssueEntityReference, Post newPost, boolean setAssignee) throws ServiceException {
        DebugUtil.setThreadName((String)"IssueServiceImpl-addNewPost");
        try {
            this.checkContext(ctx);
            LockUtil.lock(baseIssueEntityReference, issueCtr -> {
                EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)ctx.getUser());
                BaseIssue issue = (BaseIssue)issueCtr.getEntity();
                if (person != null) {
                    newPost.setAuthor(person.toReference());
                    if (setAssignee) {
                        issue.setAssignee(person.toReference());
                    }
                }
                newPost.setDateCreated(new Date());
                if (!issue.getPosts().isEmpty()) {
                    newPost.setHotelEmail(((Post)CollectionUtil.getLastElement((List)issue.getPosts())).getHotelEmail());
                }
                issue.getPosts().add(newPost);
                issue.getEvents().add(NotificationEvent.COMMENT_ADDED);
                issue.setUnreadPosts(0);
                issueCtr.getVersionInfo().setDataSource("fx-add-post");
                EntityStorage.get().save(issueCtr, true);
            });
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed adding new post", t);
            throw new ServiceException("failed adding new post", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public void addNewAttachment(ServiceInvocationContext ctx, EntityReference<BaseIssue> baseIssueEntityReference, Document doc) throws ServiceException {
        DebugUtil.setThreadName((String)"IssueServiceImpl-addNewAttachment");
        try {
            Post post = new Post();
            this.checkContext(ctx);
            doc.setNavigationKey(baseIssueEntityReference.getUid());
            doc.setType(DocumentType.ISSUE_ATTACHMENT);
            doc.setOwner(baseIssueEntityReference);
            doc.setNavigationKey(post.getUid());
            EntityContainer docCtr = EntityContainer.create((BaseEntity)doc);
            docCtr.getVersionInfo().setDataSource("fx-add-attachment");
            EntityStorage.get().save(docCtr, true);
            post.setDateCreated(new Date());
            post.setContent(doc.getName());
            post.getAttachments().add(docCtr.toReference());
            LockUtil.lock(baseIssueEntityReference, issueCtr -> {
                EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)ctx.getUser());
                if (person != null) {
                    post.setAuthor(person.toReference());
                }
                ((BaseIssue)issueCtr.getEntity()).getPosts().add(post);
                ((BaseIssue)issueCtr.getEntity()).getEvents().add(NotificationEvent.ATTACHMENT_ADDED);
                issueCtr.getVersionInfo().setDataSource("fx-add-attachment");
                EntityStorage.get().save(issueCtr, true);
            });
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed adding new attachment", t);
            throw new ServiceException("failed adding new attachment", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityReference<SimpleIssue> createIssue(ServiceInvocationContext ctx, EntityReference<BookingFile> bookingFileEntityReference) throws ServiceException {
        DebugUtil.setThreadName((String)"IssueServiceImpl-createIssue");
        try {
            this.checkContext(ctx);
            String user = ctx.getUser();
            BookingFile bookingFile = (BookingFile)EntityStorage.get().load(BookingFile.class, bookingFileEntityReference.getUid()).getEntity();
            String fullNumber = TextUtil.buildFullNumber((CompositeNumber)bookingFile);
            EntityStorage entityCache = EntityStorage.get();
            EntityContainer agentCtr = entityCache.find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)user);
            SimpleIssue issue = new SimpleIssue();
            issue.setCreateDate(new Date());
            issue.setUpdateDate(new Date());
            issue.setStatus(IssueStatus.CLOSED);
            issue.setTitle(String.format("\u0412\u043e\u043f\u0440\u043e\u0441 \u043f\u043e \u0437\u0430\u043a\u0430\u0437\u0443 \u2116%s", fullNumber));
            issue.setBooking(bookingFileEntityReference);
            issue.setAgency(bookingFile.getAgency());
            issue.setSubagency(BookingHelper.getSubagency((BookingFile)bookingFile));
            issue.setClient(bookingFile.getCustomerProfile());
            if (agentCtr != null) {
                issue.setAssignee(agentCtr.toReference());
                issue.setAuthor(agentCtr.toReference());
            }
            EntityContainer simpleIssueCtr = EntityContainer.create((BaseEntity)issue);
            simpleIssueCtr.getVersionInfo().setDataSource("fx-create-issue");
            EntityContainer issueEntityContainer = EntityStorage.get().save(simpleIssueCtr, true);
            EntityReference entityReference = new EntityReference(issueEntityContainer);
            return entityReference;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException(t.getMessage(), t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendHotelNotification(ServiceInvocationContext ctx, EntityReference<RequestForHotelBookingIssue> issueRef) throws ServiceException {
        DebugUtil.setThreadName((String)"IssueServiceImpl-resendHotelNotification");
        try {
            this.checkContext(ctx);
            try {
                EntityContainer issueCtr = EntityStorage.get().resolve(issueRef);
                RequestForHotelBookingIssue issue = (RequestForHotelBookingIssue)issueCtr.getEntity();
                MailAddress mailFrom = new MailAddress();
                MailServerSettings mailServerSettings = MailConfigUtil.readMailServerParameters();
                MailServerParameters mailServerParameters = mailServerSettings.getHotelMailServerParameters();
                mailFrom.setAddress(mailServerSettings.getFromAddress());
                mailFrom.setName(mailServerSettings.getFromName());
                EntityContainer bookingFile = EntityStorage.get().resolve(issue.getBooking());
                EntityContainer baseIssueCtr = issueCtr;
                MailDocument mailDocument = new MailDocumentBuilder(null, baseIssueCtr, NotificationEvent.COMMENT_ADDED, () -> mailFrom, Collections.singletonList(this.newMailAddress(((Post)issue.getPosts().get(issue.getPosts().size() - 1)).getHotelEmail().getSense())), bookingFile).create();
                NotificationHelper.sendMail((MailServerParameters)mailServerParameters, (MailDocument)mailDocument, (boolean)true);
            }
            catch (Throwable t) {
                this.log.error("failed resend notification " + issueRef, t);
                throw new ServiceException("failed resend notification " + issueRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private MailAddress newMailAddress(String address) {
        MailAddress mailAddress = new MailAddress();
        mailAddress.setAddress(address);
        mailAddress.setHotelAddress(true);
        return mailAddress;
    }
}

