/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.supplements.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.finance.ShipmentUIFinanceDocumentData;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import java.util.ArrayList;

public class IbeShipmentSupplementHandler
implements SupplementHandler<Shipment, ShipmentUIData> {
    public Class<Shipment> getEntityClass() {
        return Shipment.class;
    }

    public Class<ShipmentUIData> getSupplementClass() {
        return ShipmentUIData.class;
    }

    public void populateSupplement(EntityContainer<Shipment> ctr, ShipmentUIData supplement) {
        if (!SbisIntegrationHelper.hasEnabledSbisIntegrationSettings()) {
            return;
        }
        ArrayList financeDocuments = new ArrayList();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)ctr.toReference()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.SHIPMENT_TICKETS_REGISTRY));
        EntityStorage.get().search(BasicDocumentIndex.class, query).getData().forEach(it -> {
            ShipmentUIFinanceDocumentData financeData = new ShipmentUIFinanceDocumentData();
            financeData.setDate(it.getCreated());
            financeData.setNumber(((Shipment)ctr.getEntity()).getNumber());
            financeData.setType(FinanceDocumentType.TICKETS_REGISTRY);
            financeData.setFinanceDocumentReference(it.getSource());
            financeDocuments.add(financeData);
        });
        supplement.getFinanceDocuments().addAll(financeDocuments);
    }

    public void populateEntity(ShipmentUIData supplement, EntityContainer<Shipment> ctr) {
    }

    public double getPriority() {
        return 31.0;
    }
}

