/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.supplements.handlers;

import com.gridnine.xtrip.common.fx.ibecorp.model.correspondence.AttachmentInfo;
import com.gridnine.xtrip.common.fx.ibecorp.model.correspondence.IssueUIData;
import com.gridnine.xtrip.common.fx.ibecorp.model.correspondence.ProductInfo;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.PhoneHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class IssueSupplementHandler
implements SupplementHandler<BaseIssue, IssueUIData> {
    IssueSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public Class<BaseIssue> getEntityClass() {
        return BaseIssue.class;
    }

    public Class<IssueUIData> getSupplementClass() {
        return IssueUIData.class;
    }

    public void populateSupplement(EntityContainer<BaseIssue> ctr, IssueUIData supplement) {
        supplement.setPhone(this.getPhone((BaseIssue)ctr.getEntity()));
        supplement.getProductsInfo().addAll(this.getProducts((BaseIssue)ctr.getEntity()));
        supplement.getAttachments().addAll(this.getAttachmentsRefs(ctr));
    }

    public void populateEntity(IssueUIData supplement, EntityContainer<BaseIssue> ctr) {
    }

    protected String getPhone(BaseIssue model) {
        Communication comm;
        EntityContainer clientCtr;
        BookingFile booking;
        EntityContainer bCtr;
        if (model.getBooking() != null && (bCtr = EntityStorage.get().resolve(model.getBooking())) != null && bCtr.getEntity() instanceof BookingFile && (booking = (BookingFile)bCtr.getEntity()).getReservations().size() > 0) {
            Communication comm2;
            EntityReference bookingAgentRef = ((Reservation)booking.getReservations().get(0)).getBookingAgent();
            EntityContainer bookingAgentCtr = EntityStorage.get().resolve(bookingAgentRef);
            if (bookingAgentCtr != null && (comm2 = ProfileHelper.getPreferredCommunication((Collection)ProfileHelper.getPhoneCommunications((List)((Person)bookingAgentCtr.getEntity()).getCommunications()), (CommunicationType[])new CommunicationType[]{CommunicationType.WORK_PHONE, CommunicationType.HOME_PHONE, CommunicationType.MOBILE})) != null) {
                return PhoneHelper.getPhoneNumber((String)comm2.getCountryCode(), (String)comm2.getCityCode(), (String)comm2.getSense());
            }
        }
        EntityReference phoneNumberProvider = null;
        phoneNumberProvider = ProfileHelper.isRetailProfile((EntityReference)model.getClient()) ? model.getSubagency() : model.getClient();
        if (phoneNumberProvider != null && (clientCtr = EntityStorage.get().resolve(phoneNumberProvider)) != null && (comm = ProfileHelper.getPreferredCommunication((Collection)ProfileHelper.getPhoneCommunications((List)((Organization)clientCtr.getEntity()).getCommunications()), (CommunicationType[])new CommunicationType[]{CommunicationType.WORK_PHONE, CommunicationType.HOME_PHONE, CommunicationType.MOBILE})) != null) {
            return PhoneHelper.getPhoneNumber((String)comm.getCountryCode(), (String)comm.getCityCode(), (String)comm.getSense());
        }
        return null;
    }

    protected List<ProductInfo> getProducts(BaseIssue model) {
        EntityContainer bCtr;
        ArrayList<ProductInfo> result = new ArrayList<ProductInfo>();
        if (model.getBooking() != null && (bCtr = EntityStorage.get().resolve(model.getBooking())) != null && bCtr.getEntity() instanceof BookingFile) {
            BookingFile booking = (BookingFile)bCtr.getEntity();
            for (Reservation res : booking.getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)bp);
                    ProductInfo productNameUID = new ProductInfo();
                    productNameUID.setProductName(BookingHelper.generateShortProductName((BaseProduct)bp));
                    productNameUID.setProductUID(bp.getUid());
                    productNameUID.setRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)bp.getReservation()));
                    productNameUID.setTravellerName(this.getTravellersNames(bp));
                    result.add(productNameUID);
                    if (handler.getStatus(bp) == ProductStatus.SELL && handler.getNextProduct(bp) == null) {
                        productNameUID.setAvailable(true);
                        continue;
                    }
                    productNameUID.setAvailable(false);
                }
            }
        }
        return result;
    }

    protected List<AttachmentInfo> getAttachmentsRefs(EntityContainer<BaseIssue> ctr) {
        ArrayList<AttachmentInfo> result = new ArrayList<AttachmentInfo>();
        EntityStorage es = EntityStorage.get();
        SearchQuery q = new SearchQuery();
        q.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)new EntityReference(ctr.getUid(), ((BaseIssue)ctr.getEntity()).getClass(), ((BaseIssue)ctr.getEntity()).toString())));
        List data = es.search(BasicDocumentIndex.class, q).getData();
        for (BasicDocumentIndex index : data) {
            AttachmentInfo aInfo = new AttachmentInfo();
            aInfo.setDocRef(index.getSource());
            aInfo.setCreated(index.getCreated());
            aInfo.setName(index.getName());
            result.add(aInfo);
        }
        return result;
    }

    private String getTravellersNames(BaseProduct bp) {
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)bp);
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (Traveller t : handler.getTravellers(bp)) {
            if (count > 0) {
                sb.append(',');
            }
            sb.append(TextUtil.buildFullName((PersonalName)t.getPassport()));
            ++count;
        }
        return sb.toString();
    }
}

