/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.ibecorp.supplements.handlers;

import com.gridnine.xtrip.common.fx.ibecorp.model.sap.SapIntegrationUIData;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import java.time.LocalDateTime;

public class SapIntegrationSupplementHandler
implements SupplementHandler<SapIntegrationSettings, SapIntegrationUIData> {
    static final String DB_PROPS_SAP_LAST_DATE_UPDATED = "sap.last_date_update";

    public Class<SapIntegrationSettings> getEntityClass() {
        return SapIntegrationSettings.class;
    }

    public Class<SapIntegrationUIData> getSupplementClass() {
        return SapIntegrationUIData.class;
    }

    public void populateSupplement(EntityContainer<SapIntegrationSettings> ctr, SapIntegrationUIData supplement) {
        supplement.setDateLastSync(this.getSapSyncDate());
    }

    public void populateEntity(SapIntegrationUIData supplement, EntityContainer<SapIntegrationSettings> ctr) {
        LocalDateTime dateLastSync = supplement.getDateLastSync();
        LogicalStorage.get().getDbPropertiesStorage().putValue(DB_PROPS_SAP_LAST_DATE_UPDATED, MiscUtil.toString((Object)dateLastSync));
    }

    public double getPriority() {
        return 0.0;
    }

    protected LocalDateTime getSapSyncDate() {
        String dateFromString = LogicalStorage.get().getDbPropertiesStorage().getValue(DB_PROPS_SAP_LAST_DATE_UPDATED);
        LocalDateTime dateSync = LocalDateTime.now();
        if (TextUtil.nonBlank((String)dateFromString)) {
            dateSync = LocalDateTime.parse(dateFromString);
        }
        return dateSync;
    }
}

