/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.railway.model.helpers.clone.RailwayCrimeaMcoCloneHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RailwayCrimeaProductFXHandler
extends BaseProductFXHandler<RailwayCrimeaMco> {
    public Class<RailwayCrimeaMco> getProductClass() {
        return RailwayCrimeaMco.class;
    }

    public List<Message> recalculateFOP(RailwayCrimeaMco railwayProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)railwayProduct, (ProductStatus[])appropriateStatusArray, product -> RailwayCrimeaMcoHelper.updateFops((RailwayCrimeaMco)((RailwayCrimeaMco)product)), (ProductStatus)railwayProduct.getStatus(), ctr);
    }

    public EntityReference<Organization> getSubAgency(RailwayCrimeaMco baseProduct) {
        return RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)baseProduct);
    }

    private RailwayCrimeaMco copyProduct(RailwayCrimeaMco srcProduct, Reservation reservation, String ticketNum, List<Message> result) {
        RailwayCrimeaMco destProduct = new RailwayCrimeaMco();
        try {
            RailwayCrimeaMcoHelper.copy((RailwayCrimeaMco)srcProduct, (RailwayCrimeaMco)destProduct);
            destProduct.setPenalty(null);
        }
        catch (Exception e) {
            result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", (Throwable)e, (Object[])new Object[0]));
        }
        if (result.isEmpty()) {
            if (!TextUtil.isBlank((String)ticketNum)) {
                destProduct.setSystemNumber(ticketNum);
            }
            destProduct.setIssueDate(new Date());
            if (!TextUtil.isBlank((String)srcProduct.getScn())) {
                destProduct.setScn(FormattedNumberUtil.add((String)srcProduct.getScn(), (long)1L));
            }
            destProduct.setReservation(reservation);
            reservation.getProducts().add(destProduct);
        }
        return destProduct;
    }

    public List<Message> cloneProductToSameReservation(RailwayCrimeaMco source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation((BaseProduct)source, bookingFileContainer, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewReservation(RailwayCrimeaMco source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation((BaseProduct)source, bookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewBookingFile(RailwayCrimeaMco source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile((BaseProduct)source, sourceBookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, targetBookingFileContainer, (int)amount, (boolean)forwardAgencyMemo, targetClient, (boolean)changeRetailPayer, this.createCloneHandler());
    }

    public List<Message> cloneProductForCorrection(RailwayCrimeaMco source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return RailwayCrimeaProductFXHandler.cloneProductForCorrection((BaseProduct)source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    public void setSubAgency(RailwayCrimeaMco product, EntityReference<Organization> subagency) {
        RailwayCrimeaMcoHelper.setSubagency((RailwayCrimeaMco)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<RailwayCrimeaMco> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<RailwayCrimeaMco>(){
            final Date date = new Date();

            public RailwayCrimeaMco createProduct() {
                return new RailwayCrimeaMco();
            }

            public void cloneProduct(RailwayCrimeaMco source, RailwayCrimeaMco target) throws Exception {
                RailwayCrimeaMcoCloneHelper.clone((RailwayCrimeaMco)source, (RailwayCrimeaMco)target);
            }

            public void cloneProduct(RailwayCrimeaMco source, RailwayCrimeaMco target, Map<String, String> uidsMapping) throws Exception {
                RailwayCrimeaMcoCloneHelper.clone((RailwayCrimeaMco)source, (RailwayCrimeaMco)target, uidsMapping);
            }

            public void updateProduct(RailwayCrimeaMco target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            public void updateProductsForCorrection(RailwayCrimeaMco source, RailwayCrimeaMco target, Map<String, String> uidsMapping) {
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            public void resetTraveller(RailwayCrimeaMco target) {
                target.getPassengers().clear();
            }
        };
    }
}

