/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway;

import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.fx.railway.helper.RailwayMCOProductRefundHelper;
import com.gridnine.xtrip.server.railway.model.helpers.clone.RailwayMcoCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RailwayMcoProductFXHandler
extends BaseProductFXHandler<RailwayMcoProduct> {
    public Class<RailwayMcoProduct> getProductClass() {
        return RailwayMcoProduct.class;
    }

    public List<Message> recalculateFOP(RailwayMcoProduct railwayProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)railwayProduct, (ProductStatus[])appropriateStatusArray, product -> GeneralProductHelper.updateFops((BaseProduct)((RailwayMcoProduct)product)), (ProductStatus)railwayProduct.getStatus(), ctr);
    }

    public EntityReference<Organization> getSubAgency(RailwayMcoProduct baseProduct) {
        return RailwayMcoProductHelper.getSubagency((RailwayMcoProduct)baseProduct);
    }

    private RailwayMcoProduct copyProduct(RailwayMcoProduct srcProduct, Reservation reservation, String ticketNum, List<Message> result) {
        RailwayMcoProduct destProduct = new RailwayMcoProduct();
        try {
            RailwayMcoProductHelper.copy((RailwayMcoProduct)srcProduct, (RailwayMcoProduct)destProduct);
        }
        catch (Exception e) {
            result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", (Throwable)e, (Object[])new Object[0]));
        }
        if (result.isEmpty()) {
            if (!TextUtil.isBlank((String)ticketNum)) {
                destProduct.setSystemNumber(ticketNum);
            }
            destProduct.setIssueDate(new Date());
            destProduct.setReservation(reservation);
            reservation.getProducts().add(destProduct);
        }
        return destProduct;
    }

    public List<Message> cloneProductToSameReservation(RailwayMcoProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation((BaseProduct)source, bookingFileContainer, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewReservation(RailwayMcoProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation((BaseProduct)source, bookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewBookingFile(RailwayMcoProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile((BaseProduct)source, sourceBookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, targetBookingFileContainer, (int)amount, (boolean)forwardAgencyMemo, targetClient, (boolean)changeRetailPayer, this.createCloneHandler());
    }

    public List<Message> cloneProductForCorrection(RailwayMcoProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return RailwayMcoProductFXHandler.cloneProductForCorrection((BaseProduct)source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    public void setSubAgency(RailwayMcoProduct product, EntityReference<Organization> subagency) {
        RailwayMcoProductHelper.setSubagency((RailwayMcoProduct)product, subagency);
    }

    public BookingFileService.ProductRPCResult refundProduct(RailwayMcoProduct product, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties refundProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String productName = BookingHelper.generateShortProductName((BaseProduct)product);
        String newProductUid = null;
        try {
            RailwayMcoProduct refundProduct = RailwayMCOProductRefundHelper.createRefundProduct(product, refundProperties);
            newProductUid = refundProduct.getUid();
            RailwayMCOProductRefundHelper.addSummaryMessages(refundProduct, (EntityReference<BookingFile>)ctr.toReference(), messages);
        }
        catch (Exception e) {
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0435 \u0431\u0438\u043b\u0435\u0442\u0430 %s", productName), (Throwable)e, (Object[])new Object[0]));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    private ProductFXHandler.ProductCloneFXHandler<RailwayMcoProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<RailwayMcoProduct>(){
            final Date date = new Date();

            public RailwayMcoProduct createProduct() {
                return new RailwayMcoProduct();
            }

            public void cloneProduct(RailwayMcoProduct source, RailwayMcoProduct target) throws Exception {
                RailwayMcoCloneHelper.clone((RailwayMcoProduct)source, (RailwayMcoProduct)target);
            }

            public void cloneProduct(RailwayMcoProduct source, RailwayMcoProduct target, Map<String, String> uidsMapping) throws Exception {
                RailwayMcoCloneHelper.clone((RailwayMcoProduct)source, (RailwayMcoProduct)target, uidsMapping);
            }

            public void updateProduct(RailwayMcoProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            public void updateProductsForCorrection(RailwayMcoProduct source, RailwayMcoProduct target, Map<String, String> uidsMapping) {
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            public void resetTraveller(RailwayMcoProduct target) {
                target.getPassengers().clear();
            }
        };
    }
}

