/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway;

import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FOPHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.fx.railway.helper.RailwayProductRefundHelper;
import com.gridnine.xtrip.server.railway.model.helpers.clone.RailwayProductCloneHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayProductFXHandler
extends BaseProductFXHandler<RailwayProduct> {
    static final Logger log = LoggerFactory.getLogger(RailwayProductFXHandler.class);

    public void setSubAgency(RailwayProduct product, EntityReference<Organization> subagency) {
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, subagency);
    }

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public EntityReference<Organization> getSubAgency(RailwayProduct baseProduct) {
        return RailwayProductHelper.getSubagency((RailwayProduct)baseProduct);
    }

    public Collection<? extends Message> sellProduct(RailwayProduct product, String number) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getNextProduct() == null && product.getStatus().equals((Object)ProductStatus.BOOKING)) {
            product.setStatus(ProductStatus.SELL);
        } else {
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430", (Object[])new Object[0]));
        }
        return errorList;
    }

    public Collection<? extends Message> unsellProduct(RailwayProduct product) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() == null && product.getNextProduct() == null) {
            product.setStatus(ProductStatus.BOOKING);
        } else {
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430", (Object[])new Object[0]));
        }
        return errorList;
    }

    public List<Message> cloneProductToSameReservation(RailwayProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation((BaseProduct)source, bookingFileContainer, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewReservation(RailwayProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation((BaseProduct)source, bookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewBookingFile(RailwayProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile((BaseProduct)source, sourceBookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, targetBookingFileContainer, (int)amount, (boolean)forwardAgencyMemo, targetClient, (boolean)changeRetailPayer, this.createCloneHandler());
    }

    public List<Message> cloneProductForCorrection(RailwayProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return RailwayProductFXHandler.cloneProductForCorrection((BaseProduct)source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    public List<Message> voidProduct(RailwayProduct product) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getStatus() != ProductStatus.BOOKING && product.getStatus() != ProductStatus.SELL) {
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\u0410\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u044f \u0431\u0438\u043b\u0435\u0442\u0430 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430", product.getScn()), (Object[])new Object[0]));
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\"\u0411\u0438\u043b\u0435\u0442 \u0438\u043c\u0435\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0442\u043b\u0438\u0447\u043d\u044b\u0439 \u043e\u0442 \"%s\" \u0438 \"%s\"\"", ProductStatus.BOOKING, ProductStatus.SELL), (Object[])new Object[0]));
            return errorList;
        }
        if (product.getNextProduct() != null) {
            if (product.getNextProduct().getStatus() == ProductStatus.REFUND) {
                errorList.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0411\u0438\u043b\u0435\u0442 \u0443\u0436\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d", (Object[])new Object[0]));
            } else {
                errorList.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\"\u0411\u0438\u043b\u0435\u0442 \u0438\u043c\u0435\u0435\u0442 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442\"", (Object[])new Object[0]));
            }
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\u0410\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u044f \u0431\u0438\u043b\u0435\u0442\u0430 %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430", product.getScn()), (Object[])new Object[0]));
            return errorList;
        }
        product.setStatus(product.getStatus() == ProductStatus.BOOKING ? ProductStatus.VOID_BOOKING : ProductStatus.VOID);
        return errorList;
    }

    public List<Message> recalculateFOP(RailwayProduct railwayProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)railwayProduct, (ProductStatus[])appropriateStatusArray, product -> RailwayProductHelper.updateFops((RailwayProduct)((RailwayProduct)product)), (ProductStatus)railwayProduct.getStatus(), ctr);
    }

    public BookingFileService.ProductRPCResult refundProduct(RailwayProduct product, EntityContainer<BookingFile> bookingFileContainer, ProductExchangeRefundProperties refundProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String productName = BookingHelper.generateShortProductName((BaseProduct)product);
        String newProductUid = null;
        try {
            EntityContainer agentContainer = refundProperties.getAgent() == null ? null : EntityStorage.get().resolve(refundProperties.getAgent());
            String agentCode = agentContainer == null ? null : ((Person)agentContainer.getEntity()).getCode();
            RailwayProduct refundProduct = RailwayProductRefundHelper.createRefundProduct(product, refundProperties, agentCode);
            newProductUid = refundProduct.getUid();
            RailwayProductRefundHelper.addSummaryMessages(refundProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            if (!TextUtil.isBlank((String)refundProperties.getEmdReferenceNumber())) {
                RailwayReferenceMCO mco = RailwayProductRefundHelper.createRailwayReferenceMCO(refundProduct, refundProperties.getEmdReferenceNumber(), refundProperties.getOperationDate());
                RailwayProductRefundHelper.addSummaryMessages(mco, refundProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            }
        }
        catch (Exception e) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0435 \u0431\u0438\u043b\u0435\u0442\u0430 %s", productName), (Throwable)e, (Object[])new Object[0]));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    private ProductFXHandler.ProductCloneFXHandler<RailwayProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<RailwayProduct>(){
            final Date date = new Date();

            public RailwayProduct createProduct() {
                return new RailwayProduct();
            }

            public void cloneProduct(RailwayProduct source, RailwayProduct target) throws Exception {
                RailwayProductCloneHelper.clone((RailwayProduct)source, (RailwayProduct)target);
            }

            public void cloneProduct(RailwayProduct source, RailwayProduct target, Map<String, String> uidsMapping) throws Exception {
                RailwayProductCloneHelper.clone((RailwayProduct)source, (RailwayProduct)target, uidsMapping);
            }

            public void updateProduct(RailwayProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            public void updateProductsForCorrection(RailwayProduct source, RailwayProduct target, Map<String, String> uidsMapping) {
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
                if (target.getVendorVatDetalization() != null) {
                    FOPHelper.updateTaxesUids((List)target.getVendorVatDetalization().getComponents(), uidsMapping);
                }
            }

            public void resetTraveller(RailwayProduct target) {
                target.getPassengers().clear();
                target.getPassengerTypes().clear();
            }
        };
    }
}

