/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway;

import com.gridnine.xtrip.common.fx.railway.model.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.railway.helper.RailwayFXHelper;
import com.gridnine.xtrip.server.railway.model.helpers.clone.RailwayReferenceMcoCloneHelper;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RailwayReferenceMCOFXHandler
extends BaseProductFXHandler<RailwayReferenceMCO> {
    public Class<RailwayReferenceMCO> getProductClass() {
        return RailwayReferenceMCO.class;
    }

    public List<Message> recalculateFOP(RailwayReferenceMCO railwayProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return Collections.singletonList(Messages.getNotificationProductDontHaveThisOperation((String)railwayProduct.getSystemNumber(), (ProductType)ProductType.RAILWAY_REFERENCE_MCO));
    }

    public EntityReference<Organization> getSubAgency(RailwayReferenceMCO baseProduct) {
        BaseProduct relatedProduct = baseProduct.getRelatedProduct();
        if (relatedProduct instanceof RailwayProduct) {
            Map<PredefinedContractorType, EntityReference<Organization>> referenceMap = RailwayFXHelper.calculateSupplement((RailwayProduct)baseProduct.getRelatedProduct());
            return referenceMap.get(PredefinedContractorType.SUBAGENCY);
        }
        if (relatedProduct instanceof RailwayCrimeaMco) {
            return GeneralProductHelper.getContractor((SalesChain)GeneralProductHelper.getSalesChainByReflection((BaseProduct)relatedProduct), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
        }
        return null;
    }

    public List<Message> cloneProductToSameReservation(RailwayReferenceMCO source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation((BaseProduct)source, bookingFileContainer, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewReservation(RailwayReferenceMCO source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation((BaseProduct)source, bookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, (int)amount, (boolean)forwardAgencyMemo, this.createCloneHandler());
    }

    public List<Message> cloneProductToNewBookingFile(RailwayReferenceMCO source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile((BaseProduct)source, sourceBookingFileContainer, (GdsName)gdsName, (RecordLocatorType)recordLocatorType, (String)recordLocator, (String)systemNumber, targetBookingFileContainer, (int)amount, (boolean)forwardAgencyMemo, targetClient, (boolean)changeRetailPayer, this.createCloneHandler());
    }

    public List<Message> cloneProductForCorrection(RailwayReferenceMCO source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return RailwayReferenceMCOFXHandler.cloneProductForCorrection((BaseProduct)source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<RailwayReferenceMCO> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<RailwayReferenceMCO>(){
            final Date date = new Date();

            public RailwayReferenceMCO createProduct() {
                return new RailwayReferenceMCO();
            }

            public void cloneProduct(RailwayReferenceMCO source, RailwayReferenceMCO target) throws Exception {
                RailwayReferenceMcoCloneHelper.clone((RailwayReferenceMCO)source, (RailwayReferenceMCO)target);
            }

            public void cloneProduct(RailwayReferenceMCO source, RailwayReferenceMCO target, Map<String, String> uidsMapping) throws Exception {
                RailwayReferenceMcoCloneHelper.clone((RailwayReferenceMCO)source, (RailwayReferenceMCO)target, uidsMapping);
            }

            public void updateProduct(RailwayReferenceMCO target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            public void updateProductsForCorrection(RailwayReferenceMCO source, RailwayReferenceMCO target, Map<String, String> uidsMapping) {
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            public void resetTraveller(RailwayReferenceMCO target) {
            }
        };
    }
}

