/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.handler.supplement;

import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayCrimeaMCOUIData;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

class RailwayCrimeaMCOSupplementHandler
extends GeneralProductSupplementHandler
implements SupplementHandler<BookingFile, BookingFileUIData> {
    RailwayCrimeaMCOSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public Class<BookingFile> getEntityClass() {
        return BookingFile.class;
    }

    public Class<BookingFileUIData> getSupplementClass() {
        return BookingFileUIData.class;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof RailwayCrimeaMco).map(prod -> this.createProductUIData((RailwayCrimeaMco)prod, (BookingFile)ctr.getEntity())).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof RailwayCrimeaMco).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof RailwayCrimeaMCOUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((RailwayCrimeaMco)modelProducts.get(product.getRelatedProductUID()), (RailwayCrimeaMCOUIData)product);
            }
        });
    }

    private void saveData(RailwayCrimeaMco product, RailwayCrimeaMCOUIData productData) {
        RailwayCrimeaMcoHelper.setAgency((RailwayCrimeaMco)product, (EntityReference)productData.getAgency());
        RailwayCrimeaMcoHelper.setSubagency((RailwayCrimeaMco)product, (EntityReference)productData.getSubagency());
        RailwayCrimeaMcoHelper.setSupplier((RailwayCrimeaMco)product, (EntityReference)productData.getSupplier());
        this.convertUIFops(product, productData);
        this.saveContracts((BaseProduct)product, (BaseProductUIData)productData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)productData);
    }

    private void convertUIFops(RailwayCrimeaMco product, RailwayCrimeaMCOUIData productData) {
        List contractRelations = RailwayCrimeaMcoHelper.getContractRelations((RailwayCrimeaMco)product);
        contractRelations.forEach(relation -> this.saveCommissionsAndFeesAndFops((RailwayProductContractRelationData)relation, productData, product));
    }

    private void saveCommissionsAndFeesAndFops(RailwayProductContractRelationData relation, RailwayCrimeaMCOUIData supplement, RailwayCrimeaMco product) {
        ContractType relationContractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        List fops = relation.getFops();
        Map oldCommissions = relation.getCommissions().stream().collect(Collectors.toMap(BaseIdentity::getUid, UnaryOperator.identity()));
        relation.getFops().clear();
        relation.getCommissions().clear();
        supplement.getCommissionDiscountFeeHandlers().stream().filter(handler -> handler.getContractType().equals((Object)relationContractType)).forEach(handler -> {
            this.saveCommissions(handler.getCommissions(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
            this.saveFees(handler.getFees(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
        });
        supplement.getFopsList().stream().filter(productFopUIData -> productFopUIData.getContractType().equals((Object)relationContractType)).map(uiFop -> this.toFop((ProductFopUIData)uiFop, oldCommissions)).collect(Collectors.toCollection(() -> ((RailwayProductContractRelationData)relation).getFops()));
    }

    private RailwayProductFop toFop(ProductFopUIData productFopUIData, Map<String, GeneralProductCommission> commissions) {
        List fopCommissions = commissions.values().stream().filter(commission -> productFopUIData.getCommissionUids().contains(commission.getUid())).collect(Collectors.toList());
        RailwayProductFop result = new RailwayProductFop();
        result.setUid(productFopUIData.getUid());
        result.setAgent(productFopUIData.getAgent());
        result.setOperationDate(productFopUIData.getOperationDate());
        Money money = new Money();
        money.setValue(productFopUIData.getAmount());
        money.setCurrency(productFopUIData.getCurrency());
        result.setAmount(money);
        result.setPayer(productFopUIData.getPayer());
        result.setRefused(productFopUIData.isRefused());
        result.setType(productFopUIData.getPaymentType());
        result.getCommissions().addAll(fopCommissions);
        result.setCard(productFopUIData.getCard());
        return result;
    }

    private void saveFees(List<FeesUIData> uiFees, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, RailwayProductContractRelationData relation) {
        uiFees.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            this.convertUiAmount(result, uiCommission.getAmount(), uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setContractType(handler.getContractType());
            result.setCommissionProperties(uiCommission.getFeeProperty());
            return result;
        }).collect(Collectors.toCollection(() -> ((RailwayProductContractRelationData)relation).getCommissions()));
    }

    private void saveCommissions(List<CommissionsUIData> commissions, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, RailwayProductContractRelationData relation) {
        commissions.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            BigDecimal amount = uiCommission.getAmount();
            this.convertUiAmount(result, amount, uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setCommissionProperties(uiCommission.getCommissionProperty());
            result.setContractType(handler.getContractType());
            return result;
        }).collect(Collectors.toCollection(() -> ((RailwayProductContractRelationData)relation).getCommissions()));
    }

    private BaseProductUIData createProductUIData(RailwayCrimeaMco product, BookingFile entity) {
        RailwayCrimeaMCOUIData result = new RailwayCrimeaMCOUIData();
        EntityContainer spCont = EntityStorage.get().resolve((EntityReference)product.getValidator());
        if (spCont != null) {
            ((SalesPoint)spCont.getEntity()).getValidators().stream().filter(validator -> TextUtil.isSame((String)validator.getUid(), (String)product.getValidator().getNestedEntityUid())).findFirst().ifPresent(validator -> product.getValidator().setCaption(validator.getNumber()));
        }
        result.setRelatedProductUID(product.getUid());
        result.setSupplier(RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product));
        result.setTransportationType(RailwayCrimeaMcoHelper.getTransportationType((RailwayCrimeaMco)product));
        result.setAgency(RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product));
        result.setSubagency(RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product));
        result.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        result.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)result, (BaseProduct)product, entity);
        this.addCommissionsAndFops((BaseProductUIData)result, product);
        this.addContracts((BaseProductUIData)result, (BaseProduct)product);
        return result;
    }

    private void addCommissionsAndFops(BaseProductUIData uiData, RailwayCrimeaMco product) {
        List relations = RailwayCrimeaMcoHelper.getContractRelations((RailwayCrimeaMco)product);
        ArrayList handlers = new ArrayList();
        for (RailwayProductContractRelationData relation : relations) {
            List commissionsUidList = relation.getFops().stream().flatMap(fop -> ((List)fop.getValue("commissions")).stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
            List fopData = this.buildProductFopUIDataList((BaseContractRelationData)relation, product.getStatus(), commissionsUidList);
            uiData.getFopsList().addAll(fopData);
            this.updateHandlers((BaseProduct)product, handlers, (BaseContractRelationData)relation, relation.getCommissions(), false, null);
        }
        uiData.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    protected ProductFopUIData buildBaseProductFopUIData(Fop productFop) {
        ProductFopUIData fopUiData = super.buildBaseProductFopUIData(productFop);
        fopUiData.setCategory(this.categoryFor((RailwayProductFop)productFop));
        EntityReference agent = (EntityReference)productFop.getValue("agent");
        Date operationDate = (Date)productFop.getValue("operationDate");
        Boolean refused = (Boolean)productFop.getValue("refused");
        String relatedTicketNumber = (String)productFop.getValue("relatedTicketNumber");
        EntityReference payer = (EntityReference)productFop.getValue("payer");
        Money amount = ((RailwayProductFop)productFop).getAmount();
        if (amount != null) {
            fopUiData.setAmount(amount.getValue());
            fopUiData.setCurrency(amount.getCurrency());
        }
        fopUiData.setAgent(agent);
        fopUiData.setOperationDate(operationDate);
        fopUiData.setRefused(refused.booleanValue());
        fopUiData.setNumber(relatedTicketNumber);
        fopUiData.setPayer(payer);
        return fopUiData;
    }

    private ProductFopCategory categoryFor(RailwayProductFop productFop) {
        if (!RailwayProductHelper.isServiceFop((RailwayProductFop)productFop)) {
            for (GeneralProductCommission commission : productFop.getCommissions()) {
                if (commission.getCommissionProperties() == null) continue;
                Class type = commission.getCommissionProperties().getType();
                if (GeneralProductHelper.paymentFeePropertyTypes.contains(type)) {
                    return ProductFopCategory.PAYMENT_FEE;
                }
                if (!GeneralProductHelper.discountPropertyTypes.contains(type)) continue;
                return ProductFopCategory.DISCOUNT;
            }
            return ProductFopCategory.SERVICE_FEE;
        }
        return ProductFopCategory.PRODUCT;
    }
}

