/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.handler.supplement;

import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayMcoProductUIData;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class RailwayProductMcoSupplementHandler
extends GeneralProductSupplementHandler
implements SupplementHandler<BookingFile, BookingFileUIData> {
    public double getPriority() {
        return 30.0;
    }

    public Class<BookingFile> getEntityClass() {
        return BookingFile.class;
    }

    public Class<BookingFileUIData> getSupplementClass() {
        return BookingFileUIData.class;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof RailwayMcoProduct).map(prod -> this.createProductUIData((RailwayMcoProduct)prod, (BookingFile)ctr.getEntity())).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof RailwayMcoProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof RailwayMcoProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((RailwayMcoProduct)modelProducts.get(product.getRelatedProductUID()), (RailwayMcoProductUIData)product);
            }
        });
    }

    private void saveData(RailwayMcoProduct product, RailwayMcoProductUIData productData) {
        RailwayMcoProductHelper.setAgency((RailwayMcoProduct)product, (EntityReference)productData.getAgency());
        RailwayMcoProductHelper.setSubagency((RailwayMcoProduct)product, (EntityReference)productData.getSubagency());
        RailwayMcoProductHelper.setSupplier((RailwayMcoProduct)product, (EntityReference)productData.getSupplier());
        this.convertUIFops(product, productData);
        this.saveContracts((BaseProduct)product, (BaseProductUIData)productData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)productData);
    }

    private void convertUIFops(RailwayMcoProduct product, RailwayMcoProductUIData productData) {
        List contractRelations = RailwayMcoProductHelper.getContractRelations((RailwayMcoProduct)product);
        contractRelations.forEach(relation -> this.saveCommissionsAndFeesAndFops((GeneralProductContractRelationData)relation, productData));
    }

    private void saveCommissionsAndFeesAndFops(GeneralProductContractRelationData relation, RailwayMcoProductUIData supplement) {
        ContractType relationContractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        Map oldCommissions = relation.getCommissions().stream().collect(Collectors.toMap(BaseIdentity::getUid, UnaryOperator.identity()));
        relation.getFops().clear();
        relation.getCommissions().clear();
        supplement.getCommissionDiscountFeeHandlers().stream().filter(handler -> handler.getContractType().equals((Object)relationContractType)).forEach(handler -> {
            this.saveCommissions(handler.getCommissions(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
            this.saveFees(handler.getFees(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
        });
        supplement.getFopsList().stream().filter(productFopUIData -> productFopUIData.getContractType().equals((Object)relationContractType)).map(uiFop -> this.toFop((ProductFopUIData)uiFop, oldCommissions)).collect(Collectors.toCollection(() -> ((GeneralProductContractRelationData)relation).getFops()));
    }

    private GeneralProductFop toFop(ProductFopUIData productFopUIData, Map<String, GeneralProductCommission> commissions) {
        List fopCommissions = commissions.values().stream().filter(commission -> productFopUIData.getCommissionUids().contains(commission.getUid())).collect(Collectors.toList());
        GeneralProductFop result = new GeneralProductFop();
        result.setUid(productFopUIData.getUid());
        result.setAgent(productFopUIData.getAgent());
        result.setOperationDate(productFopUIData.getOperationDate());
        Money money = new Money();
        money.setValue(productFopUIData.getAmount());
        money.setCurrency(productFopUIData.getCurrency());
        result.setPayer(productFopUIData.getPayer());
        result.setRefused(productFopUIData.isRefused());
        result.setType(productFopUIData.getPaymentType());
        result.getCommissions().addAll(fopCommissions);
        result.setCard(productFopUIData.getCard());
        result.setEquivalentAmount(productFopUIData.getAmount());
        return result;
    }

    private void saveFees(List<FeesUIData> uiFees, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, GeneralProductContractRelationData relation) {
        uiFees.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            this.convertUiAmount(result, uiCommission.getAmount(), uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setContractType(handler.getContractType());
            result.setCommissionProperties(uiCommission.getFeeProperty());
            return result;
        }).collect(Collectors.toCollection(() -> ((GeneralProductContractRelationData)relation).getCommissions()));
    }

    private void saveCommissions(List<CommissionsUIData> commissions, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, GeneralProductContractRelationData relation) {
        commissions.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            BigDecimal amount = uiCommission.getAmount();
            this.convertUiAmount(result, amount, uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setCommissionProperties(uiCommission.getCommissionProperty());
            result.setContractType(handler.getContractType());
            return result;
        }).collect(Collectors.toCollection(() -> ((GeneralProductContractRelationData)relation).getCommissions()));
    }

    private BaseProductUIData createProductUIData(RailwayMcoProduct product, BookingFile entity) {
        RailwayMcoProductUIData result = new RailwayMcoProductUIData();
        result.setRelatedProductUID(product.getUid());
        result.setSupplier(RailwayMcoProductHelper.getSupplier((RailwayMcoProduct)product));
        result.setAgency(RailwayMcoProductHelper.getAgency((RailwayMcoProduct)product));
        result.setSubagency(RailwayMcoProductHelper.getSubagency((RailwayMcoProduct)product));
        result.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        result.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)result, (BaseProduct)product, entity);
        this.addCommissionsAndFops((BaseProductUIData)result, product);
        this.addContracts((BaseProductUIData)result, (BaseProduct)product);
        return result;
    }

    private void addCommissionsAndFops(BaseProductUIData uiData, RailwayMcoProduct product) {
        List relations = RailwayMcoProductHelper.getContractRelations((RailwayMcoProduct)product);
        ArrayList handlers = new ArrayList();
        for (GeneralProductContractRelationData relation : relations) {
            List commissionsUidList = relation.getFops().stream().flatMap(fop -> ((List)fop.getValue("commissions")).stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
            List fopData = this.buildProductFopUIDataList(relation, (BaseProduct)product, commissionsUidList);
            uiData.getFopsList().addAll(fopData);
            this.updateHandlers((BaseProduct)product, handlers, (BaseContractRelationData)relation, relation.getCommissions(), false, null);
        }
        uiData.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    private ProductFopCategory categoryFor(RailwayProductFop productFop) {
        if (!RailwayProductHelper.isServiceFop((RailwayProductFop)productFop)) {
            for (GeneralProductCommission commission : productFop.getCommissions()) {
                if (commission.getCommissionProperties() == null) continue;
                Class type = commission.getCommissionProperties().getType();
                if (GeneralProductHelper.paymentFeePropertyTypes.contains(type)) {
                    return ProductFopCategory.PAYMENT_FEE;
                }
                if (!GeneralProductHelper.discountPropertyTypes.contains(type)) continue;
                return ProductFopCategory.DISCOUNT;
            }
            return ProductFopCategory.SERVICE_FEE;
        }
        return ProductFopCategory.PRODUCT;
    }
}

