/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.handler.supplement;

import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayProductUIData;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

class RailwayProductSupplementHandler
extends GeneralProductSupplementHandler
implements SupplementHandler<BookingFile, BookingFileUIData> {
    RailwayProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public Class<BookingFile> getEntityClass() {
        return BookingFile.class;
    }

    public Class<BookingFileUIData> getSupplementClass() {
        return BookingFileUIData.class;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof RailwayProduct).map(prod -> this.createProductUIData((RailwayProduct)prod, (BookingFile)ctr.getEntity())).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof RailwayProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof RailwayProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((RailwayProduct)modelProducts.get(product.getRelatedProductUID()), (RailwayProductUIData)product);
            }
        });
    }

    private void saveData(RailwayProduct product, RailwayProductUIData productData) {
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)productData.getAgency());
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)productData.getSubagency());
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)productData.getSupplier());
        this.convertUIFops(product, productData);
        this.saveContracts((BaseProduct)product, (BaseProductUIData)productData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)productData);
    }

    private void convertUIFops(RailwayProduct product, RailwayProductUIData productData) {
        List contractRelations = RailwayProductHelper.getContractRelations((RailwayProduct)product);
        contractRelations.forEach(relation -> this.saveCommissionsAndFeesAndFops((RailwayProductContractRelationData)relation, productData, product));
    }

    private void saveCommissionsAndFeesAndFops(RailwayProductContractRelationData relation, RailwayProductUIData supplement, RailwayProduct product) {
        ContractType relationContractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        List fops = relation.getFops();
        Map oldCommissions = relation.getCommissions().stream().collect(Collectors.toMap(BaseIdentity::getUid, UnaryOperator.identity()));
        relation.getFops().clear();
        relation.getCommissions().clear();
        supplement.getCommissionDiscountFeeHandlers().stream().filter(handler -> handler.getContractType().equals((Object)relationContractType)).forEach(handler -> {
            this.saveCommissions(handler.getCommissions(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
            this.saveFees(handler.getFees(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
        });
        supplement.getFopsList().stream().filter(productFopUIData -> productFopUIData.getContractType().equals((Object)relationContractType)).map(uiFop -> this.toFop((ProductFopUIData)uiFop, oldCommissions)).collect(Collectors.toCollection(() -> ((RailwayProductContractRelationData)relation).getFops()));
    }

    private RailwayProductFop toFop(ProductFopUIData productFopUIData, Map<String, GeneralProductCommission> commissions) {
        List fopCommissions = commissions.values().stream().filter(commission -> productFopUIData.getCommissionUids().contains(commission.getUid())).collect(Collectors.toList());
        RailwayProductFop result = new RailwayProductFop();
        result.setUid(productFopUIData.getUid());
        result.setAgent(productFopUIData.getAgent());
        result.setOperationDate(productFopUIData.getOperationDate());
        result.setPayer(productFopUIData.getPayer());
        result.setRefused(productFopUIData.isRefused());
        result.setType(productFopUIData.getPaymentType());
        Money money = new Money();
        money.setValue(productFopUIData.getAmount());
        money.setCurrency(productFopUIData.getCurrency());
        result.setAmount(money);
        result.getCommissions().addAll(fopCommissions);
        result.setCard(productFopUIData.getCard());
        return result;
    }

    private void saveFees(List<FeesUIData> uiFees, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, RailwayProductContractRelationData relation) {
        uiFees.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            BigDecimal amount = uiCommission.getAmount();
            this.convertUiAmount(result, amount, uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setContractType(handler.getContractType());
            result.setCommissionProperties(uiCommission.getFeeProperty());
            return result;
        }).collect(Collectors.toCollection(() -> ((RailwayProductContractRelationData)relation).getCommissions()));
    }

    private void saveCommissions(List<CommissionsUIData> commissions, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, RailwayProductContractRelationData relation) {
        commissions.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            this.convertUiAmount(result, uiCommission.getAmount(), uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setCommissionProperties(uiCommission.getCommissionProperty());
            result.setContractType(handler.getContractType());
            return result;
        }).collect(Collectors.toCollection(() -> ((RailwayProductContractRelationData)relation).getCommissions()));
    }

    private BaseProductUIData createProductUIData(RailwayProduct product, BookingFile entity) {
        RailwayProductUIData result = new RailwayProductUIData();
        result.setRelatedProductUID(product.getUid());
        result.setSupplier(RailwayProductHelper.getSupplier((BaseProduct)product));
        result.setTransportationType(RailwayProductHelper.getTransportationType((RailwayProduct)product));
        result.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
        result.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
        result.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        result.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)result, (BaseProduct)product, entity);
        this.addCommissionsAndFops((BaseProductUIData)result, product);
        this.addContracts((BaseProductUIData)result, (BaseProduct)product);
        return result;
    }

    private void addCommissionsAndFops(BaseProductUIData uiData, RailwayProduct product) {
        List relations = RailwayProductHelper.getContractRelations((RailwayProduct)product);
        ArrayList handlers = new ArrayList();
        for (RailwayProductContractRelationData relation : relations) {
            List commissionsUidList = relation.getFops().stream().flatMap(fop -> ((List)fop.getValue("commissions")).stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
            List fopData = this.buildProductFopUIDataList((BaseContractRelationData)relation, product.getStatus(), commissionsUidList);
            uiData.getFopsList().addAll(fopData);
            this.updateHandlers((BaseProduct)product, handlers, (BaseContractRelationData)relation, relation.getCommissions(), false, null);
        }
        uiData.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    protected ProductFopUIData buildBaseProductFopUIData(Fop productFop) {
        ProductFopUIData fopUiData = super.buildBaseProductFopUIData(productFop);
        fopUiData.setCategory(RailwayProductHelper.getProductFopCategory((RailwayProductFop)((RailwayProductFop)productFop)));
        EntityReference agent = (EntityReference)productFop.getValue("agent");
        Date operationDate = (Date)productFop.getValue("operationDate");
        Boolean refused = (Boolean)productFop.getValue("refused");
        String relatedTicketNumber = (String)productFop.getValue("relatedTicketNumber");
        EntityReference payer = (EntityReference)productFop.getValue("payer");
        Money amount = ((RailwayProductFop)productFop).getAmount();
        if (amount != null) {
            fopUiData.setAmount(amount.getValue());
            fopUiData.setCurrency(amount.getCurrency());
        }
        fopUiData.setAgent(agent);
        fopUiData.setOperationDate(operationDate);
        fopUiData.setRefused(refused.booleanValue());
        fopUiData.setNumber(relatedTicketNumber);
        fopUiData.setPayer(payer);
        return fopUiData;
    }
}

