/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.handler.supplement;

import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayReferenceMCOUIData;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.railway.helper.RailwayFXHelper;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.Map;
import java.util.stream.Collectors;

class RailwayReferenceMCOProductSupplementHandler
extends GeneralProductSupplementHandler
implements SupplementHandler<BookingFile, BookingFileUIData> {
    RailwayReferenceMCOProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public Class<BookingFile> getEntityClass() {
        return BookingFile.class;
    }

    public Class<BookingFileUIData> getSupplementClass() {
        return BookingFileUIData.class;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof RailwayReferenceMCO).map(prod -> this.createRailwayReferenceMCOUIData((RailwayReferenceMCO)prod)).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof RailwayReferenceMCO).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof RailwayReferenceMCOUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((RailwayReferenceMCO)modelProducts.get(product.getRelatedProductUID()), (RailwayReferenceMCOUIData)product);
            }
        });
    }

    private void saveData(RailwayReferenceMCO railwayReferenceMCO, RailwayReferenceMCOUIData product) {
    }

    private RailwayReferenceMCOUIData createRailwayReferenceMCOUIData(RailwayReferenceMCO product) {
        RailwayReferenceMCOUIData result = new RailwayReferenceMCOUIData();
        result.setRelatedProductUID(product.getUid());
        BaseProduct relatedProduct = product.getRelatedProduct();
        if (relatedProduct instanceof RailwayProduct) {
            Map<PredefinedContractorType, EntityReference<Organization>> referenceMap = RailwayFXHelper.calculateSupplement((RailwayProduct)product.getRelatedProduct());
            result.setAgency(referenceMap.get(PredefinedContractorType.AGENCY));
            result.setSubagency(referenceMap.get(PredefinedContractorType.SUBAGENCY));
            result.setSupplier(referenceMap.get(PredefinedContractorType.SUPPLIER));
            result.setHasErrors(this.isHavingErrors(((RailwayProduct)relatedProduct).getValidationMessages(), (Identity)relatedProduct));
        } else if (relatedProduct instanceof RailwayCrimeaMco) {
            result.setAgency(GeneralProductHelper.getContractor((SalesChain)GeneralProductHelper.getSalesChainByReflection((BaseProduct)relatedProduct), (PredefinedContractorType)PredefinedContractorType.AGENCY));
            result.setSubagency(GeneralProductHelper.getContractor((SalesChain)GeneralProductHelper.getSalesChainByReflection((BaseProduct)relatedProduct), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY));
            result.setSupplier(GeneralProductHelper.getContractor((SalesChain)GeneralProductHelper.getSalesChainByReflection((BaseProduct)relatedProduct), (PredefinedContractorType)PredefinedContractorType.SUPPLIER));
            result.setHasErrors(this.isHavingErrors(((RailwayCrimeaMco)relatedProduct).getValidationMessages(), (Identity)relatedProduct));
        }
        return result;
    }
}

