/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.helper;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class RailwayMCOProductRefundHelper {
    public static void addSummaryMessages(RailwayMcoProduct product, EntityReference<BookingFile> bfRef, List<Message> messages) {
        SysLogHelper.audit(bfRef, (String)"entity-modification", (Message[])new Message[]{Messages.getNotificationProductAddedInOrder((String)BookingHelper.generateShortProductName((BaseProduct)product))});
        messages.add(Messages.getNotificationProductAddedInOrderN((String)BookingHelper.generateShortProductName((BaseProduct)product), bfRef));
    }

    public static RailwayMcoProduct createRefundProduct(RailwayMcoProduct product, ProductExchangeRefundProperties refundProperties) throws Exception {
        VatAmount vatAmount;
        Double rate;
        RailwayMcoProduct refundProduct = new RailwayMcoProduct();
        RailwayMcoProductHelper.copy((RailwayMcoProduct)product, (RailwayMcoProduct)refundProduct);
        Date issueDate = refundProperties.getOperationDate();
        EntityReference agent = refundProperties.getAgent();
        refundProduct.setStatus(ProductStatus.REFUND);
        product.setNextProduct(refundProduct);
        refundProduct.setPreviousProduct(product);
        refundProduct.setIssueDate(issueDate);
        refundProduct.setCashier(agent);
        BigDecimal usedEquivFare = refundProperties.getUsedEquivFare();
        BigDecimal equivFare = refundProduct.getEquivalentFare();
        BigDecimal equivVat = refundProduct.getEquivalentVat();
        if (MiscUtil.guarded((BigDecimal)usedEquivFare).compareTo(MiscUtil.guarded((BigDecimal)equivFare)) > 0) {
            usedEquivFare = equivFare;
        }
        BigDecimal newEquivFare = MiscUtil.sub((BigDecimal)equivFare, (BigDecimal[])new BigDecimal[]{usedEquivFare});
        refundProduct.setEquivalentFare(newEquivFare);
        if (MiscUtil.guarded((BigDecimal)usedEquivFare).compareTo(BigDecimal.ZERO) != 0 && MiscUtil.guarded((BigDecimal)equivFare).compareTo(BigDecimal.ZERO) != 0 && MiscUtil.guarded((BigDecimal)equivVat).compareTo(BigDecimal.ZERO) != 0 && (rate = (vatAmount = VatAmount.of((BigDecimal)equivFare, (BigDecimal)equivVat)).getVat()) != null) {
            VatAmount newVatAmount = VatAmount.of((BigDecimal)newEquivFare, (double)rate);
            refundProduct.setEquivalentVat(newVatAmount.getVatAmount());
        }
        refundProduct.setPenaltyFare(refundProperties.getPenalty());
        GeneralProductHelper.updateFops((BaseProduct)refundProduct);
        for (GeneralProductContractRelationData item : RailwayMcoProductHelper.getContractRelations((RailwayMcoProduct)refundProduct)) {
            for (GeneralProductFop fop : item.getFops()) {
                fop.setOperationDate(issueDate);
                fop.setAgent(agent);
            }
        }
        return refundProduct;
    }
}

