/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class RailwayProductRefundHelper {
    public static final String MCO_BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u041a\u0420\u0421";

    public static void addSummaryMessages(RailwayProduct product, EntityReference<BookingFile> bfRef, List<Message> messages) {
        SysLogHelper.audit(bfRef, (String)"entity-modification", (Message[])new Message[]{Messages.getNotificationProductAddedInOrder((String)BookingHelper.generateShortProductName((BaseProduct)product))});
        messages.add(Messages.getNotificationProductAddedInOrderN((String)BookingHelper.generateShortProductName((BaseProduct)product), bfRef));
    }

    public static void addSummaryMessages(RailwayReferenceMCO newProduct, RailwayProduct connectedWithProduct, EntityReference<BookingFile> bfRef, List<Message> messages) {
        SysLogHelper.audit(bfRef, (String)"entity-modification", (Message[])new Message[]{Messages.getNotificationReleatedAddedInOrder((String)BookingHelper.generateShortProductName((BaseProduct)newProduct), (String)BookingHelper.generateShortProductName((BaseProduct)connectedWithProduct))});
        messages.add(Messages.getNotificationReleatedAddedInOrderN((String)BookingHelper.generateShortProductName((BaseProduct)newProduct), (String)BookingHelper.generateShortProductName((BaseProduct)connectedWithProduct), bfRef));
    }

    public static RailwayProduct createRefundProduct(RailwayProduct product, ProductExchangeRefundProperties refundProperties, String agentCode) throws Exception {
        RailwayProduct refundProduct = new RailwayProduct();
        RailwayProductHelper.copy((RailwayProduct)product, (RailwayProduct)refundProduct, (boolean)false);
        Date issueDate = refundProperties.getOperationDate();
        BigDecimal totalEquivalentFare = refundProperties.getUsedEquivFare();
        EntityReference agent = refundProperties.getAgent();
        refundProduct.setIssueDate(issueDate);
        refundProduct.setCashier(agent);
        refundProduct.setStatus(ProductStatus.REFUND);
        refundProduct.setTotalEquivalentFare(totalEquivalentFare);
        refundProduct.setCompleted(false);
        refundProduct.getShipments().clear();
        refundProduct.getPrepaymentDocuments().clear();
        refundProduct.getFopDetalizations().clear();
        BigDecimal penaltyFare = null;
        if (totalEquivalentFare != null && product.getTotalEquivalentFare() != null) {
            penaltyFare = product.getTotalEquivalentFare().subtract(totalEquivalentFare);
        }
        BigDecimal penaltyVat = null;
        if (penaltyFare != null) {
            double vat = MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)issueDate)).doubleValue();
            VatAmount vatAmount = new VatAmount();
            vatAmount.setTotalVat(penaltyFare, vat);
            refundProduct.setPenalty(penaltyFare);
            refundProduct.setPenaltyVAT(penaltyVat);
        }
        BigDecimal refundTotalEquivalentVat = null;
        if (product.getTotalEquivalentVAT() != null) {
            refundTotalEquivalentVat = product.getTotalEquivalentVAT();
        }
        refundProduct.setTotalEquivalentVAT(refundTotalEquivalentVat);
        product.setNextProduct(refundProduct);
        refundProduct.setPreviousProduct(product);
        product.getReservation().getProducts().add(refundProduct);
        refundProduct.setEndorsement(null);
        refundProduct.setFareCalculationData(null);
        refundProduct.setChecked(false);
        refundProduct.setContractRulesApplied(false);
        RailwayProductHelper.updateFops((RailwayProduct)refundProduct);
        for (RailwayProductContractRelationData item : RailwayProductHelper.getContractRelations((RailwayProduct)refundProduct)) {
            for (RailwayProductFop fop : item.getFops()) {
                fop.setOperationDate(issueDate);
                fop.setAgent(agent);
            }
        }
        return refundProduct;
    }

    public static RailwayReferenceMCO createRailwayReferenceMCO(RailwayProduct refundProduct, String emdReferenceNumber, Date operationDate) {
        BlankType blankType;
        RailwayReferenceMCO mco = new RailwayReferenceMCO();
        mco.setSystemNumber(emdReferenceNumber);
        mco.setIssueDate(operationDate);
        mco.setStatus(ProductStatus.SELL);
        mco.setTicketType(TicketType.OWN);
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, MCO_BLANK_TYPE_CODE)) != null) {
            mco.setBlankType((DictionaryReference)blankType.toReference());
        }
        mco.setRelatedProduct((BaseProduct)refundProduct);
        mco.setReservation(refundProduct.getReservation());
        refundProduct.getReservation().getProducts().add(mco);
        return mco;
    }
}

