/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.rpc;

import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayCrimeaMCOUIData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayMcoProductUIData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayProductUIData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayReferenceMCOUIData;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayProductPrototypeService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Date;

public class RailwayProductPrototypeServiceImpl
extends BaseSecureServiceImpl
implements RailwayProductPrototypeService {
    public MiscUtil.Pair<RailwayProduct, RailwayProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, RailwayProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"RailwayProductPrototypeServiceImpl-getPrototypeData-railwayProduct");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : RailwayProductHelper.getAgency((RailwayProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : RailwayProductHelper.getSubagency((RailwayProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getCashier();
                RailwayProduct product = new RailwayProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
                RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setCashier(agent);
                RailwayProductUIData productSupplementData = new RailwayProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<RailwayCrimeaMco, RailwayCrimeaMCOUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, RailwayCrimeaMco lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"RailwayProductPrototypeServiceImpl-getPrototypeData-railwayCrimeaMco");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = lastProduct.getBlankOwner();
                EntityReference supplier = RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                DictionaryReference blankType = lastProduct.getBlankType();
                RailwayCrimeaMco product = new RailwayCrimeaMco();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwner(blankOwner);
                RailwayCrimeaMcoHelper.setSupplier((RailwayCrimeaMco)product, (EntityReference)supplier);
                RailwayCrimeaMcoHelper.setAgency((RailwayCrimeaMco)product, (EntityReference)agency);
                RailwayCrimeaMcoHelper.setSubagency((RailwayCrimeaMco)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                product.setBlankType(blankType);
                RailwayCrimeaMCOUIData productSupplementData = new RailwayCrimeaMCOUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<RailwayReferenceMCO, RailwayReferenceMCOUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, RailwayReferenceMCO lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"RailwayProductPrototypeServiceImpl-getPrototypeData-railwayProduct");
        try {
            this.checkContext(context);
            try {
                Date date = new Date();
                DictionaryReference blankType = lastProduct.getBlankType();
                RailwayReferenceMCO product = new RailwayReferenceMCO();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankType(blankType);
                RailwayReferenceMCOUIData productSupplementData = new RailwayReferenceMCOUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<RailwayMcoProduct, RailwayMcoProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, RailwayMcoProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"RailwayProductPrototypeServiceImpl-getPrototypeData-railwayMcoProduct");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : RailwayMcoProductHelper.getAgency((RailwayMcoProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : RailwayMcoProductHelper.getSubagency((RailwayMcoProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = lastProduct.getBlankOwnerRef();
                EntityReference supplier = RailwayMcoProductHelper.getSupplier((RailwayMcoProduct)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getCashier();
                DictionaryReference blankType = lastProduct.getBlankType();
                RailwayMcoProduct product = new RailwayMcoProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwnerRef(blankOwner);
                RailwayMcoProductHelper.setSupplier((RailwayMcoProduct)product, (EntityReference)supplier);
                RailwayMcoProductHelper.setAgency((RailwayMcoProduct)product, (EntityReference)agency);
                RailwayMcoProductHelper.setSubagency((RailwayMcoProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setCashier(agent);
                product.setBlankType(blankType);
                RailwayMcoProductUIData productSupplementData = new RailwayMcoProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

