/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.railway.rpc;

import com.gridnine.xtrip.common.fx.railway.rpc.RailwayService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.fx.railway.helper.RailwayFXHelper;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.railway.handlers.rules.RailwayRulesHandler;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductCommissionActionSet;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RailwayServiceImpl
extends BaseSecureServiceImpl
implements RailwayService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PredefinedContractorType, EntityReference<Organization>> getSupplement(ServiceInvocationContext ctx, RailwayProduct product) throws ServiceException {
        Map<PredefinedContractorType, EntityReference<Organization>> result = Collections.emptyMap();
        DebugUtil.setThreadName((String)"FxRailwayServiceImpl-getSupplement");
        try {
            this.checkContext(ctx);
            result = RailwayFXHelper.calculateSupplement(product);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public List<Message> recalculateVAT(ServiceInvocationContext ctx, EntityReference<BookingFile> ref, String prodUid) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-recalculateVAT");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (ctr == null) {
                result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", prodUid), (Object[])new Object[0]));
            } else {
                RailwayProduct product = (RailwayProduct)BookingHelper.findProductByUid((String)prodUid, (BookingFile)((BookingFile)ctr.getEntity()));
                if (product == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", prodUid), (Object[])new Object[0]));
                } else if (product.isDontRecalculateVAT()) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0414\u0421 \u0432 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0435\u0440\u0435\u0441\u0441\u0447\u0438\u0442\u0430\u043d", (Object[])new Object[0]));
                } else if (result.isEmpty() && product != null) {
                    product.setTotalEquivalentVAT(null);
                    product.setServiceVAT(null);
                    product.setEquivalentVAT(null);
                    product.setServiceVAT(null);
                    EntityStorageThreadContext.execute(() -> {
                        ctr.getVersionInfo().setDataSource("fx-recalculateVAT");
                        EntityStorageThreadContext.setActionSource((EntityStorageThreadContext.ActionSource)EntityStorageThreadContext.ActionSource.MIDOFFICE_CLIENT_FX);
                        EntityStorage.get().save(ctr, true);
                    });
                }
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public Collection<EntityReference<TemplateDocument>> getTemplateDocuments(ServiceInvocationContext ctx, NestedEntityReference<BookingFile, RailwayProduct> productReference) {
        EntityContainer bfContainer = EntityStorage.get().resolve(productReference);
        if (bfContainer == null) {
            return Collections.emptyList();
        }
        RailwayProduct product = (RailwayProduct)EntityStorageHelper.findNestedEntity((BaseEntity)bfContainer.getEntity(), productReference);
        if (product == null) {
            return Collections.emptyList();
        }
        RailwayRulesHandler.RailwayRulesProductHandler railwayHandler = new RailwayRulesHandler.RailwayRulesProductHandler();
        railwayHandler.setAfterRulesAppliedConsumer(prod -> {});
        try {
            RuleProxy ruleProxy = GeneralProductRulesHelper.applyRules((BaseProduct)product, (EntityContainer)bfContainer, (RulesProductHandler)railwayHandler, new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true);
            if (ruleProxy != null) {
                return ((RailwayProductCommissionActionSet)ruleProxy.getActionSet()).getReceiptTemplates();
            }
        }
        catch (Exception e) {
            this.log.error("failed to apply rules", (Throwable)e);
        }
        return Collections.emptyList();
    }
}

